import es, gamethread, cPickle, os.path, popuplib, random
from math import sqrt

effects = 1
# Requires ESTools!!!
# Shows a line of the jump path 
# 1 = On
# 0 = Off

effect_timer = 4
# Amount of seconds the effect stays for before it disapears

effects_layers = 3
# Amount of layers of tracking beams.
# Maximum layers is 3
# Each layer is random colours each jump
# Each layer path is directly above the other
# In my opinion 3 looks the nicest

message_every_jump = 0
# Send a message to the user telling him the distance of every jump?
# 1 = on
# 2 = off

message_over_distance = 150
# If message_every_jump is set to 0, then set this to over a certain amount
# To send a message to the user when he gets over a certain amount of game units...
# 150 + is above average jump. + 200 is a fairly good jump.

max_distance = 250
# The maximum a player is allowed to have his jump recoreded.
# If the jump is bigger than this, most likely either settings are wrong,
# Or he is cheating the checks in some way or another either with speed
# Hacks or some other means. 250 is a Very good normal jump, I think
# It's impossible to reach. 200 is a good jump; 150 is about an average jump.

################################
##### DO NOT EDIT BELOW ########
################################

info = es.AddonInfo()
info.name = "jumpstats"
info.version = "2.0"
info.author = "Freddukes"
info.url = "http://forums.mattie.info/cs"
info.description = "Allows you to record your longest jumps"

jumpstats = es.ServerVar("jumpstats",info.version).makepublic()

players = {}

def load():
    global players
    str_path = es.getAddonPath('jumpstats') + '/players.db'
    if os.path.isfile(str_path):
        file_users = open(str_path)
        players = cPickle.load(file_users)
        file_users.close() 
    else:
        es.dbgmsg(0,'ERROR: No players.db found! Creating one now.')
    p = popuplib.create('ljhelp')
    p.addline('=== Long Jump Help ===')
    p.addline('-----------------')
    p.addline('This script records your best jumps')
    p.addline('And records them in a database.')
    p.addline(' ')
    p.addline('=== Commands ===')
    p.addline(' ')
    p.addline('/lj10 - Displays the top10 jumpers')
    p.addline('/ljhelp - Displays this popup')
    p.addline('/ljpopup - Toggles the popup display on or off')
    p.addline('/ljrank - Displays your rank and best jump to the server')
    p.addline('/ljrank <partial name of another person> - Displays their rank')
    es.server.cmd('echo Loading Finished: jumpstats is up and running.')
    
def player_activate(event_var):
    global players
    if not players.has_key(event_var['es_steamid']):
        players[event_var['es_steamid']] = {'best_distance':0,'jumped':0,'name':event_var['es_username'],'popup':1}
    else:
        players[event_var['es_steamid']]['jumped'] = 0
        players[event_var['es_steamid']]['name'] = event_var['es_username']
    
def player_jump(event_var):
    if not players[event_var['es_steamid']]['jumped']:
        location = es.getplayerlocation(event_var['userid'])
        red = random.randint(0,255)
        green = random.randint(0,255)
        blue = random.randint(0,255)
        red1 = random.randint(0,255)
        green1 = random.randint(0,255)
        blue1 = random.randint(0,255)
        gamethread.delayed(0.01,check_landed_loop,(event_var['userid'],event_var['es_steamid'],location,0,location[2],red,green,blue,red1,green1,blue1))
    else:
        name = str(event_var['userid'])
        gamethread.cancelDelayed(name)
        gamethread.delayedname(1,name,remove_bh_protection,event_var['es_steamid'])

def round_start(event_var):
    es.msg('#multi','#greenType #lightgreen/ljhelp #greento see help about the Long Jump plugin')

def round_end(event_var):
    global players
    filepath = open(es.getAddonPath('jumpstats') + '/players.db', 'w')
    cPickle.dump(players, filepath)
    filepath.close() 

def player_say(event_var):
    global players
    uid = event_var['userid']
    text = event_var['text']
    if text == '/ljtop10':
        a = sorted(players.iteritems(), key=lambda (k,v):(v,k), reverse=True)
        index = -1
        top10 = popuplib.create('top10')
        top10.addline('Top 10 Jumpers')
        top10.addline(' ')
        while index < 9:
            index = index + 1
            try:
                steam = a[index][0]
                name = players[steam]['name']
                bestjump = '%.2f'%players[steam]['best_distance']
                meters = float(bestjump) / 40
                meters = '%.2f'%meters
                index_temp = index + 1
                format = '%s. %s - %s units (%sm)'%(index_temp, name, bestjump, meters)
                top10.addline(format)
            except IndexError:
                pass
        top10.addline(' ')
        top10.addline('0. Cancel')
        popuplib.send('top10',uid)
    elif text == '/ljpopup':
        if not players[event_var['es_steamid']]['popup']:
            players[event_var['es_steamid']]['popup'] = 1
            es.tell(uid,'#multi','#greenYour Popup display menu is turned #lightgreenOn. #greenType #lightgreen\'/ljpopup\' #greento turn it #lightgreenOff.')
        else: 
            players[event_var['es_steamid']]['popup'] = 0
            es.tell(uid,'#multi','#greenYour Popup display menu is turned #lightgreenOff. #greenType #lightgreen\'/ljpopup\' #greento turn it #lightgreenOn.')
    elif text == '/ljhelp':
        popuplib.send('ljhelp',uid)
    text = text.split()
    if text[0] == '/ljrank':
        try:
            user = es.getuserid(text[1])
            if user:
                usteam = es.getplayersteamid(user)
                uname = es.getplayername(user)
                rank(user,usteam,uname)
        except IndexError:
            rank(uid,event_var['es_steamid'],event_var['es_username'])
            
            
def rank(uid,usteam,uname):
    a = sorted(players, mysort)
    position = a.index(usteam)
    position = position + 1
    total_players = len(a)
    distance = players[usteam]['best_distance']
    es.msg('#multi','#greenPlayer #lightgreen%s #greenis ranked #lightgreen%s/%s #greenplayers with a max jump of #lightgreen%.2f #greenunits.'%(uname,position,total_players,distance))

def check_landed_loop(uid,usteam,location,total_distance,z,red,green,blue,red1,green1,blue1):
    new_location = es.getplayerlocation(uid)
    check = es.getplayerprop(uid,'CBasePlayer.m_fFlags')
    distance = sqrt((location[0] - new_location[0]) ** 2 + (location[1] - new_location[1]) ** 2)
    total_distance = total_distance + distance
    if effects:
        if effects_layers > 0:
            es.server.cmd('est_effect 3 #a 0 sprites/lgtning.vmt %s %s %s %s %s %s %s 2 2 %s %s %s 255'%(location[0],location[1],z,new_location[0],new_location[1],z,effect_timer,red,green,blue))
        if effects_layers > 1:
            es.server.cmd('est_effect 3 #a 0 sprites/lgtning.vmt %s %s %s %s %s %s %s 2 2 %s %s %s 255'%(location[0],location[1],z + 3,new_location[0],new_location[1],z + 3,effect_timer,red1,green1,blue1))
        if effects_layers > 2:
            es.server.cmd('est_effect 3 #a 0 sprites/lgtning.vmt %s %s %s %s %s %s %s 2 2 %s %s %s 255'%(location[0],location[1],z + 6,new_location[0],new_location[1],z + 6,effect_timer,red1,green,blue1))
    if check & 1:
        new_location_z = new_location[2]
        if new_location_z < 0:
            new_location_z = new_location[2] * -1
        if z < 0:
            z1 = z * -1
        check_temp = z1 - new_location_z
        if check_temp < 0:
            check_temp = check_temp * -1
        if check_temp <= 25:
            global players
            if message_every_jump and total_distance < max_distance:
                es.tell(uid,'#multi','#greenYou have jumped #lightgreen%.2f #greenUnits'%total_distance)
                if players[usteam]['popup']:
                    best_distance = players[usteam]['best_distance']
                    suid = 'stats_%s'%uid
                    if popuplib.exists(suid):
                        popuplib.close(suid,uid)
                        popuplib.delete(suid)
                        gamethread.delayed(2,send_popup,(suid,uid,total_distance,best_distance))
                    else:
                        gamethread.delayed(2,send_popup,(suid,uid,total_distance,best_distance))
            elif not message_every_jump and message_over_distance > 0:
                if total_distance >= message_over_distance and total_distance < max_distance:
                    es.tell(uid,'#multi','#greenYou have jumped #lightgreen%.2f #greenUnits'%total_distance)
                    best_distance = players[usteam]['best_distance']
                    if players[usteam]['popup']:
                        suid = 'stats_%s'%uid
                        if popuplib.exists(suid):
                            popuplib.close(suid,uid)
                            popuplib.delete(suid)
                            gamethread.delayed(2,send_popup,(suid,uid,total_distance,best_distance))
                        else:
                            gamethread.delayed(2,send_popup,(suid,uid,total_distance,best_distance))
            if total_distance > best_distance and total_distance < max_distance:
                es.centertell(uid,'New Long Jump Record!!! %.2f'%total_distance)
                players[usteam]['best_distance'] = total_distance
                es.cexec(uid,'playgamesound','ambient/machines/teleport4.wav')
            players[usteam]['jumped'] = 1
            name = str(uid)
            gamethread.delayedname(2,name,remove_bh_protection,usteam)
    else:
        gamethread.delayed(0.01,check_landed_loop,(uid,usteam,new_location,total_distance,z,red,green,blue,red1,green1,blue1))
        
def remove_bh_protection(usteam):
    global players
    players[usteam]['jumped'] = 0

def send_popup(suid,uid,total_distance,best_distance):
    a = sorted(players, mysort)
    position = a.index(es.getplayersteamid(uid))
    position = position + 1
    total_players = len(a)
    meters = float(best_distance) / 40
    meters = '%.2f'%meters
    tmeters = float(total_distance) / 40
    tmeters = '%.2f'%tmeters
    stats = popuplib.create(suid)
    stats.addline('=== Jump Stats ===')
    stats.addline('-------------------')
    stats.addline('Total Distance')
    stats.addline(' ')
    stats.addline(' %.2f (%sm)'%(total_distance,tmeters))
    stats.addline('-------------------')
    stats.addline('Best Distance')
    stats.addline(' ')
    if total_distance > best_distance and total_distance < max_distance:
        stats.addline(' %.2f (%sm)'%(total_distance,tmeters))
    else:
        stats.addline(' %.2f (%sm)'%(best_distance,meters))
    stats.addline('-------------------')
    stats.addline('Position')
    stats.addline(' ')
    stats.addline('Rank %s/%s Players'%(position, total_players))
    stats.addline('-------------------')
    stats.addline('0. Cancel')
    popuplib.send(suid,uid)
    
def mysort(item1, item2):
    if players[item1]['best_distance'] > players[item2]['best_distance']: return -1
    if players[item1]['best_distance'] > players[item2]['best_distance']: return 0
    return 1
