# CSSoundtrack release 7 by David Bowland
# ./addons/eventscripts/cssoundtrack/cssoundtrack.py

# >>> To configure this addon please see cssoundtrack.cfg <<<

"""
Plays music that changes with game events. Requires only ES 2.0+
"""


import es
import gamethread
import langlib
import os.path
import playerlib
import random
import time


info = es.AddonInfo()
info.name = 'CSSoundtrack'
info.version = '7'
info.url = 'http://addons.eventscripts.com/addons/view/cssoundtrack'
info.basename = 'cssoundtrack'
info.author = 'SuperDave'


int_delay_count = 0
dict_music_downloads = {}
dict_music = {'slow':{}, 'fast':{}, 'stinger':{}}
dict_delays = {}
dict_hostages = {'following':[], 'total':1}
dict_players_in_combat = {}
dict_blind_players = {}
dict_players = {}


dict_events = {'cssoundtrack_combat':{'userid':'short', 'action':'string'}, 'cssoundtrack_music':{'userid':'short', 'sound':'string', 'duration':'float', 'title':'string', 'type':'string', 'old_type':'string'}}
dict_options = {'cssoundtrack_change_combatpercent':[40, 'Percent of living players in combat required for fast music'], 'cssoundtrack_change_bomb':[1, '0 = no change, 1 = force fast music when the bomb is planted'], 'cssoundtrack_change_hostagepercent':[75, 'Percent of hostages following players required for fast music--set to 0 to eliminate'], 'cssoundtrack_change_combathostages':[1, '0 = no change, 1 = getting a hostage to follow counts as a player in combat'], 'cssoundtrack_change_individual':[1, '0 = music is the same for all players, 1 = players hear general music but are forced to fast music when in combat, 2 = music is played individually for all players'], 'cssoundtrack_change_individual_stinger':[1, '0 = play stingers only at the end of the round, 1 = play stingers at the end of the round and to players when they die, 2 = play stingers to players only once per round (death or round end), 3 = play stingers only to players when they die'], 'cssoundtrack_delay_overlap':[3.5, 'Number of seconds music overlaps with next and previous music'], 'cssoundtrack_delay_min_length':[7, 'Minumum number of seconds music will play before changing'], 'cssoundtrack_delay_combat':[15, 'Number of seconds after combat a player is still considered in combat'], 'cssoundtrack_volume_fast':[0.8, 'Volume of fast music from 0.0 to 1.0'], 'cssoundtrack_volume_slow':[0.8, 'Volume of slow music from 0.0 to 1.0'], 'cssoundtrack_volume_stinger':[0.8, 'Volume of stingers from 0.0 to 1.0'], 'cssoundtrack_announce_chat':[1, '0 = no change, 1 = announce music length and path on the console, 2 = announce music length and path in chat area'], 'cssoundtrack_announce_hud':[0, '0 = no change, 1 = announce music length and path in a HUD message']}
func_lang_text = None


def load():
   """
   Creates server commands
   Ensures critical server variables are created by the config
   Calls load_events
   Calls player_spawn for every connected player
   Calls round_start
   """
   global func_lang_text

   if not es.exists('command', 'cssoundtrack_add'):
      es.regcmd('cssoundtrack_add', 'cssoundtrack/music_cmd', 'cssoundtrack_add <fast/slow/stinger> <sound file relative to ./sound> <duration> [0 = force client download (default), 1 = no client download] [\"song title\"]\nServer command for adding music to CSSoundtrack')
   if not es.exists('command', 'cssoundtrack_remove'):
      es.regcmd('cssoundtrack_remove', 'cssoundtrack/music_cmd', 'cssoundtrack_remove <fast/slow/stinger> <sound file relative to ./sound>\nServer command for removing music from CSSoundtrack')
   if not es.exists('command', 'cssoundtrack_setcombat'):
      es.regcmd('cssoundtrack_setcombat', 'cssoundtrack/setcombat_cmd', 'cssoundtrack_setcombat <userid/name/\"Steam ID\">\nServer command for designating a player as in combat')

   for str_option in dict_options:
      es.ServerVar(str_option, dict_options[str_option][0], dict_options[str_option][1])
   if os.path.isfile(es.getAddonPath('cssoundtrack') + '/cssoundtrack.cfg'):
      es.server.cmd('es_xmexec ../addons/eventscripts/cssoundtrack/cssoundtrack.cfg')
   else:
      es.dbgmsg(0, 'CSSoundtrack: Unable to load cssoundtrack.cfg! Please ensure it is in the ./cssoundtrack/ directory.')

   str_lang_path = es.getAddonPath('cssoundtrack') + '/cssoundtrack_languages.ini'
   if os.path.isfile(str_lang_path):
      func_lang_text = langlib.Strings(str_lang_path)
   else:
      es.dbgmsg(0, 'CSSoundtrack: Unable to load cssoundtrack_languages.ini! Please ensure it is in the ./cssoundtrack/ directory.')
   if not func_lang_text:
      func_lang_text = missing_lang

   load_events()

   for int_userid in es.getUseridList():
      player_spawn({'userid':str(int_userid)})

   round_start({})


def es_map_start(event_var):
   """
   Marks sounds for download
   Calls load_events
   Calls clear_delays
   """
   global dict_players

   for str_path in dict_music_downloads:
      es.stringtable('downloadables', 'sound/%s' % str_path)

   load_events()

   clear_delays(False)
   dict_players.clear()


def round_start(event_var):
   """
   Calls clear_delays
   Resets hostage, players in combat, and blinded players data
   Calls change_music
   """
   global dict_hostages
   global dict_players_in_combat
   global dict_blind_players

   clear_delays()

   dict_hostages['following'][:] = []
   dict_hostages['total'] = len(es.createentitylist('hostage_entity').keys())
   if not dict_hostages['total']:
      dict_hostages['total'] = 1
   dict_players_in_combat.clear()
   dict_blind_players.clear()

   change_music(bool_interrupted=False)


def round_end(event_var):
   """Calls change_music to play the end-of-round stinger"""
   if dict_music['stinger'] and int(es.ServerVar('cssoundtrack_change_individual_stinger')) in (0, 1, 2):
      change_music(bool_stinger=True)


def player_spawn(event_var):
   """
   Creates the player in dict_players
   Calls play_sound to initialize global music if possible
   """
   global dict_players

   int_userid = int(event_var['userid'])
   if not dict_players.has_key(int_userid):
      dict_players[int_userid] = {'protected_delay':False, 'protected_time':0, 'played_stinger':False, 'endmusic':False, 'sound':'', 'type':'', 'old_sound':'', 'lastsound':{'fast':'', 'slow':'', 'stinger':''}}

      if dict_players.has_key('global'):
         dict_global_player = dict_players['global']
         play_sound(int_userid, dict_global_player['sound'], dict_global_player['type'], False)


def player_blind(event_var):
   """Adds the blinded player to the dictionary of blinded players"""
   global dict_blind_players

   dict_blind_players[int(event_var['userid'])] = int(event_var['es_userteam'])


def player_hurt(event_var):
   """Calls add_combat for the victim and attacker if they were opponents"""
   int_attacker = int(event_var['attacker'])
   if int_attacker and event_var['es_userteam'] <> event_var['es_attackerteam']:
      add_combat([int(event_var['userid']), int_attacker])


def player_death(event_var):
   """Calls change_music to play a stinger for the dead player"""
   int_userid = int(event_var['userid'])
   if int(es.ServerVar('cssoundtrack_change_individual_stinger')) in {False:(1, 2, 3), True:(1, 3)}[dict_players[int_userid]['played_stinger']] and dict_music['stinger'].keys():
      change_music((int_userid, ), bool_stinger=True)


def player_disconnect(event_var):
   """Removes any delays for the disconnecting player"""
   global dict_players

   int_userid = int(event_var['userid'])
   if dict_players.has_key(int_userid):
      dict_current_player = dict_players[int_userid]
      if dict_current_player['old_sound']:
         gamethread.cancelDelayed('cssoundtrack_fade_%s' % int_userid)
      if dict_current_player['endmusic']:
         gamethread.cancelDelayed('cssoundtrack_endmusic_%s' % int_userid)
      if dict_current_player['protected_delay']:
         gamethread.cancelDelayed('cssoundtrack_protected_%s' % int_userid)
      del dict_players[int_userid]


def flashbang_detonate(event_var):
   """Calls add_combat for the player and blinded opponents if at least one opponent was blinded"""
   global dict_blind_players

   int_team = int(event_var['es_userteam'])
   list_combat_players = filter(lambda int_userid: dict_blind_players[int_userid] == 5 - int_team, dict_blind_players)
   if list_combat_players:
      add_combat([int(event_var['userid'])] + list_combat_players)
   dict_blind_players.clear()


def bomb_planted(event_var):
   """Calls change_music"""
   if int(es.ServerVar('cssoundtrack_change_bomb')) and dict_players['global']['type'] == 'slow':
      change_music()


def hostage_follows(event_var):
   """
   Marks the player as in combat
   Adds the hostage to the list of following hostages
   Calls change_musc
   """
   global dict_hostages

   if int(es.ServerVar('cssoundtrack_change_combathostages')):
      tuple_userid = (int(event_var['userid']), )
      add_combat(tuple_userid)
      change_music(tuple_userid)

   int_hostage = int(event_var['hostage'])
   if int_hostage not in dict_hostages['following']:
      dict_hostages['following'].append(int_hostage)

      int_hostage_percent = int(es.ServerVar('cssoundtrack_change_hostagepercent'))
      if int_hostage_percent and len(dict_hostages['following']) * 100. / dict_hostages['total'] >= int_hostage_percent and dict_players['global']['type'] == 'slow':
         change_music()


def hostage_stops_following(event_var):
   """
   Removes the hostage from the list of following hostages
   Calls change_music
   """
   global dict_hostages

   int_hostage = int(event_var['hostage'])
   if int_hostage in dict_hostages['following']:
      dict_hostages['following'].remove(int_hostage)

      if len(dict_hostages['following']) * 100. / dict_hostages['total'] < int(es.ServerVar('cssoundtrack_change_hostagepercent')) and dict_players['global']['type'] == 'fast':
         change_music()


def hostage_rescued(event_var):
   """
   Removes the hostage from the remaining hostage count
   Calls change_music
   """
   global dict_hostages

   if dict_hostages['total'] > 1:
      dict_hostages['total'] -= 1

      if len(dict_hostages['following']) * 100. / dict_hostages['total'] < int(es.ServerVar('cssoundtrack_change_hostagepercent')) and dict_players['global']['type'] == 'fast':
         change_music()


def unload():
   """Calls clear_delays"""
   clear_delays()

   for str_option in dict_options:
      es.ServerVar(str_option).set(0)


def change_music(list_users=None, bool_stinger=False, bool_interrupted=True):
   """
   Creates the global "player"
   Determines if the global music is fast or slow
   Retrieves a new sound if the type of music changed or the music ended
   Creates a delay to call this function for a new sound when the current sound ends
   Loops through each passed player (all players if none were passed) and determines the correct music
      - Stinger
      - Global music
      - Independent music
      - Global/independent mix
   Calls play_sound for each player with the new sound
   """
   global dict_players

   if not dict_players.has_key('global'):
      dict_players['global'] = {'type':'', 'sound':'', 'lastsound':{'fast':'', 'slow':''}}
   dict_global_player = dict_players['global']

   int_hostage_percent = int(es.ServerVar('cssoundtrack_change_hostagepercent'))
   bool_objective_music = (es.getentityindex('planted_c4') <> -1 and int(es.ServerVar('cssoundtrack_change_bomb'))) or (len(dict_hostages['following']) * 100. / dict_hostages['total'] >= int_hostage_percent and int_hostage_percent)
   if len(dict_players_in_combat) > (es.getlivingplayercount() * es.ServerVar('cssoundtrack_change_combatpercent')) / 100. or bool_objective_music:
      str_new_type = 'fast'
   else:
      str_new_type = 'slow'

   if (str_new_type <> dict_global_player['type'] or not bool_interrupted) and not bool_stinger:
      if bool_interrupted and dict_global_player['sound']:
         gamethread.cancelDelayed('cssoundtrack_endmusic_global')
      list_users = None

      list_possible_sounds = dict_music[str_new_type].keys()
      str_last_sound = dict_global_player['lastsound'][str_new_type]
      if str_last_sound in list_possible_sounds and len(list_possible_sounds) > 1:
         list_possible_sounds.remove(str_last_sound)
      if list_possible_sounds:
         dict_global_player['type'] = str_new_type
         str_last_sound = dict_global_player['sound'] = dict_global_player['lastsound'][str_new_type] = random.choice(list_possible_sounds)
         gamethread.delayedname(dict_music[str_new_type][str_last_sound]['duration'] - es.ServerVar('cssoundtrack_delay_overlap'), 'cssoundtrack_endmusic_global', change_music, kw={'bool_interrupted':False})
      else:
         dict_global_player['type'] = dict_global_player['sound'] = dict_global_player['lastsound'][str_new_type] = ''

   if not list_users:
      list_users = es.getUseridList()
   str_global_type = dict_global_player['type']
   str_global_sound = dict_global_player['sound']
   int_independent_option = int(es.ServerVar('cssoundtrack_change_individual'))
   int_stinger_option = int(es.ServerVar('cssoundtrack_change_individual_stinger'))
   str_new_type = None

   for int_userid in list_users:
      if dict_players.has_key(int_userid):
         dict_current_player = dict_players[int_userid]
         str_new_sound = None
         if bool_stinger:
            if int_stinger_option not in {False:(0, 1, 2, 3), True:(1, )}[dict_current_player['played_stinger']]:
               continue
            str_new_type = 'stinger'
            list_possible_sounds = dict_music['stinger'].keys()
            if list_possible_sounds:
               str_last_sound = dict_current_player['lastsound']['stinger']
               if str_last_sound in list_possible_sounds and len(list_possible_sounds) > 1:
                  list_possible_sounds.remove(str_last_sound)
               dict_current_player['lastsound']['stinger'] = str_new_sound = random.choice(list_possible_sounds)
            else:
               dict_current_player['lastsound']['stinger'] = str_new_sound = ''
            bool_end_delay = True

         elif not int_independent_option or es.getplayerteam(int_userid) in (0, 1):
            if str_global_sound <> dict_current_player['sound']:
               str_new_sound = str_global_sound
               str_new_type = str_global_type
               bool_end_delay = False

         elif int_independent_option == 2:
            str_new_type = {False:'slow', True:'fast'}[dict_players_in_combat.has_key(int_userid) or bool_objective_music]
            if dict_current_player['type'] <> str_new_type:
               str_last_sound = dict_current_player['lastsound'][str_new_type]
               list_possible_sounds = dict_music[str_new_type].keys()
               if list_possible_sounds:
                  if str_last_sound in list_possible_sounds and len(list_possible_sounds) > 1:
                     list_possible_sounds.remove(str_last_sound)
                  str_new_sound = random.choice(list_possible_sounds)
               else:
                  str_new_sound = ''
               bool_end_delay = True

         else:
            str_new_type = {False:'slow', True:'fast'}[dict_players_in_combat.has_key(int_userid) or str_global_type == 'fast']
            if dict_current_player['type'] <> str_new_type:
               str_last_sound = dict_current_player['lastsound'][str_new_type]
               if str_global_type == str_new_type and str_last_sound <> str_global_sound:
                  str_new_sound = str_global_sound
                  bool_end_delay = False
               else:
                  list_possible_sounds = dict_music[str_new_type].keys()
                  if str_last_sound in list_possible_sounds and len(list_possible_sounds) > 1:
                     list_possible_sounds.remove(str_last_sound)
                  if list_possible_sounds:
                     str_new_sound = random.choice(list_possible_sounds)
                  else:
                     str_new_sound = ''
                  bool_end_delay = True
            elif not dict_current_player['endmusic'] and dict_current_player['sound'] <> str_global_sound:
               str_new_sound = str_global_sound
               str_new_type = str_global_type
               bool_end_delay = False

         if not str_new_sound is None:
            play_sound(int_userid, str_new_sound, str_new_type, bool_end_delay)


def play_sound(int_userid, str_sound, str_type, bool_end_delay=True):
   """
   Renews the protection delay for the current sound if the current player is in protected time
   Stops any sound with an overlap (fade) delay and cancels the delay
   Starts a new overlap delay for the current sound
   Plays the new sound and starts a delay for the next sound when the new sound is over
   Starts a protection delay
   Announces the new sound to the player
   Fires cssoundtrack_music
   """
   global dict_players

   dict_current_player = dict_players[int_userid]
   float_overlap = float(es.ServerVar('cssoundtrack_delay_overlap'))

   if dict_current_player['protected_delay']:
      gamethread.cancelDelayed('cssoundtrack_protected_%s' % int_userid)
      float_time_difference = dict_current_player['protected_time'] - time.time()
      if str_type <> 'stinger' and float_time_difference > 0:
         gamethread.delayedname(float_time_difference, 'cssoundtrack_protected_%s' % int_userid, end_protected, (int_userid, play_sound, (int_userid, str_sound, str_type, bool_end_delay)))
         return
      dict_current_player['protected_delay'] = False

   if dict_current_player['old_sound']:
      gamethread.cancelDelayed('cssoundtrack_fade_%s' % int_userid)
      es.stopsound(int_userid, dict_current_player['old_sound'])

   str_old_type = dict_current_player['type']
   dict_current_player['lastsound'][str_old_type] = dict_current_player['old_sound'] = dict_current_player['sound']
   if dict_current_player['old_sound']:
      gamethread.cancelDelayed('cssoundtrack_endmusic_%s' % int_userid)
      dict_current_player['endmusic'] = False
      if dict_current_player['old_sound'] == str_sound:
         es.stopsound(int_userid, dict_current_player['old_sound'])
         dict_current_player['old_sound'] = ''
      else:
         gamethread.delayedname(float_overlap, 'cssoundtrack_fade_%s' % int_userid, fade_end, int_userid)

   dict_current_player['sound'] = str_sound
   dict_current_player['type'] = str_type
   if str_sound:
      dict_current_sound = dict_music[str_type][str_sound]
      float_duration = dict_current_sound['duration']
      str_title = dict_current_sound['title']
      es.playsound(int_userid, str_sound, es.ServerVar('cssoundtrack_volume_%s' % str_type))
      if bool_end_delay:
         dict_current_player['endmusic'] = True
         gamethread.delayedname(float_duration - float_overlap, 'cssoundtrack_endmusic_%s' % int_userid, end_music, int_userid)

      float_protection_delay = float(es.ServerVar('cssoundtrack_delay_min_length'))
      if str_type == 'stinger':
         dict_current_player['played_stinger'] = True
         if float_protection_delay < float_duration:
            float_protection_delay = float_duration
      if float_protection_delay:
         dict_current_player['protected_time'] = time.time() + float_protection_delay
         dict_current_player['protected_delay'] = True
         gamethread.delayedname(float_protection_delay, 'cssoundtrack_protected_%s' % int_userid, end_protected, int_userid)

      str_player_lang = playerlib.getPlayer(int_userid).get('lang')
      dict_tokens = {'sound':str_sound, 'duration':'%.01f' % float_duration}
      if str_title:
         str_text_lineone = func_lang_text('play sound title', {'title':str_title}, str_player_lang)
         str_text_linetwo = func_lang_text('play sound info', dict_tokens, str_player_lang)
         str_text = str_text_lineone.center(len(str_text_linetwo)) + '\n' + str_text_linetwo.center(len(str_text_lineone))
      else:
         str_text = func_lang_text('play sound no title', dict_tokens, str_player_lang)
      int_announce_option = int(es.ServerVar('cssoundtrack_announce_chat'))
      if int_announce_option == 2:
         for str_line in str_text.split('\n'):
            es.tell(int_userid, '#multi', str_line)
      elif int_announce_option:
         for str_line in str_text.split('\n'):
            es.cexec(int_userid, 'echo ' + remove_tags(str_line))
      if int(es.ServerVar('cssoundtrack_announce_hud')):
         hud_hint(int_userid, remove_tags(str_text))
   else:
      float_duration = 0
      str_title = ''

   es.event('initialize', 'cssoundtrack_music')
   es.event('setint', 'cssoundtrack_music', 'userid', int_userid)
   es.event('setstring', 'cssoundtrack_music', 'sound', str_sound)
   es.event('setfloat', 'cssoundtrack_music', 'duration', float_duration)
   es.event('setstring', 'cssoundtrack_music', 'title', str_title)
   es.event('setstring', 'cssoundtrack_music', 'type', str_type.upper())
   es.event('setstring', 'cssoundtrack_music', 'old_type', str_old_type.upper())
   es.event('fire', 'cssoundtrack_music')


def fade_end(int_userid):
   """Stops the sound that is being faded out"""
   global dict_players

   dict_current_player = dict_players[int_userid]
   es.stopsound(int_userid, dict_current_player['old_sound'])
   dict_current_player['old_sound'] = ''


def end_music(int_userid):
   """
   Plays the global music if cssoundtrack_change_individual is 1
   Chooses a random sound to follow the current sound otherwise
   Calls play_sound
   """
   global dict_players

   dict_current_player = dict_players[int_userid]
   dict_global_player = dict_players['global']
   str_type = dict_current_player['type']
   str_sound = dict_current_player['sound']
   if dict_current_player['protected_delay']:
      gamethread.cancelDelayed('cssoundtrack_protected_%s' % int_userid)
      dict_current_player['protected_delay'] = False

   if str_type == 'stinger':
      change_music((int_userid, ))

   else:
      if es.ServerVar('cssoundtrack_change_individual') <> 2 and dict_global_player['sound'] <> str_sound and dict_global_player['type'] == str_type:
         play_sound(int_userid, dict_global_player['sound'], str_type, False)

      else:
         list_possible_sounds = dict_music[str_type].keys()
         if str_sound in list_possible_sounds and len(list_possible_sounds) > 1:
            list_possible_sounds.remove(str_sound)

         if list_possible_sounds:
            play_sound(int_userid, random.choice(list_possible_sounds), str_type)
         else:
            play_sound(int_userid, '', str_type)


def end_protected(userid, func_command=None, tuple_args=()):
   """
   Resets the player's protected_delay to False
   Calls func_commmand with tuple_args arguments
   """
   global dict_players

   dict_players[userid]['protected_delay'] = False
   if func_command:
      func_command(*tuple_args)


def add_combat(arg_users):
   """
   Creates a new delay in dict_delays
   Appends the delay to each of arg_users in dict_players_in_combat
   Calls change_music on players added to dict_players_in_combat
   Creates a delay to call remove_combat
   """
   global int_delay_count
   global dict_delays
   global dict_players_in_combat

   int_delay_count += 1
   dict_delays[int_delay_count] = list(arg_users)

   list_added_players = []
   for int_userid in arg_users:
      if dict_players_in_combat.has_key(int_userid):
         dict_players_in_combat[int_userid].append(int_delay_count)
      else:
         dict_players_in_combat[int_userid] = [int_delay_count]
         list_added_players.append(int_userid)

   if list_added_players:
      change_music(list_added_players)

      for int_userid in list_added_players:
         es.event('initialize', 'cssoundtrack_combat')
         es.event('setint', 'cssoundtrack_combat', 'userid', int_userid)
         es.event('setstring', 'cssoundtrack_combat', 'action', 'ENTER')
         es.event('fire', 'cssoundtrack_combat')

   gamethread.delayedname(es.ServerVar('cssoundtrack_delay_combat'), 'cssoundtrack_combat_%s' % int_delay_count, remove_combat, int_delay_count)


def remove_combat(int_count):
   """
   Removes the combat instance from the player count
   Removes the player from dict_players_in_combat if no longer in combat
   Removes delay from dict_delays
   Calls change_music on players removed from dict_players_in_combat
   """
   global int_delay_count
   global dict_delays
   global dict_players_in_combat

   if dict_delays.has_key(int_count):
      list_removed_players = []
      for int_userid in dict_delays[int_count]:
         if dict_players_in_combat.has_key(int_userid):
            if int_count in dict_players_in_combat[int_userid]:
               dict_players_in_combat[int_userid].remove(int_count)
               if not dict_players_in_combat[int_userid]:
                  del dict_players_in_combat[int_userid]
                  list_removed_players.append(int_userid)

      del dict_delays[int_count]
      if not dict_delays:
         int_delay_count = 0

      if list_removed_players:
         change_music(list_removed_players)

         for int_userid in list_removed_players:
            es.event('initialize', 'cssoundtrack_combat')
            es.event('setint', 'cssoundtrack_combat', 'userid', int_userid)
            es.event('setstring', 'cssoundtrack_combat', 'action', 'EXIT')
            es.event('fire', 'cssoundtrack_combat')


def add_music(str_type, str_path, float_duration, bool_prevent_download=False, str_title=None):
   """
   Adds sound to music list
   Adds sound to download list
   """
   global dict_music_downloads
   global dict_music

   dict_current_type = dict_music[str_type]
   dict_current_type[str_path] = {'duration':float_duration, 'title':str_title}

   if not bool_prevent_download:
      if dict_music_downloads.has_key(str_path):
         dict_music_downloads[str_path] = dict_music_downloads[str_path] + 1
      else:
         dict_music_downloads[str_path] = 1


def remove_music(str_type, str_path):
   """
   Removes sound from music list
   Removes sound from download list
   """
   global dict_music_downloads
   global dict_music

   dict_current_type = dict_music[str_type]
   if dict_current_type.has_key(str_path):
      
      del dict_current_type[str_path]

      if dict_music_downloads.has_key(str_path):
         int_count = dict_music_downloads[str_path] = dict_music_downloads[str_path] - 1
         if not int_count:
            del dict_music_downloads[str_path]


def set_combat(arg_users):
   """
   Forces arg_users into an iteratable object if an int
   Calls add_combat
   """
   if isinstance(arg_users, int):
      arg_users = (arg_users, )

   add_combat(arg_users)


def clear_delays(bool_stop_music=True):
   """Clears outstanding delays"""
   global int_delay_count
   global dict_delays
   global dict_players

   list_players = dict_players.keys()
   if 'global' in list_players:
      if dict_players['global']['sound']:
         gamethread.cancelDelayed('cssoundtrack_endmusic_global')
      list_players.remove('global')

   for int_userid in list_players:
      dict_current_player = dict_players[int_userid]
      if dict_current_player['protected_delay']:
         gamethread.cancelDelayed('cssoundtrack_protected_%s' % int_userid)
         dict_current_player['protected_delay'] = False
      if dict_current_player['sound']:
         if bool_stop_music:
            es.stopsound(int_userid, dict_current_player['sound'])
         dict_current_player['type'] = dict_current_player['sound'] = ''
      if dict_current_player['endmusic']:
         gamethread.cancelDelayed('cssoundtrack_endmusic_%s' % int_userid)
         dict_current_player['endmusic'] = False
      if dict_current_player['old_sound']:
         gamethread.cancelDelayed('cssoundtrack_fade_%s' % int_userid)
         if bool_stop_music:
            es.stopsound(int_userid, dict_current_player['old_sound'])
         dict_current_player['old_sound'] = ''
      dict_current_player['played_stinger'] = False

   for int_delay in dict_delays:
      gamethread.cancelDelayed('cssoundtrack_combat_%s' % int_delay)
   dict_delays.clear()
   int_delay_count = 0


def music_cmd():
   """
   cssoundtrack_add <fast/slow/stinger> <sound file relative to ./sound> <duration> [0 = force client download (default), 1 = no client download] ["song title"]
   cssoundtrack_remove <fast/slow/stinger> <sound file relative to ./sound>
   Retrieves command arguments
   Calls add_music or remove_music with retrieved arguments
   """
   str_command = es.getargv(0).lower()
   int_arg_count = es.getargc()
   if int_arg_count in {'cssoundtrack_add':(4, 5, 6), 'cssoundtrack_remove':(3, )}[str_command]:
      list_args = [es.getargv(1).lower()]
      if dict_music.has_key(list_args[0]):
         list_args.append(es.getargv(2))
         if str_command == 'cssoundtrack_add':
            list_args.append(float(es.getargv(3)))

            if int_arg_count >= 5:
               for int_x in range(4, int_arg_count):
                  list_args.append(es.getargv(int_x))
               list_args[3] = int(list_args[3])

            add_music(*list_args)

         else:
            remove_music(*list_args)

      else:
         es.dbgmsg(0, 'CSSoundtrack: Unrecognized music type \"%s\" (fast/slow/stinger)' % list_args[0])

   else:
      es.dbgmsg(0, 'Syntax: ' + {'cssoundtrack_add':'cssoundtrack_add <fast/slow/stinger> <sound file relative to ./sound> <duration> [0 = force client download (default), 1 = no client download] [\"song title\"]', 'cssoundtrack_remove':'cssoundtrack_remove <fast/slow/stinger> <sound file relative to ./sound>'}[str_command])


def setcombat_cmd():
   """
   cssoundtrack_setcombat <userid/name/"Steam ID">
   Calls add_combat for the specified player
   """
   if es.getargc() == 2:
      str_arg = es.getargv(1)
      int_userid = es.getuserid(str_arg)
      if int_userid:
         add_combat((int_userid, ))

      else:
         es.dbgmsg(0, 'CSSoundtrack: Unable to find player \"%s\"' % str_arg)

   else:
      es.dbgmsg(0, 'Syntax: cssoundtrack_setcombat <userid/name/\"Steam ID\">')


def load_events():
   """Loads the .res file for the events"""
   if os.path.isfile(es.getAddonPath('cssoundtrack') + '/cssoundtrack.res'):
      es.loadevents('declare', 'addons/eventscripts/cssoundtrack/cssoundtrack.res')
   else:
      if not os.path.isfile(es.getAddonPath('cssoundtrack') + 'es_cssoundtrack_events_db.txt'):
         es.keygroupcreate('cssoundtrack_events')
         for str_event in dict_events:
            es.keycreate('cssoundtrack_events', str_event)
            for str_event_var in dict_events[str_event]:
               es.keysetvalue('cssoundtrack_events', str_event, str_event_var, dict_events[str_event][str_event_var])
         es.keygroupsave('cssoundtrack_events', '|cssoundtrack')
         es.keygroupdelete('cssoundtrack_events')
      es.loadevents('declare', 'addons/eventscripts/cssoundtrack/es_cssoundtrack_events_db.txt')
      es.dbgmsg(0, 'CSSoundtrack: Unable to load cssoundtrack.res! Please ensure it is in the ./cssoundtrack/ directory.')


def hud_hint(int_userid, str_message):
   """Sends the player a HUD hint"""
   es.usermsg('create', 'cssoundtrack_hud', 'HintText')
   es.usermsg('write', 'short', 'cssoundtrack_hud', -1)
   es.usermsg('write', 'string', 'cssoundtrack_hud', str_message)
   es.usermsg('send', 'cssoundtrack_hud', int_userid)
   es.usermsg('delete', 'cssoundtrack_hud')


def remove_tags(str_text):
   """Removes #lightgreen, #green and #default tags from the supplied string"""
   return str_text.replace('#lightgreen', '').replace('#green', '').replace('#default', '')


def missing_lang(str_heading, dict_tokens, str_language):
   """Displays an error message because the languages .ini could not be found"""
   return 'CSSoundtrack: cssoundtrack_languages.ini not found'