# SourceRPG release 1.3.7 by Steven Hartin
# ./addons/eventscripts/sourcerpg/sourcerpg.py

# >>> To configure this addon please see srpg.cfg <<<
# >>> To configure the skills please see skills/skills.cfg <<<

#################################
#### DO NOT EDIT THIS FILE, #####
####    IF YOU DO, THINGS   #####
####   THINGS COULD BREAK   #####
#################################


# Import Modules
import es
import playerlib
import langlib
import gamethread
import os.path
import popuplib
import time
import random
import services
import datetime
from shutil import move as move


import sqlite3
from sqlite3 import dbapi2 as sqlite

# psyco, more unstable but a lot faster
import psyco
psyco.full() 

# Set the addon info data
info = es.AddonInfo()
info.name = 'SourceRPG'
info.version = '1.3.7'
info.url = 'http://addons.eventscripts.com/addons/view/sourcerpg'
info.basename = 'sourcerpg'
info.author = 'Freddukes AKA Pro Noob'


# Make Public Variable
sourcerpg = es.ServerVar('sourcerpg',info.version,'SourceRPG Version - Made by Freddukes').makepublic()

# Set the dict options, so that each one can be made into a server variable for ease of setting

dict_options = {
'srpg_DebugMode'                     :[0,'The level of the debug'],
'srpg_Prefix'                        :['[SourceRPG]','The Prefix of all the message commands'],
'srpg_AnnounceXp'                    :[1,'Whether or not the user is told when he gets XP'],
'srpg_AnnounceOnSpawn'               :[1,'Whether or not the user is told how much XP he has on spawn'],
'srpg_LevelUp'                       :[1,'Announce globally that the user leveled up'],
'srpg_BotMaxLevel'                   :[500,'The maximum level a bot can aquire before he is reset'],
'srpg_MaxLevel'                      :[2500,'The maximum level a normal human player can aquire'],
'srpg_MaxLevelReset'                 :[1,'If enabled, when MaxLevel is reached, the stats are reset'],
'srpg_ServerLevelReset'              :[15000,'The top10 players levels added together before the server resets'],
'srpg_InactiveCounter'               :[7,'After this many days, players will be removed from the databse'],
'srpg_DisableUnfairAdvantageXp'      :[1,'Prevents people from gaining XP if there are no opposition on the other team.'],
'srpg_StartPopupStatus'              :[1,'The default activation status of the popup for every player to join the server'],
'srpg_ConverterOverwrite'            :[1,'If this is set to 1, then SourceRPG database overwrites players inside cssrpg.db if they both exist...'],
'srpg_DatabaseSaveType'              :["round end",'The time when the database will save: interval or round_end'],
'srpg_DatabaseIntervalLength'        :[120,'How often (in seconds) that the database will save if SaveType is "interval"'],

'srpg_SkillUpgradeSound'             :['ambient/machines/machine1_hit2.wav','Skill Upgrade Sound: Use \'\' to disable the sound'],
'srpg_SkillDowngradeSound'           :['vehicles/apc/apc_shutdown.wav','Skill Downgrade Sound: Use \'\' to disable the sound'],
'srpg_LevelUpSound'                  :['ambient/energy/whiteflash.wav','Level Up Sound: Use \'\' to disable the sound'],

'srpg_turboMode'                     :[0,'Whether or not SourceRPG turbo mode is enabled (1) or disabled (0)'],
'srpg_turboAnnounce'                 :[1,'Will a message be sent to all players if turbo mode is on'],
'srpg_turboExperienceMultiplier'     :[5,'The amount experience is multiplied if turbo mode is on.'],
'srpg_turboCreditMultiplier'         :[2,'The amount credits are multiplied by if turbo mode is on'],

'srpg_botsGetXpVsHumans'             :[1,'Do bots get XP when they damage or kill humans?'],
'srpg_humansGetXpVsBots'             :[1,'Do humans get XP when they damage bots?'],
'srpg_botsGetXpOnEvents'             :[1,'Do bots get XP on events like planting the bomb'],
'srpg_botsGetXpVsBots'               :[1,'Do bots get XP for damaging or killing other bots'],

'srpg_KillXp'                        :[15,'Amount of XP gained multiplied by the victims level'],
'srpg_DamageXp'                      :[1.0,'Amount of XP gained multiplied by the victims level per damage dealt'],
'srpg_KnifeXp'                       :[8.0,'Amount of XP gained multplied by the victims level per damage dealt with a knife'],
'srpg_HsXp'                          :[50,'How much extra XP recieved on top of the KillXP for getting a HeadShot'],
'srpg_BombPlantXp'                   :[25,'How much XP recieved from planting the Bomb'],
'srpg_BombDifuseXp'                  :[50,'How much XP recieved from diffusing the Bomb'],
'srpg_BombExplodeXp'                 :[25,'How much XP recieved from exploding the C4'],
'srpg_HostageFollowsXp'              :[10,'Amount of XP gained per hostage of the user that begins to follow'],
'srpg_HostageRescueXp'               :[10,'Amount of XP per hostage rescued'],

'srpg_StartXP'                       :[250,'How much EXP it takes to get to the first level'],
'srpg_StartCredits'                  :[5,'How many credits you get when you join the server for the first time'],
'srpg_XpIncrement'                   :[50,'How much the XP needed is incremented each level after level 1'],
'srpg_CreditIncrement'               :[5,'How many credits gained each level'],
'srpg_SellPercentage'                :[75,'The percent of the total credits recieved back when a player sells a skill'],

'srpg_Health'                        :[1,'Whether or not the Health ability is activated'],
'srpg_HealthMax'                     :[16,'Maximum level of the Health ability'],
'srpg_HealthCreditsStart'            :[15,'How much it costs to buy to level 1 of Health'],
'srpg_HealthCreditsIncrement'        :[10,'After level 1, this is how many credits it increments by each level'],
'srpg_HealthIncrement'               :[25,'The extra amount of health gained each Health Level'],

'srpg_Regen'                         :[1,'Whether or not the Regen ability is activated'],
'srpg_RegenMax'                      :[5,'Maximum level of the Regen ability'],
'srpg_RegenCreditsStart'             :[5,'How much it costs to buy to level 1 of Regen'],
'srpg_RegenCreditsIncrement'         :[10,'After level 1, this is how many credits it increments by each level'],
'srpg_RegenDelay'                    :[1,'The delay of the regeneration Loop.'],

'srpg_LongJump'                      :[1,'Whether or not the Long Jump ability is activated'],
'srpg_LongJumpMax'                   :[5,'Maximum level of the Long Jump ability'],
'srpg_LongJumpCreditsStart'          :[20,'How much it costs to buy to level 1 of Long Jump'],
'srpg_LongjumpCreditsIncrement'      :[15,'After level 1, this is how many credits it increments by each level'],

'srpg_RegenAmmo'                     :[1,'Whether or not the Regenerate Ammo ability is activated'],
'srpg_RegenAmmoMax'                  :[10,'Maximum level of the Regenerate Ammo ability'],
'srpg_RegenAmmoCreditsStart'         :[15,'How much it costs to buy to level 1 of Regen Ammo'],
'srpg_RegenAmmoCreditsIncrement'     :[10,'After level 1, this is how many credits it increments by each level'],
'srpg_RegenAmmoDelay'                :[3,'The delay between each loop of the Regen Ammo'],

'srpg_Vampire'                       :[1,'Whether or not the Vampire ability is activated'],
'srpg_VampireMax'                    :[10,'Maximum level of the Vampire ability'],
'srpg_VampireCreditsStart'           :[15,'How much it costs to buy level 1 of Vampire'],
'srpg_VampireCreditsIncrement'       :[10,'After level 1, this is how many credits it increments by each level'],

'srpg_Stealth'                       :[1,'Whether or not the Stealth ability is activated'],
'srpg_StealthMax'                    :[5,'Maximum level of the Stealth ability'],
'srpg_StealthCreditsStart'           :[15,'How much it costs to buy level 1 of Stealth'],
'srpg_StealthCreditsIncrement'       :[10,'After level 1, this is how many credits it increments by each level'],

'srpg_NapalmNade'                    :[1,'Whether or not the Napalm-Nade ability is activated'],
'srpg_NapalmNadeMax'                 :[10,'Maximum level of the Napalm-Nade ability'],
'srpg_NapalmNadeCreditsStart'        :[10,'How much it costs to buy level 1 of Napalm-Nade'],
'srpg_NapalmNadeCreditsIncrement'    :[10,'After level 1, this is how many credits it increments by each level'],

'srpg_IceStab'                       :[1,'Whether or not the Ice-Stab ability is activated'],
'srpg_IceStabMax'                    :[3,'Maximum level of the Ice-Stab ability'],
'srpg_IceStabCreditsStart'           :[20,'How much it costs to buy level 1 of Ice-Stab'],
'srpg_IceStabCreditsIncrement'       :[30,'After level 1, this is how many credits it increments by each level'],
'srpg_IceStabDamageReduction'        :[50,'Amount of damage to heal the user if he\'s frozen'],

'srpg_FrostPistol'                   :[1,'Whether or not the Frost Pistol ability is activated'],
'srpg_FrostPistolMax'                :[10,'Maximum level of the Frost Pistol ability'],
'srpg_FrostPistolCreditsStart'       :[20,'How much it costs to buy level 1 of Frost Pistol'],
'srpg_FrostPistolCreditsIncrement'   :[15,'After level 1, this is how many credits it increments by each level'],

'srpg_StunNade'                      :[1,'Whether or not the Stun Grenade ability is activated'],
'srpg_StunNadeMax'                   :[5,'Maximum level of the Stun Grenade ability'],
'srpg_StunNadeCreditsStart'          :[30,'How much it costs to buy level 1 of Stun Grenade'],
'srpg_StunNadeCreditsIncrement'      :[20,'After level 1, this is how many credits it increments by each level'],

'srpg_SmogNade'                      :[1,'Whether or not the Smog Grenade ability is activated'],
'srpg_SmogNadeMax'                   :[5,'Maximum level of the Smog Grenade ability'],
'srpg_SmogNadeCreditsStart'          :[20,'How much it costs to buy level 1 of Smog Grenade '],
'srpg_SmogNadeCreditsIncrement'      :[20,'After level 1, this is how many credits it increments by each level'],

'srpg_Speed'                         :[1,'Whether or not the Speed ability is activated'],
'srpg_SpeedMax'                      :[5,'Maximum level of the Speed ability'],
'srpg_SpeedCreditsStart'             :[20,'How much it costs to buy level 1 of Speed'],
'srpg_SpeedCreditsIncrement'         :[25,'After level 1, this is how many credits it increments by each level'],
'srpg_SpeedMaxMovementSpeed'         :[1.5,'The maximum speed a player can go with the speed ability.'],

'srpg_Gravity'                       :[1,'Whether or not the Gravity ability is activated'],
'srpg_GravityMax'                    :[10,'Maximum level of the Gravity ability'],
'srpg_GravityCreditsStart'           :[15,'How much it costs to buy level 1 of Gravity'],
'srpg_GravityCreditsIncrement'       :[10,'After level 1, this is how many credits it increments by each level'],
'srpg_GravityMinGravity'             :[0.3,'The minimum gravity a player is allowed to have at maximum gravity level.'],

'srpg_Disable'                       :[1,'Whether or not the Disable ability is activated'],
'srpg_DisableMax'                    :[10,'Maximum level of the Disable ability'],
'srpg_DisableCreditsStart'           :[15,'How much it costs to buy level 1 of Disable'],
'srpg_DisableCreditsIncrement'       :[10,'After level 1, this is how many credits it increments by each level'],
'srgp_DisableDropPercentage'         :[5,'This is how much percentage each level increases your percentage to disarm the victim.'],

'srpg_RecoverWeapons'                :[1,'Whether or not the Recover Weapons ability is activated'],
'srpg_RecoverWeaponsMax'             :[3,'Maximum level of the Recover Weapons ability'],
'srpg_RecoverWeaponsCreditsStart'    :[25,'How much it costs to buy level 1 of Recover Weapons'],
'srpg_RecoverWeaponsCreditsIncrement':[50,'After level 1, this is how many credits it increments by each level'],

'srpg_RegenArmor'                    :[1,'Whether or not the the Regenerate Armor ability is activated'],
'srpg_RegenArmorMax'                 :[10,'Maximum Level of Regenerate Armor'],
'srpg_RegenArmorCreditsStart'        :[5,'How much it costs to buy level 1 of Regenerate Armor'],
'srpg_RegenArmorCreditsIncrement'    :[10,'After level 1, this is how many credits it increments by each level'],
'srpg_RegenArmorDelay'               :[1,'The delay of the loop of Regenerate Armor'],

'srpg_Adrenaline'                    :[1,'Whether or not the the Adrenaline ability is activated'],
'srpg_AdrenalineMax'                 :[10,'Maximum Level of Adrenaline'],
'srpg_AdrenalineCreditsStart'        :[5,'How much it costs to buy level 1 of Adrenaline'],
'srpg_AdrenalineCreditsIncrement'    :[10,'After level 1, this is how many credits it increments by each level'],
'srpg_AdrenalineLength'              :[2,'How long in seconds the Adrenaline lasts for'],

'srpg_Medic'                         :[1,'Whether or not the the Medic ability is activated'],
'srpg_MedicMax'                      :[5,'Maximum Level of Medic'],
'srpg_MedicCreditsStart'             :[25,'How much it costs to buy level 1 of Medic'],
'srpg_MedicCreditsIncrement'         :[15,'After level 1, this is how many credits it increments by each level'],
'srpg_MedicMinDistance'              :[300,'The radius of the healing effect at level 1'],
'srpg_MedicDistanceIncrement'        :[50,'How much the radius grows each level'],
'srpg_MedicDelay'                    :[5,'The delay between the loops of the healing effect'],
'srpg_MedicHealingIncrement'         :[5,'The amount of health each loop will do, multiplied by the player\'s level'],
'srpg_MedicEffects'                  :[1,'Turn on/off the effects of the medic']
}

pistols   = {'glock':int(es.ServerVar('ammo_9mm_max')),'usp':int(es.ServerVar('ammo_45acp_max')),'p228':int(es.ServerVar('ammo_357sig_max')),'deagle':int(es.ServerVar('ammo_50AE_max')),'fiveseven':int(es.ServerVar('ammo_57mm_max')),'elite':int(es.ServerVar('ammo_9mm_max'))}
rifles    = {'m3':int(es.ServerVar('ammo_buckshot_max')),'xm1014':int(es.ServerVar('ammo_buckshot_max')),'tmp':int(es.ServerVar('ammo_9mm_max')),'mac10':int(es.ServerVar('ammo_45acp_max')),'ump45':int(es.ServerVar('ammo_45acp_max')),'mp5navy':int(es.ServerVar('ammo_9mm_max')),'p90':int(es.ServerVar('ammo_57mm_max')),'famas':int(es.ServerVar('ammo_556mm_max')),'galil':int(es.ServerVar('ammo_556mm_max')),'scout':int(es.ServerVar('ammo_762mm_max')),'ak47':int(es.ServerVar('ammo_762mm_max')),'m4a1':int(es.ServerVar('ammo_556mm_max')),'sg552':int(es.ServerVar('ammo_556mm_max')),'aug':int(es.ServerVar('ammo_762mm_max')),'g3sg1':int(es.ServerVar('ammo_762mm_max')),'sg550':int(es.ServerVar('ammo_556mm_max')),'awp':int(es.ServerVar('ammo_338mag_max')),'m249':int(es.ServerVar('ammo_556mm_box_max'))}
tempdict  = {}
smokedict = {}

# LangLib Text 
text        = lambda x, y = {}, lang = "en": "languages.ini not found in the ../sourcerpg/ directory!"
isEst       = bool(str(es.ServerVar('est_version')) != "0")
isOb        = bool(int(str(es.ServerVar('eventscripts_ver')).split('.')[1]) >= 1)
turboMode   = False

def load():
    """
    Whenever the script loads, Load all the default stuff
    Check if players are on server, if so, replicate the
    player_activate event for all users so we can unload
    and load the script whilst playing without bugs
    """
    
    global players
    global text
    
    es.msg('#green','SourceRPG Loading - Created by Freddukes')
    debugMsg(0,'Log file started at %s'%time.strftime("%A %d %B %Y - %H:%M:%S"))
    debugMsg(0,'\n*******************************************************', writeTime=False)
    debugMsg(0,'SourceRPG: Turning your Server into a Role Playing Game', writeTime=False)
    debugMsg(0,'SourceRPG: Current Version - %s'%info.version, writeTime=False)
    debugMsg(0,'SourceRPG: Made by Freddukes', writeTime=False)
    
    # Setup Auth Services
    setup_auth()
    debugMsg(0,'SourceRPG: Successfully Set up Authorization Services.', writeTime=False)
    
    # Make all options inside dict_options into a server variable so 
    # everything can be edited from within the game
    for option in dict_options:
        es.ServerVar(option, dict_options[option][0], dict_options[option][1])
        
    es.ServerVar('srpg_turboMode').makepublic()
        
    #Load both config files
        
    if os.path.isfile(es.getAddonPath('sourcerpg') + '/srpg.cfg'):
        es.server.cmd('es_xmexec ../addons/eventscripts/sourcerpg/srpg.cfg')
        debugMsg(0,'SourceRPG: Successfully Loaded \'srpg.cfg\'', writeTime=False)
    else:
        debugMsg(0,'SourceRPG: ERROR - Unable to load srpg.cfg! Please ensure it is in the ./sourcerpg/ directory.', writeTime=False)
        
    if os.path.isfile(es.getAddonPath('sourcerpg') + '/skills/skills.cfg'):
        es.server.cmd('es_xmexec ../addons/eventscripts/sourcerpg/skills/skills.cfg')
        debugMsg(0,'SourceRPG: Successfully Loaded \'skills.cfg\'', writeTime=False)
    else:
        debugMsg(0,'SourceRPG: ERROR - Unable to load skills.cfg! Please ensure it is in the ./sourcerpg/skills/ directory.', writeTime=False)
        
    # Convert the database from C++ CSS:RPG
    str_path = es.getAddonPath('sourcerpg') + '/cssrpg.db'
    if os.path.isfile(str_path):
        debugMsg(0,'SourceRPG: Found cssrpg.db! converting database now!')
        writeEntries(str_path)
        
    str_path = es.getAddonPath('sourcerpg') + '/players.db'
    if os.path.isfile(str_path):
        debugMsg(0, 'SourceRPG: Converting the old Dictionary type which was made by SourceRPG version 1.2.6 and below')
        convertOldDictionary(str_path)
        
    # Open up the Langlib strings and reference them for easy reference later
        
    langpath = os.path.join(es.getAddonPath('sourcerpg'), 'languages.ini')
    debugMsg(0, 'SourceRPG: Language Path is as follows: %s' % ( repr(langpath) ) )
    if os.path.isfile(langpath):
        text = langlib.Strings(langpath)
        debugMsg(0,'SourceRPG: Successfully Loaded \'languages.ini\'', writeTime=False)
    else:
        debugMsg(0,'SourceRPG: - ERROR Unable to load languages.ini! Please ensure it is in the ./sourcerpg/ directory.', writeTime=False)
       
    helpmenu = popuplib.create('helpmenu')
    a = helpmenu.addline
    a('=== SourceRPG Help ===')
    a('-------------')
    a('->1. About SourceRPG')
    a('->2. List of Commands')
    a('->3. About SourceRPG Skills')
    a('->4. Credit')
    a('-------------')
    a('8. Back')
    a('0. Cancel')
    helpmenu.submenu(1,'aboutmenu')
    helpmenu.submenu(2,'commandmenu')
    helpmenu.submenu(3,'aboutskillsmenu')
    helpmenu.submenu(4,'creditmenu')
    helpmenu.submenu(8,'rpgmenu')
        
    """
    This checks to see if there are users playing when the script loads
    If so, make sure that each user has a key in the temp_dict, and
    check to see if they have a key in players.db, if not, make one.
    This makes it so we can unload/load whilst playing inside the game.
    """
      
    if len(es.getUseridList()):
        debugMsg(0,'SourceRPG WARNING: Attempting to load halfway through a map', writeTime=False)
        debugMsg(0,'SourceRPG WARNING: This could cause errors, but trying anyway.', writeTime=False)
        for a in es.getUseridList():
            player_activate({'userid': a, 'es_username': es.getplayername(a)})
            
        es.server.queuecmd('mp_restartgame 1')
        debugMsg(0,'SourceRPG WARNING: Finished loaded halfway through a map. You may get a few errors.', writeTime=False)
        
    debugMsg(0,'SourceRPG: Creating Popups', writeTime=False)
    
    #Start of all the popups creating *sigh*
    
    rpgmenu = popuplib.create('rpgmenu')
    a = rpgmenu.addline
    a('=== SourceRPG Menu ===')
    a('-------------')
    a('->1. Upgrades')
    a('->2. Sell Skills')
    a('->3. Help')
    a('->4. RPG Stats')
    a('->5. Reset Skills')
    a('-------------')
    a('0. Cancel')
    rpgmenu.select(1,SendSkillsMenuFromPopup)
    rpgmenu.select(2,SendSellMenuFromPopup)
    rpgmenu.submenu(3,'helpmenu')
    rpgmenu.select(4,BuildStatsMenu)
    rpgmenu.submenu(5,'requestaccept')
    
    aboutmenu = popuplib.create('aboutmenu')
    a = aboutmenu.addline
    a('=== About SourceRPG ===')
    a('-------------')
    a('SourceRPG is a python coded mod')
    a('for EventScripts 2+. It enables')
    a('players to gain Levels, by gaining')
    a('XP from certain events, such as')
    a('planting the bomb, or killing')
    a('another player. Each level gives')
    a('%s Credits, which allows you to'%es.ServerVar('srpg_CreditIncrement'))
    a('buy certain skills which aid you')
    a('in killing other players.')
    a('-------------')
    a('8. Back')
    a('0. Cancel')
    aboutmenu.submenu(8,'helpmenu')
    
    commandmenu = popuplib.create('commandmenu')
    a = commandmenu.addline
    a('=== List of Commands ===')
    a('-------------')
    a('\'rpgmenu\' - Displays the main menu')
    a('\'rpgupgrade\' - Brings up the Upgrade menu')
    a('\'rpgsell\' - Brings up the Skills Shop')
    a('\'rpgrank\' - Displays your SourceRPG Rank')
    a('\'rpgrank <name>\' - Displays the SourceRPG rank of someone else')
    a('\'rpgtop10\' - Displays the SourceRPG Top10')
    a('\'rpghelp\' - Displays the help menu')
    a('\'rpgstats\' - Displays a stats popup page')
    a('\'rpgpopup\' - Toggles your popup display on or off')
    a('-------------')
    a('8. Back')
    a('0. Cancel')
    commandmenu.submenu(8,'helpmenu')
    
    aboutskillsmenu = popuplib.create('aboutskillsmenu')
    a = aboutskillsmenu.addline
    a('=== About SourceRPG Skills ===')
    a('           Page (1/3)         ')
    a('-------------')
    a('->1. Health+')
    a('->2. Regeneration')
    a('->3. Regenerate Ammo')
    a('->4. Napalm Grenade')
    a('->5. Vampire')
    a('->6. Stealth')
    a('->7. Long Jump')
    a('->8. Ice stab')
    a('-------------')
    a('->9. Next')
    a('->0. Back')
    aboutskillsmenu.submenu(1,'healthhelp')
    aboutskillsmenu.submenu(2,'regenhelp')
    aboutskillsmenu.submenu(3,'regenammohelp')
    aboutskillsmenu.submenu(4,'firenadehelp')
    aboutskillsmenu.submenu(5,'vampirehelp')
    aboutskillsmenu.submenu(6,'stealthhelp')
    aboutskillsmenu.submenu(7,'longjumphelp')
    aboutskillsmenu.submenu(8,'icestabhelp')
    aboutskillsmenu.submenu(9,'aboutskillsmenu2')
    aboutskillsmenu.submenu(10,'helpmenu')
    
    aboutskillsmenu2 = popuplib.create('aboutskillsmenu2')
    a = aboutskillsmenu2.addline
    a('=== About SourceRPG Skills ===')
    a('           Page (2/3)         ')
    a('-------------')
    a('->1. Frost Pistol')
    a('->2. Stun Grenades')
    a('->3. Smog Grenades')
    a('->4. Speed+')
    a('->5. Gravity-')
    a('->6. Disable')
    a('->7. Recover Weapons')
    a('-------------')
    a('->8. Back')
    a('->9. Next')
    aboutskillsmenu2.submenu(1,'frostpistolhelp')
    aboutskillsmenu2.submenu(2,'stunnadehelp')
    aboutskillsmenu2.submenu(3,'smognadehelp')
    aboutskillsmenu2.submenu(4,'speedhelp')
    aboutskillsmenu2.submenu(5,'gravityhelp')
    aboutskillsmenu2.submenu(6,'disablehelp')
    aboutskillsmenu2.submenu(7,'recoverweaponshelp')
    aboutskillsmenu2.submenu(8,'aboutskillsmenu')
    aboutskillsmenu2.submenu(9,'aboutskillsmenu3')
    
    aboutskillsmenu3 = popuplib.create('aboutskillsmenu3')
    a = aboutskillsmenu3.addline
    a('=== About SourceRPG Skills ===')
    a('           Page (3/3)         ')
    a('-------------')
    a('->1. Regenerate Armor')
    a('->2. Adrenaline')
    a('->3. Medic')
    a('-------------')
    a('->8. Back')
    a('0. Cancel')
    aboutskillsmenu3.submenu(1,'regenarmorhelp')
    aboutskillsmenu3.submenu(2,'adrenalinehelp')
    aboutskillsmenu3.submenu(3,'medichelp')
    aboutskillsmenu3.submenu(8,'aboutskillsmenu2')
    
    healthhelp = popuplib.create('healthhelp')
    a = healthhelp.addline
    a('=== Health+ ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_Health'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_HealthMax'))
    a(' ')
    a('Health+ is a skill which')
    a('allows the player to spawn')
    a('with more health. Each level')
    a('will give the player %s more'%es.ServerVar('srpg_HealthIncrement'))
    a('health upon spawn.')
    a('-------------')
    a('0. Back')
    healthhelp.submenu(10,'aboutskillsmenu')
    
    regenhelp = popuplib.create('regenhelp')
    a = regenhelp.addline
    a('=== Regeneration ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_Regen'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_RegenMax'))
    a(' ')
    a('Regeneration is an ability')
    a('which restores a certain')
    a('amount of health every')
    a('%s seconds. The amount you'%es.ServerVar('srpg_RegenDelay'))
    a('restore is the same amount')
    a('as your level')
    a('-------------')
    a('0. Back')
    regenhelp.submenu(10,'aboutskillsmenu')
    
    regenammohelp = popuplib.create('regenammohelp')
    a = regenammohelp.addline
    a('=== Regenerate Ammo ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_RegenAmmo'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_RegenAmmoMax'))
    a(' ')
    a('Regenerate ammo is a skill')
    a('which allows you to restore')
    a('your reserve ammo for your')
    a('active weapon every %s seconds.'%es.ServerVar('srpg_RegenAmmoDelay'))
    a('-------------')
    a('0. Back')
    regenammohelp.submenu(10,'aboutskillsmenu')
    
    firenadehelp = popuplib.create('firenadehelp')
    a = firenadehelp.addline
    a('=== Napalm Grenade ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_NapalmNade'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_NapalmNadeMax'))
    a(' ')
    a('Napalm grenade is an ability which')
    a('if a player is hit by your grenade')
    a('then he will be set on fire for ')
    a('a certain amount of time. The time')
    a('the player is burnt for is 1 seconds')
    a('for every level you have.')
    a('-------------')
    a('0. Back')
    firenadehelp.submenu(10,'aboutskillsmenu')
    
    vampirehelp = popuplib.create('vampirehelp')
    a = vampirehelp.addline
    a('=== Vampire ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_Vampire'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_VampireMax'))
    a(' ')
    a('Vampire is a skill which when you')
    a('attack another player, you will drain')
    a('a certain percentage of the damage done,')
    a('and restores it to your health. Every level')
    a('restores 7.5% of the damage done to your')
    a('health.')
    a('-------------')
    a('0. Back')
    vampirehelp.submenu(10,'aboutskillsmenu')
    
    stealthhelp = popuplib.create('stealthhelp')
    a = stealthhelp.addline
    a('=== Stealth ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_Stealth'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_StealthMax'))
    a(' ')
    a('The Stealth ability enables you to spawn')
    a('with a higher translutent figure, so you')
    a('appear more invisible. The higher the level')
    a('of stealth, the harder you are to see.')
    a('-------------')
    a('0. Back')
    stealthhelp.submenu(10,'aboutskillsmenu')
    
    longjumphelp = popuplib.create('longjumphelp')
    a = longjumphelp.addline
    a('=== Long Jump ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_LongJump'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_LongJumpMax'))
    a(' ')
    a('  SumGuy14 and Murphey Made this skill and')
    a('  allowed my to use it. Thanks guys!')
    a(' ')
    a('The long jump ability enables you to jump')
    a('further along the floor with each jump.')
    a('The higher level the skill, the further')
    a('you will jump.')
    a('-------------')
    a('0. Back')
    longjumphelp.submenu(10,'aboutskillsmenu')
    
    icestabhelp = popuplib.create('icestabhelp')
    a = icestabhelp.addline
    a('=== Ice Stab ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_IceStab'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_IceStabMax'))
    a(' ')
    a('Whenever you right click with the knife,')
    a('and you hurt another enemy from the opposite')
    a('team, they will freeze for a certain amount')
    a('of time dependant upon the level. Each level')
    a('will freeze the victim for 1 second.')
    a('-------------')
    a('0. Back')
    icestabhelp.submenu(10,'aboutskillsmenu')
    
    frostpistolhelp = popuplib.create('frostpistolhelp')
    a = frostpistolhelp.addline
    a('=== Frost Pistol ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_FrostPistol'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_FrostPistolMax'))
    a(' ')
    a('Frost pistol is a skill that happens whenever')
    a('you attack another player with a pistol. What')
    a('this skill does is slow your enemy for a certain')
    a('amount of time, dependant on your level. Each level')
    a('increases the time length it freezes the victim, and')
    a('also how effective the slow effect is.')
    a('-------------')
    a('0. Back')
    frostpistolhelp.submenu(10,'aboutskillsmenu2')
    
    stunnadehelp = popuplib.create('stunnadehelp')
    a = stunnadehelp.addline
    a('=== Stun Grenade ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_StunNade'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_StunNadeMax'))
    a(' ')
    a('Stun Grenade is flash grenade effect. Whenever')
    a('a victim is flashed via a flashbang, he can')
    a('also be frozen, and his screen is \'shaken\'.')
    a('The higher the level, the longer the victim is')
    a('frozen, and the more violent his screen is shaken.')
    a('-------------')
    a('0. Back')
    stunnadehelp.submenu(10,'aboutskillsmenu2')
    
    smognadehelp = popuplib.create('smognadehelp')
    a = smognadehelp.addline
    a('=== Smog Grenade ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_SmogNade'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_SmogNadeMax'))
    a(' ')
    a('  SuperDave Deserves credit for this skill. He made')
    a('  it and he\'s an excellent coder. Thank you SuperDave!')
    a(' ')
    a('This skill enables a posion gas to emit from smoke grenades.')
    a('Whenever you throw a smoke grenade, a poisonous gas appears')
    a('and victims to walk into it are damaged for the time they are')
    a('inside it. The damage emits every second, and the amount of')
    a('damage dealt is relevant to your Smog Grenade level. Each')
    a('level adds an extra damage to the poison.')
    a('-------------')
    a('0. Back')
    smognadehelp.submenu(10,'aboutskillsmenu2')
    
    speedhelp = popuplib.create('speedhelp')
    a = speedhelp.addline
    a('=== Speed+ ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_Speed'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_SpeedMax'))
    a(' ')
    a('Speed+ is a skill which increases your running')
    a('speed. The higher the level, the faster the speed.')
    a('The maximum level enables you to run at %sX the default'%es.ServerVar('srpg_SpeedMaxMovementSpeed')) 
    a('speed')
    a('-------------')
    a('0. Back')
    speedhelp.submenu(10,'aboutskillsmenu2')
    
    gravityhelp = popuplib.create('gravityhelp')
    a = gravityhelp.addline
    a('=== Gravity- ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_Gravity'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_GravityMax'))
    a(' ')
    a('Gravity- is a skill which lowers your gravity.')
    a('The higher the level, the lower your gravity.')
    a('Lower gravity enables you to jump higher.')
    a('At level %s, your gravity is %s percent of normal gravity'%(es.ServerVar('srpg_GravityMax'),(int(es.ServerVar('srpg_GravityMinGravity') * 100))))
    a('-------------')
    a('0. Back')
    gravityhelp.submenu(10,'aboutskillsmenu2')
    
    disablehelp = popuplib.create('disablehelp')
    a = disablehelp.addline
    a('=== Disable ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_Disable'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_DisableMax'))
    a(' ')
    a('Disable is an ability that works on percentages.')
    a('The higher the your level, the higher the chance')
    a('that the skill will happen. Each level increment')
    a('raises your chances of the ability from happening')
    a('by 5%. If your ability was successful, the victim')
    a('will be forced to drop his weapons, so he will')
    a('be disarmed until he picks it back up again.')
    a('-------------')
    a('0. Back')
    disablehelp.submenu(10,'aboutskillsmenu2')
    
    recoverweaponshelp = popuplib.create('recoverweaponshelp')
    a = recoverweaponshelp.addline
    a('=== Recover Weapons ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_RecoverWeapons'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_RecoverWeaponsMax'))
    a(' ')
    a('Recover Weapons is a skill which enables you to recover your')
    a('Weapons back if you die on the next round.')
    a('Level 1 - Restores NVG\'s, Unused Grenades and Vest//helm')
    a('Level 2 - Restores the above and Pistols')
    a('Level 3 - Restores the above and Primary Weapons')
    a('-------------')
    a('0. Back')
    recoverweaponshelp.submenu(10,'aboutskillsmenu2')
    
    regenarmorhelp = popuplib.create('regenarmorhelp')
    a = regenarmorhelp.addline
    a('=== Regenerate Armor ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_RegenArmor'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_RegenArmorMax'))
    a(' ')
    a('Regenerate Armor does exactly what it says on the tin...')
    a('It gives a certain amount of health back every %s seconds.'%(es.ServerVar('srpg_RegenArmorDelay')))
    a('This means that if you have a level 7 regenerate armor, then')
    a('you will gain 7 health every %s second.'%(es.ServerVar('srpg_RegenArmorDelay')))
    a('-------------')
    a('0. Back')
    regenarmorhelp.submenu(10,'aboutskillsmenu3')
    
    adrenalinehelp = popuplib.create('adrenalinehelp')
    a = adrenalinehelp.addline
    a('=== Adrenaline ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_Adrenaline'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_AdrenalineMax'))
    a(' ')
    a('Adrenaline allows you to get away from your enemies')
    a('in the most dire of times! When you are hit, you will')
    a('gain a quick speed boost to aid you turn tail and run.')
    a('Watch out though, the boost only lasts for %s seconds'%es.ServerVar('srpg_AdrenalineLength'))
    a('before you are reverted back to normal speed!')
    a('-------------')
    a('0. Back')
    adrenalinehelp.submenu(10,'aboutskillsmenu3')
    
    medichelp = popuplib.create('medichelp')
    a = medichelp.addline
    a('=== Medic ===')
    a('-------------')
    a('  %s'%IsEnabled(int(es.ServerVar('srpg_Medic'))))
    a('  Maximum Level: %s'%es.ServerVar('srpg_MedicMax'))
    a(' ')
    a('Medic allows you to heal your team-friends in a local')
    a('area. Every %s seconds, a healing wave will heal your'%es.ServerVar('srpg_MedicDelay'))
    a('friends in range. If your friends health is at their')
    a('maximum, then it will begin healing their armor instead.')
    a('-------------')
    a('0. Back')
    medichelp.submenu(10,'aboutskillsmenu3')
    
    creditmenu = popuplib.create('creditmenu')
    a = creditmenu.addline
    a('=== Credits ===')
    a('-------------')
    a('Freddukes (A.K.A Team TsX | Pro Noob)')
    a('  Script Creator')
    a(' ')
    a('SumGuy14 and Murphey')
    a('  Letting me use their Long Jump code')
    a(' ')
    a('SuperDave')
    a('  He turned my failing SmogNade code into')
    a('  a working code! Thank him for that skill.')
    a(' ')
    a('JoeyT2008 (Jordan Thomas)')
    a('  Awsome scripter who made the database conversion')
    a('  tool! Thank him for keeping all your skills! <3')
    a(' ')
    a('EventScripts Community')
    a('  Help and support, and such a good plugin.')
    a('-------------')
    a('8. Back')
    a('0. Cancel')
    creditmenu.submenu(8,'helpmenu')
    
    requestaccept = popuplib.create('requestaccept')
    a = requestaccept.addline
    a('=== WARNING!!! ===')
    a('-------------')
    a('This will pernamantly delete')
    a('your stats and information.')
    a('Do you wish to procceed?')
    a('There is no reversing the action!')
    a(' ')
    a('->1. Yes')
    a('->2. No')
    a('-------------')
    requestaccept.select(1, ResetSkills)
    
    cd = popuplib.create('ConfirmDeletion')
    a = cd.addline
    a('=== SourceRPG Admin===')
    a('---------------------------------')
    a('!!!WARNING!!!')
    a(' ')
    a('You are about to delete the whole')
    a('entire database. This will reset')
    a('all the players ranks, skills and')
    a('experience. Are you sure you want')
    a('to do this? There is nothing to')
    a('reverse this action once confirmed.')
    a(' ')
    a('->1. Yes')
    a('->0. No')
    cd.select(1,DeleteDatabase)
    cd.submenu(10,'srpg_adminmenu')
    
    debugMsg(0,'SourceRPG: Successfully created popups', writeTime=False)
    
    # Phew, lots of popups just been made...
    
    es.load('sourcerpg/admin')
    
    # Turn noisy on to track weapon_fire so we can have napalm nades =]
    debugMsg(1,'\nTurning Noisy on now.....', writeTime=False)
    debugMsg(1,'Pre Noisy is %s'%es.ServerVar('eventscripts_noisy'), writeTime=False)
    es.doblock('corelib/noisy_on')
    debugMsg(1,'After Noisy is %s\n'%es.ServerVar('eventscripts_noisy'), writeTime=False)
    
    if es.ServerVar('srpg_DatabaseSaveType') == "intervals":
        gamethread.delayedname(int(es.ServerVar('srpg_DatabaseIntervalLength')), 'save_interval', SaveDatabase)
    
    gamethread.delayed(0.5, checkXa)
    
    debugMsg(0,'SourceRPG: Finished Loading... Enjoy your stay!', writeTime=False)
    debugMsg(0,'*******************************************************\n', writeTime=False)
        
def unload():
    """
    This method is called whenever the script is unloaded. Saves the player.db
    and resets everyones stats back to 'normal' attributes, such as gravity etc.
    """
    es.msg('#green','SourceRPG Unloading - Created by Freddukes')
    debugMsg(0,'*******************************************************', writeTime=False)
    debugMsg(0,'SourceRPG: Returning back to normal')
    if len(es.getUseridList()):
        debugMsg(0,'SourceRPG: Resetting players attributes to normal gameplaye')
        for a in es.getUseridList():
            Command(a).SetGravity(1.0)
            Command(a).Color()
        debugMsg(0,'SourceRPG: Everyone\s stats reset to normal')
    debugMsg(0,'SourceRPG: Saving Player.db')
    SaveDatabase()
    players.connection.close()
    gamethread.cancelDelayed('SmokeUpdate')
    gamethread.cancelDelayed('save_interval')
    es.server.queuecmd('mp_restartgame 1')
    debugMsg(0,'SourceRPG: Successfully Unloaded.')
    debugMsg(0,'*******************************************************', writeTime=False)
        
def popup_select(ev):
    if int(ev['popup_choice']) > 7:
        es.playsound(ev['userid'], 'buttons/button24.wav', 0.5)
        
def server_cvar(ev):
    """ 
        This event runs when a public variable changes. We are going to see if an admin has
        changed the value of turbo mode. If so ensure the databases are properly closed before
        opening others
    """
    global turboMode
    global players
    debugMsg(1, '\n*******************************************************', writeTime=False)
    debugMsg(1, 'SourceRPG: Server Console Variable has been changed')
    if ev['cvarname'] == "srpg_turboMode":
        value = int(ev['cvarvalue'])
        debugMsg(1, 'SourceRPG: Turbo Mode Variable has been turned %s' % ("off" if not value else "on") )
        if value and not turboMode:
            """ We're turning on turbo mode """
            players.saveDatabase()
            players.close()
            players = SQLiteManager(":memory:")
            for player in es.getUseridList():
                player_activate({'userid':player, 'es_username' : es.getplayername(player)})
            es.server.queuecmd('mp_restartgame 1')
            turboMode = True
        elif not value and turboMode:
            """ We're turning off turbo Mode """
            players.close()
            for player in es.getUseridList():
                player_activate({'userid':player, 'es_username' : es.getplayername(player)})
            players = SQLiteManager( os.path.join (es.getAddonPath('sourcerpg'), 'players.sqldb' ) )
            es.server.queuecmd('mp_restartgame 1')
            turboMode = False
    debugMsg(1,'*******************************************************', writeTime = False)
        
        
def es_map_start(ev):
    debugMsg(1, '\n*******************************************************', writeTime=False)
    debugMsg(1, 'SourceRPG: Map Start Activated!')
    if not turboMode:
    
        if int(es.ServerVar('srpg_ServerLevelReset')):
            debugMsg(1,'Testing server level reset!')
            
            database = players.sort(10)
            
            level = 0
            for index in range(min(10, len(database) ) ):
                if int(es.ServerVar('srpg_DebugMode')) >= 2:
                    debugMsg(2,'Testing rank %s on the server.' % index)
                    debugMsg(2,'Level Before addition - %s' % level)
                level += players.query('Level', database[index])
                debugMsg(2,'Level After addition - %s' % level)
            if level >= int(es.ServerVar('srpg_ServerLevelReset')):
                if int(es.ServerVar('srpg_DebugMode')):
                    debugMsg(1,'Top 10 levels is bigger than the Server Level Reset, so resetting!')
                    debugMsg(1,'SourceRPG: Out of Map Start Method!\n')
                DeleteDatabase(None, None, None)
                return
                
        date = datetime.date.today() - datetime.timedelta(int(es.ServerVar('srpg_InactiveCounter')))
        debugMsg(1,'Testing for inactive players: Everyone that was last active before %s will be delted.'%date)
        players.execute("DELETE FROM players WHERE LastConnected<'%s'" %date)
        
    else:
        players.clear()
    
    debugMsg(1,'SourceRPG: Out of Map Start Method!')
    debugMsg(1, '*******************************************************\n', writeTime=False)
        
def player_activate(ev):
    """
    Called whenever a user connects to the server and is activated.
    Here we will get the steamid of the user, and see if he has a 
    place inside the players.db. If not, create one. It will also
    Create a temp_dict, which will set things like max health, so we
    only need to calculate max_health once, then we've got easy reference
    throughout the rest of the script.
    """
    debugMsg(1, '\n*******************************************************', writeTime=False)
    debugMsg(1, 'SourceRPG: Player activate method')
    steamid = ReturnSteam(ev['userid'])
    if not steamid in players:
        debugMsg(1, 'New player has just joined, create a new table for him.')
        players.addPlayer(steamid)
        debugMsg(0,'SourceRPG: ' + ev['es_username'] + ' Has been added to \'players.db\'')
        popuplib.send('helpmenu',ev['userid'])
    if turboMode:
        gamethread.cancelDelayed('srpg_deleteFromDatabase_%s' % steamid)
    players.update({'Name' : ev['es_username'], 'LastConnected' : datetime.date.today()}, steamid )
    command = Command(ev['userid'])
    command.ResetDict()
    command.ResetRecover()
    command['StartTime'] = time.time()
    debugMsg(1, 'SourceRPG: Out of Player Activate!')
    debugMsg(1, '*******************************************************\n', writeTime=False)
    
def player_team(ev):
    '''
    This event occurs when a player changes team
    It is here to remove the weapons gained from
    recover active skill
    '''
    Command(ev['userid']).ResetRecover()
    
def player_disconnect(ev):
    """
    Called whenever a player is disconnected from your server.
    This will attempt to delete all custom popups that we have
    made for the user, as to save resources. Also, we will see if
    the server is not a LAN... If it is, for some reason there will
    be weird errors as playerlib.uniqueid will say 'Cannot find user'.
    """
    for pName in ['skill','sell','stats','s']:
        realPName = pName + '_' + ev['userid']
        if popuplib.exists(realPName):
            popuplib.delete(realPName)
    if turboMode:
        steamid = ReturnSteam(ev['userid'])
        gamethread.delayedname(600, 'srpg_deleteFromDatabase_%s' % steamid, deletePlayer, steamid)
    if 'BOT' not in ev['networkid'] and 'LAN' not in ev['networkid']:
        start_time   = Command(ev['userid'])['StartTime']
        end_time     = time.time()
        time_elapsed = '%.2f'%((end_time - start_time) / 3600.0)
        players.increment({'TotalTime': float(time_elapsed)}, ev['networkid'])
    del command_dict[int(ev['userid'])]
    
def deletePlayer(steamid):
    if turboMode:
        players.execute("DELETE FROM players WHERE Steamid=\"" + steamid + "\"")
    
def round_end(ev):
    """
    Round end just simply saves the players.db whenever the round ends
    """
    if players.connected is False:
        players.connect()
    elif es.ServerVar('srpg_DatabaseSaveType') == "round end":
        SaveDatabase()
    gamethread.cancelDelayed('SmokeUpdate')
    for player in filter(lambda x: not es.getplayerprop(x, 'CBasePlayer.pl.deadflag'), es.getUseridList() ):
        gamethread.cancelDelayed('medic_%s'%player)
    
def round_freeze_end(ev):
    """
    Start the delay to check for smokegrenade positions
    """
    gamethread.delayedname(1, 'SmokeUpdate', sg_update)
        
"""
Below is just a list of all the events which gain XP for the player.
"""
        
def bomb_planted(ev):
    if int(es.ServerVar('srpg_DisableUnfairAdvantageXp')):
        if not len(playerlib.getPlayerList('#ct')): 
            return
    steamid = ReturnSteam(ev['userid'])
    if int(es.ServerVar('srpg_BombPlantXp')):
        if (int(es.ServerVar('srpg_botsGetXpOnEvents'))) and es.isbot(ev['userid']):
            return
        xp = int(es.ServerVar('srpg_BombPlantXp')) * players.query('Level', steamid)
        AddXp(ev['userid'], steamid, xp, ' for Planting the Bomb')
    
def bomb_exploded(ev):
    if int(es.ServerVar('srpg_DisableUnfairAdvantageXp')):
        if not len(playerlib.getPlayerList('#ct')): 
            return
    steamid = ReturnSteam(ev['userid'])
    if int(es.ServerVar('srpg_BombExplodeXp')):
        if (int(es.ServerVar('srpg_botsGetXpOnEvents'))) and es.isbot(ev['userid']):
            return
        xp = int(es.ServerVar('srpg_BombExplodeXp')) * players.query('Level', steamid)
        AddXp(ev['userid'], steamid, xp, ' for The C4 Exploding')
    
def bomb_difused(ev):
    if int(es.ServerVar('srpg_DisableUnfairAdvantageXp')):
        if not len(playerlib.getPlayerList('#t')): 
            return
    steamid = ReturnSteam(ev['userid'])
    if int(es.ServerVar('srpg_BombDifuseXp')):
        if (int(es.ServerVar('srpg_botsGetXpOnEvents'))) and es.isbot(ev['userid']):
            return
        xp = int(es.ServerVar('srpg_BombDifuseXp')) * players.query('Level', steamid)
        AddXp(ev['userid'], steamid, xp, ' for Diffusing the bomb')

def hostage_follows(ev):
    if int(es.ServerVar('srpg_DisableUnfairAdvantageXp')):
        if not len(playerlib.getPlayerList('#t')): 
            return
    steamid = ReturnSteam(ev['userid'])
    if int(es.ServerVar('srpg_HostageFollowsXp')):
        if (int(es.ServerVar('srpg_botsGetXpOnEvents'))) and es.isbot(ev['userid']):
            return
        xp = int(es.ServerVar('srpg_HostageFollowsXp')) * players.query('Level', steamid)
        AddXp(ev['userid'], steamid, xp, ' for Reaching a Hostage')

def hostage_rescued(ev):
    if int(es.ServerVar('srpg_DisableUnfairAdvantageXp')):
        if not len(playerlib.getPlayerList('#t')): 
            return
    steamid = ReturnSteam(ev['userid'])
    if int(es.ServerVar('srpg_HostageRescueXp')):
        if (int(es.ServerVar('srpg_botsGetXpOnEvents'))) and es.isbot(ev['userid']):
            return
        xp = int(es.ServerVar('srpg_HostageRescueXp')) * players.query('Level', steamid)
        AddXp(ev['userid'], steamid, xp, ' for Rescuing a Hostage')

"""
End of list of all the events which gain XP for the Player.
"""

def player_spawn(ev):
    """
    Called whenever a player spawns. Here we will check for health,
    stealth, gravity, speed and regenerate weapons
    """
    if int(es.ServerVar('srpg_DebugMode')):
        debugMsg(1,'\n***********************', writeTime=False)
        debugMsg(1,'SourceRPG: Player Spawn Event!')
    userid = str(ev['userid'])
    debugMsg(1,'Testing userid: %s'%userid)
    command = Command(userid)
    steamid = ReturnSteam(userid)
    debugMsg(1,'Testing steamid: %s'%steamid)
    command.ResetDict()
    if int(es.ServerVar('srpg_Health')):
        debugMsg(1,'Setting player\'s max health to %s'%command.ReturnDict('MaxHealth'))
        es.setplayerprop(userid,'CBasePlayer.m_iHealth',command.ReturnDict('MaxHealth'))
    gamethread.delayed(int(es.ServerVar('srpg_RegenArmorDelay')), command.RegenArmor)
    if steamid in players:
    
        if int(es.ServerVar('srpg_AnnounceOnSpawn')):
            level, xp = players.query(('Level', 'Xp'), steamid)
            nextlevelxp = (level - 1) * int(es.ServerVar('srpg_XpIncrement')) + int(es.ServerVar('srpg_StartXP'))
            tokens = {'level':level,'xp':xp,'nextxp':nextlevelxp,'prefix':es.ServerVar('srpg_Prefix')}
            es.tell(userid,'#multi',text('level gained private', tokens, playerlib.getPlayer(userid).get('lang')))
        command.Color(255, 255, 255)
        
        if players.query('Speed', steamid) and int(es.ServerVar('srpg_Speed')):
            debugMsg(1,'Setting Players speed to %s'%command.ReturnDict('MaxSpeed'))
            command.Speed(command.ReturnDict('MaxSpeed'))
            
        if players.query('Regen', steamid) and int(es.ServerVar('srpg_Regen')):
            command.Regen()
            
        if players.query('RegenArmor', steamid) and int(es.ServerVar('srpg_RegenArmor')):
            command.RegenArmor()
            
        if players.query('Gravity', steamid) and int(es.ServerVar('srpg_Gravity')):
            debugMsg(1,'Setting Players graviy to %s'%command.ReturnDict('MaxGrav'))
            command.SetGravity(command.ReturnDict('MaxGrav'))
            
        if int(es.ServerVar('srpg_RecoverWeapons')) and command.ReturnDict('RecoverActive') and players.query('RecoverWeapons', steamid):
            debugMsg(1,'Recover weapons is active')
            command.UpdateDict('RecoverActive',0)
            if not playerlib.getPlayer(userid).get('weaponindex', 'knife'):
                es.server.queuecmd('es_xgive %s weapon_knife'%userid)
            if command.ReturnDict('RecoverHe'):
                if not es.getplayerprop(userid, "CBasePlayer.localdata.m_iAmmo.011"):
                    es.server.queuecmd('es_xgive %s weapon_hegrenade'%userid)
            if command.ReturnDict('RecoverSmoke'):
                if not es.getplayerprop(userid, 'CBasePlayer.localdata.m_iAmmo.012'):
                    es.server.queuecmd('es_xgive %s weapon_smokegrenade'%userid)
            if command.ReturnDict('RecoverVest'):
                es.server.queuecmd('es_xgive %s item_kevlar'%userid)
            if command.ReturnDict('RecoverNvgs'):
                es.server.queuecmd('es_xgive %s item_nvgs'%userid)
            if command.ReturnDict('RecoverVestHelm'): 
                es.server.queuecmd('es_xgive %s item_assaultsuit'%userid)
            fbc = command.ReturnDict('RecoverFlashbang')
            while fbc:
                if int(es.getplayerprop(userid, 'CBasePlayer.localdata.m_iAmmo.012')) < 2:
                    fbc -= 1
                    command.ModDict('RecoverFlashbang', -1)
                    es.server.queuecmd('es_xgive %s weapon_flashbang'%userid)
                else: 
                    break
            if players.query('RecoverWeapons', steamid) > 1:
                if str(command.ReturnDict('RecoverSecondary')) not in ['0','None','weapon_glock','weapon_usp']:
                    handle = es.getplayerhandle(userid)
                    for weapon in es.createentitylist('weapon_%s' % ('glock' if ev['es_userteam'] == "2" else 'usp')):
                        if es.getindexprop(weapon, 'CBaseEntity.m_hOwnerEntity') == handle:
                            es.cexec(userid, 'lastinv')
                            es.server.queuecmd('es_xremove %s' % weapon)
                            break
                    gamethread.delayed(0.1, es.server.queuecmd, 'es_xgive %s %s'%(userid,command.ReturnDict('RecoverSecondary')))
            if players.query('RecoverWeapons', steamid) > 2:
                if str(command.ReturnDict('RecoverPrimary')) not in ['0','None']:
                    gamethread.delayed(0.1, es.server.queuecmd, 'es_xgive %s %s'%(userid, command.ReturnDict('RecoverPrimary')))
            debugMsg(1,'End of Recover weapons')
            
        if int(es.ServerVar('srpg_Medic')) and players.query('Medic', steamid):
            debugMsg(1,'Starting Medic Loop')
            command.MedicLoop()
            
        if int(es.ServerVar('srpg_DebugMode')):
            debugMsg(1,'SourceRPG: End of Player Spawn')
            debugMsg(1,'***********************\n', writeTime=False)

def round_start(ev):
    """ An event just to send a message on Round Start"""
    for player in playerlib.getPlayerList('#all'):
        es.tell(int(player), '#multi', text('round start', {'prefix':str(es.ServerVar('srpg_Prefix'))}, player.get('lang')))
        if turboMode and int(es.ServerVar('srpg_turboAnnounce') ):
            es.tell(int(player), '#multi', text('turbo mode on', {'prefix':str(es.ServerVar('srpg_Prefix'))}, player.get('lang') ) )

def sayFilter(userid, tempText, teamOnly):
    """
    Called whenever a player types anything in chat. Here we will get the text,
    strip it, and make it lower case. Then we will test the first argument to see
    if it matches an RPG command, if so run the following command. Here we will be
    defining the commands:
    
    rpgmenu - The main menu of the script. The popup which is central to all others
    rpgupgrade - Shortcut to the 'upgrade skills' popup.
    rpgsell - Shortcut to the 'sell upgrade' popup.
    rpghelp - Help menu
    rpgtop10 - Sort the dictionary by level, then make it so it so it will add the first
               10 indexs to the popup. Will also check if there aren't 10 users then break.
    rpgrank - Send a simple message to the player. Will need to sort the dictionary, then
              find the index of the steamid. Also len(dictionary) to get the total ranked 
              players. Also test to see if there's another argument to find a rank of another
              person.
    rpgstats - Shortcut to the stats popup.
    *new* rpgpopup - Enable/Disable popups. Check to see about their status of 'popup' in 
                     players.db. If it equals 0, then turn it on, else turn it off    
    """
    text = tempText.lower().replace('"','')
    text = text.split()
    if text[0] == "rpgmenu":
        popuplib.send('rpgmenu',userid)
        return(0, "", 0)
        
    elif text[0] == "rpgupgrade":
        steamid = ReturnSteam(userid)
        CreateSkillMenu(userid, steamid)
        skillmenu = 'skill_%s'%userid
        popuplib.send(skillmenu, userid)
        return(0, "", 0)
        
    elif text[0] == "rpghelp":
        popuplib.send('helpmenu', userid)
        return(0, "", 0)
        
    elif text[0] == "rpgsell":
        steamid = ReturnSteam(userid)
        CreateSellMenu(userid,steamid)
        sellmenu = 'sell_%s'%userid
        popuplib.send(sellmenu, userid)
        return(0, "", 0)
        
    elif text[0] == "rpgtop10":
        a     = players.sort(10)
        index = 0
        top5  = popuplib.create('top5')
        top5.addline('=== SourceRPG Top10 ===')
        top5.addline('        Ranks 1 - %s       '%(min(5, len(a) ) ) )
        top5.addline('-----------------------')
        while index < min(5, len(a)):
            steamid = a[index]
            index += 1
            name, level, credits, xp = players.query(('Name', 'Level', 'Credits', 'Xp'), steamid)
            if len(name) > 16:
                name = name[0:14]+'...'
            top5.addline('->%s. %s - Level: %s Exp: %s Credits: %s'%(index, name, level, xp, credits))
        top5.addline('-----------------------')
        top5.addline(' ')
        if len(a) > 5: 
            top5.addline('9. Rank 6 - %s'%(min(10, len(a) ) ) )
            top5.submenu(9, 'top10')
            
            top10 = popuplib.create('top10')
            top10.addline('=== SourceRPG Top10 ===')
            top10.addline('        Ranks 6 - %s      '%(min(10, len(a) ) ) )
            top10.addline('-----------------------')
            while index < min(10, len(a) ):
                steamid = a[index]
                index += 1
                name, level, credits, xp = players.query(('Name', 'Level', 'Credits', 'Xp'), steamid)
                if len(name) > 16:
                    name = name[0:14]+'...'
                top10.addline('->%s. %s - Level: %s Exp: %s Credits: %s'%(index, name, level, xp, credits))   
            top10.addline('-----------------------')
            top10.addline('8. Rank 1 - 5')
            top10.addline(' ')
            top10.addline('0. Cancel')
            top10.submenu(8, 'top5')   
        top5.addline('0. Cancel')
        top5.send(userid)
        return(0, "", 0)

    elif text[0] == "rpgrank":
        if len(text) > 1:
            user = es.getuserid(text[1])
            if user:
                usteam = ReturnSteam(user)
                uname  = es.getplayername(user)
                SendRank(usteam, uname)
        else:
            steamid = ReturnSteam(userid)
            SendRank(steamid, es.getplayername(userid) )
        return(0, "", 0)
            
    elif text[0] == "rpgstats":
        
        steamid  = ReturnSteam(userid)
        
        database = players.sort()
        position = database.index(steamid) + 1
        total    = len(database)
        
        nextlevelxp = ( players.query('Level', steamid)  - 1) * int(es.ServerVar('srpg_XpIncrement')) + int(es.ServerVar('srpg_StartXP'))
        
        statsmenu = popuplib.create('stats_%s'%userid)
        a = statsmenu.addline
        a('=== SourceRPG Stats ===')
        a('-------------')
        a('Total Time: %.2f hours' % players.query('TotalTime', steamid) )
        a(' ')
        a('Level: %s' %  players.query('Level', steamid) )
        a('XP: %s/%s'% (players.query('Xp', steamid) ,nextlevelxp))
        a('XP Needed to Level: %s' % (nextlevelxp -  players.query('Xp', steamid) ) )
        a('Rank: %s/%s' % (position, total) )
        a(' ')
        a('-------------')
        a('9. Skill Stats')
        a('0. Back')
        statsmenu.select(9, SendSkillStats)
        statsmenu.submenu(10, 'rpgmenu')
        statsmenu.send(userid)
        return(0, "", 0)
        
    elif text[0] == "rpgpopup":
        steamid = ReturnSteam(userid)
        es.tell(userid,'#multi','#default%s #greenYou have turned your popups #lightgreen%s#green. Type #lightgreen\'rpgpopop\' #greento#lightgreen %s#green.' % ( (es.ServerVar('srpg_Prefix') ), ('on' if not players.query('Popup', steamid) else 'off'), ('De-Activate' if not players.query('Popup', steamid) else 'Activate') ) )
        players.update({'Popup': 1 - players.query('Popup', steamid)}, steamid )
        return(0, "", 0)
    return (userid, tempText, teamOnly)
es.addons.registerSayFilter(sayFilter)

def player_hurt(ev):
    """
    Called whenever a player is damaged. Define a lot of skills here:
    
    FireNade - Make sure that we delay, then call the extinguish block...
    IceStab - Set players color blue, then turn back after x seconds and unfreeze
    frostpistol - Same as IceStab except slow down to half speed instead of freeze
    vampire - Restore X percent of damage done to your own health
    Adrenaline - when hit speed the player up for X amount of seconds.
    Also start the Regen and RegenArmor skills...
    
    AddXP to the Attacker.. (X times the users level)
    """
    usteamid = ReturnSteam(ev['userid'])
    cmd = Command(ev['userid'])
    acmd = Command(ev['attacker'])
    if int(ev['attacker']):
        if not es.exists('userid',ev['attacker']):
            return
        asteamid = ReturnSteam(ev['attacker'])
        if ev['es_userteam'] != ev['es_attackerteam']:
            napalmNade  = players.query('NapalmNade', asteamid)
            iceStab     = players.query('IceStab', asteamid)
            frostPistol = players.query('FrostPistol', asteamid)
            vampire     = players.query('Vampire', asteamid)
            disable     = players.query('Disable', asteamid)
            adrenaline  = players.query('Adrenaline', usteamid)
            if ev['weapon'] == "hegrenade" and int(es.ServerVar('srpg_NapalmNade')) and napalmNade:
                es.server.queuecmd('es_xfire %s !self ignite' % ev['userid'])
                if napalmNade: 
                    gamethread.delayed(napalmNade, extinguish, ev['userid'])
            elif ev['weapon'] == "knife" and int(es.ServerVar('srpg_IceStab')):
                if int(ev['dmg_health']) > 40 and iceStab:
                    if not acmd.ReturnDict('Frozen'):
                        cmd.UpdateDict('Frozen',1)
                        cmd.Freeze(iceStab)
                        cmd.Color(100, 100, 255, time = iceStab)
                        gamethread.delayed(iceStab, cmd.UpdateDict, ('Frozen', 0))
                else:
                    pass
                    # Here, I'm going to do some sort of check to stop people who knife fight with left click...
                if int(es.ServerVar('srpg_KnifeXp')): 
                    AddXp(ev['attacker'],asteamid,((int(es.ServerVar('srpg_KnifeXp')) - int(es.ServerVar('srpg_DamageXp'))) * int(ev['dmg_health'])),'',False)
            
            elif ev['weapon'] in pistols and frostPistol and int(es.ServerVar('srpg_FrostPistol')):
                cmd.Slow(frostPistol / 20.0, frostPistol / 10.)
                cmd.Color(100, 100, 255, time = frostPistol / 10.)
            if ev['weapon'] in pistols or ev['weapon'] in rifles:
                if cmd.ReturnDict('Frozen') and int(es.ServerVar('srpg_IceStabDamageReduction')):
                    cmd.Heal(int(int(es.ServerVar('srpg_IceStabDamageReduction')) * int(ev['dmg_health']) / 100.0))
            if asteamid and disable and int(es.ServerVar('srpg_Disable')):
                rand = random.randint(1,100)
                if rand <= (disable * int(es.ServerVar('srgp_DisableDropPercentage'))):
                    es.sexec(ev['userid'],'drop')
            if asteamid and vampire and int(es.ServerVar('srpg_Vampire')):
                health = int(ev['dmg_health'])
                health = health * vampire * 7.5 / 100
                acmd.Heal(health)
                
            ubot = es.isbot(ev['userid'])
            abot = es.isbot(ev['attacker'])
            if not int(es.ServerVar('srpg_botsGetXpVsHumans')) and abot and not ubot:
                return
            if not int(es.ServerVar('srpg_botsGetXpVsBots'))   and ubot and abot:
                return
            if not int(es.ServerVar('srpg_humansGetXpVsBots')) and ubot and not abot:
                return
                
            AddXp(ev['attacker'], asteamid, (int(es.ServerVar('srpg_DamageXp')) * int(ev['dmg_health']) ), '', False)
            if adrenaline and int(es.ServerVar('srpg_Adrenaline')) and not cmd.ReturnDict('Slowed'):
                if not cmd.ReturnDict('AlreadyAdrenalined'):
                    cmd.UpdateDict('AlreadyAdrenalined', 1)
                    amount = adrenaline / 10.0
                    cmd.SpeedAdd(amount)
                    gamethread.delayed(int(es.ServerVar('srpg_AdrenalineLength')), cmd.SpeedAdd, amount * -1)
                    gamethread.delayed(int(es.ServerVar('srpg_AdrenalineLength')), cmd.UpdateDict, ('AlreadyAdrenalined',0))
                    
    regen       = players.query('Regen', usteamid)
    regenArmor  = players.query('RegenArmor', usteamid)
    if regen and int(es.ServerVar('srpg_Regen')):
        cmd.Regen()
    if regenArmor and int(es.ServerVar('srpg_RegenArmor')):
        cmd.RegenArmor()
        
def player_death(ev):
    """
    Here we stop the 'fire' sounds so it don't annoy people...
    Here the only skill we check for is recoverweapons... If he
    dies and he has the skill, then we tell the dict that next round
    we want to restore his weapons. Also add's xp (X times users level)
    """
    cmd      = Command(ev['userid'])
    steamid  = ReturnSteam(ev['userid'])
    asteamid = ReturnSteam(ev['attacker'])
    
    for sound in ('nature/fire/fire_small1.wav', 'fire/fire_big_loop1.wav', 'fire/fire_med_loop1.wav', 'fire/fire_small_loop2.wav', 'fire/gascan_ignite1.wav'):
		es.stopsound(ev['userid'], 'ambient/%s' % sound)
    
    if int(es.ServerVar('srpg_RecoverWeapons')) and players.query('RecoverWeapons', steamid):
        cmd.UpdateDict('RecoverActive', 1)
        if not int(ev['es_userarmor']):
            cmd.UpdateDict('Vest', 0)
            cmd.UpdateDict('VestHelm', 0)
            
    if ev['es_userteam'] != ev['es_attackerteam']:
        if asteamid:
            ubot = es.isbot(ev['userid'])
            abot = es.isbot(ev['attacker'])
            if not int(es.ServerVar('srpg_botsGetXpVsHumans')) and abot and not ubot:
                return
            if not int(es.ServerVar('srpg_botsGetXpVsBots'))   and ubot and abot:
                return
            if not int(es.ServerVar('srpg_humansGetXpVsBots')) and ubot and not abot:
                return
            AddXp(ev['attacker'], asteamid, int(es.ServerVar('srpg_KillXp')) * players.query('Level', steamid) , ' for Killing ' + ev['es_username'])
            if int(ev['headshot']):
                AddXp(ev['attacker'], asteamid, int(es.ServerVar('srpg_HsXp')), ' for getting a headshot')
                
    gamethread.cancelDelayed('medic_%s'%ev['userid'])
    
def hegrenade_detonate(ev):
    """
    Just deducts 1 if the user is set to have his HE's restored nextround.
    """
    player = Command(ev['userid'])
    if player.ReturnDict('RecoverHe') and int(es.ServerVar('srpg_RecoverWeapons')):
        player.UpdateDict('RecoverHe',0)
        
def flashbang_detonate(ev):
    """
    Deducts 1 if the user is set to have his Flashbangs restored next round.
    Also checks for the 'StunNade' skill.
    Get the location of the flashbang, then check if any people on the oposite team
    are near to the bang. If so, then shake their screen for X seconds, and half 
    their speed for X seconds.
    """
    if int(es.ServerVar('srpg_StunNade')):
        userid  = ev['userid']
        cmd     = Command(userid)
        steamid = ReturnSteam(userid)
        if cmd.ReturnDict('RecoverFlashbang'):
            cmd.ModDict('RecoverFlashbang',-1)
        stunNade = players.query('StunNade', steamid)
        if stunNade:
            x = float(ev['x'])
            y = float(ev['y'])
            z = float(ev['z'])
            distance   = stunNade * 50
            shakeTime  = stunNade * 2
            shakePower = shakeTime * 50
            for loopPlayer in playerlib.getPlayerList('#t,#alive' if int(ev['es_userteam']) == 3 else '#ct,#alive'):
                loopPlayer = int(loopPlayer)
                xx, yy, zz = es.getplayerlocation(loopPlayer)
                if abs(x - xx) <= distance and abs(y - yy) <= distance and abs(z - zz) <= distance:    
                    Command(loopPlayer).Shake(shakeTime, shakePower)
                    Command(loopPlayer).Slow(Command(loopPlayer).ReturnDict('MaxSpeed') / 2.0, shakeTime)
    
def weapon_reload(ev):
    """
    Starts the RegenAmmo skill.
    """
    if players.query('RegenAmmo', ReturnSteam(ev['userid'])) and int(es.ServerVar('srpg_RegenAmmo')):
        Command(ev['userid']).RegenAmmo()

def weapon_fire(ev):
    """
    If the user has a NapalmLevel, then ignite the grenade to look cool
    """
    if int(es.ServerVar('srpg_NapalmNade')):
        steamid = ReturnSteam(ev['userid'])
        if ev['weapon'] == "hegrenade":
            if players.query('NapalmNade', steamid):
                gamethread.delayed(0.1, es.server.queuecmd, 'es_xfire %s hegrenade_projectile ignite' % ev['userid'])

def item_pickup(ev):
    """
    Here's where we define what the user is going to respawn next round if 
    he has the restoreweapons skill. If level 1, then restore items, 2, pistols,
    3, primary weapons. Note: Cannot have USP or Glock, as you pick those up on spawn.
    """
    command = Command(ev['userid'])
    steamid = ReturnSteam(ev['userid'])
    if steamid in players:
        if players.query('RegenAmmo', steamid) and int(es.ServerVar('srpg_RegenAmmo')):
            if ev['item'] in pistols or ev['item'] in rifles:
                command.RegenAmmoLoop()
        recoverWeapons = players.query('RecoverWeapons', steamid)
        if int(es.ServerVar('srpg_RecoverWeapons')) and recoverWeapons:
            item    = ev['item']
            userid  = ev['userid']
            command = Command(userid).UpdateDict
            if item not in ['glock', 'usp']:
                if item in ['nvgs', 'vesthelm', 'vest', 'flashbang', 'hegrenade', 'smokegrenade']:
                    if item == 'nvgs': 
                        command('RecoverNvgs', 1)
                    elif item == 'vesthelm': 
                        command('RecoverVestHelm', 1)
                    elif item == 'vest': 
                        command('RecoverVest', 1)
                    elif item == 'flashbang':
                        Command(userid).ModDict('RecoverFlashbang', 1)
                    elif item == 'hegrenade': 
                        command('RecoverHe', 1)
                    else: 
                        command('RecoverSmoke', 1)
                elif item in pistols and recoverWeapons > 1:
                    command('RecoverSecondary', 'weapon_%s' % item)
                elif item in rifles and recoverWeapons > 2:
                    command('RecoverPrimary', 'weapon_%s' % item)

'''
The following LongJump code was made by SumGuy14
and Murphey. I thank them for it, and do not take
any credit for this skill myself. They are excellent
coders!
'''

def player_jump(ev):
    """
    Whenever a player jumps, get the velocity of the jump at start position,
    and then end... Create a vector between them, then 'Multiply' the vector
    so it will increase the speed in which he's pulled.
    """
    if int(es.ServerVar('srpg_LongJump')):
        steamid  = ReturnSteam(ev['userid'])
        longJump = int(players.query('LongJump', steamid)) 
        if longJump:
            vec1 = es.getplayerprop(ev['userid'], 'CBasePlayer.localdata.m_vecVelocity[0]')
            vec2 = es.getplayerprop(ev['userid'], 'CBasePlayer.localdata.m_vecVelocity[1]')
            vec1 = (longJump * vec1) * (1 / 4.1)
            vec2 = (longJump * vec2) * (1 / 4.1)
            vector = "%s,%s,0" % (vec1, vec2)
            es.setplayerprop(ev['userid'], 'CBasePlayer.localdata.m_vecBaseVelocity', vector)

'''
This smog skill was coded by the excellent
SuperDave. I had a go at myself, and went
a bit wrong, so he was kind enough to code
it for me!
'''

def smokegrenade_detonate(ev):
    """
    When a smoke grenade detonates, and the user has a SmogNade level,
    attach the usersID as the smokegrenades 'owner' then set it's
    ID inside a dictionary. 
    """
    if int(es.ServerVar('srpg_SmogNade')):
        steamid = ReturnSteam(ev['userid'])
        if int(players.query('SmogNade', steamid)):
            smokeplayer = int(ev['userid'])
            handle      = es.getplayerhandle(smokeplayer)
            for entity in es.createentitylist("smokegrenade_projectile"):
                if handle == es.getindexprop(entity, 'CBaseEntity.m_hOwnerEntity'):
                    smokedict[entity] = smokeplayer
                    gamethread.delayed(18, removesmog, entity)
                    
def sg_update():
    """
    Checks to see if the Smoke Grenade still exists... If so,
    then remove the damage area. Also, will check to see if any enemys
    are within the range of smoke, if so, then damage them.
    """
    if int(es.ServerVar('srpg_SmogNade')):
        smokelist = es.createentitylist("smokegrenade_projectile")
        for entity in smokedict.keys():
            if smokelist.has_key(entity):
                EntLoc = es.splitvectorstring(es.getindexprop(entity, 'CBaseEntity.m_vecOrigin'))
                player = smokedict[entity]
                for loop_player in playerlib.getPlayerList('#t,#alive' if int(es.getplayerteam(player)) == 3 else '#ct,#alive'):
                    location = loop_player.get('location')
                    if abs(EntLoc[0] - location[0]) <= 220 and abs(EntLoc[1] - location[1]) <= 220 and abs(EntLoc[2] - location[2]) <= 220:
                        es.server.queuecmd('damage %s %s 32 %s' % (int(loop_player), int(players.query('LongJump', ReturnSteam(player))), player))
                        str_int = random.randint(1,3)
                        es.emitsound('player',int(loop_player),'player/damage%s.wav'%str_int,'0.7','0.6')
            else:
                del smokedict[entity]
        gamethread.delayedname(1,'SmokeUpdate',sg_update)

def removesmog(smogentity):
    """
    Will remove the smoke Grenade entity after 18 seconds.
    """
    entitylist = es.createentitylist("smokegrenade_projectile")
    if smogentity in entitylist:
        es.server.queuecmd('es_xremove %s'%smogentity)

def extinguish(userid):
    """
    Extinguish a person that's on fire. Turn the entities of
    who the fire is attatcher to, and the lifetime to 0
    """
    if int(es.ServerVar('srpg_NapalmNade')):
        napalmlist = es.createentitylist("entityflame")
        handle     = es.getplayerhandle(userid)
        for entity in napalmlist:
            string = es.getindexprop(entity, 'CEntityFlame.m_hEntAttached')
            if string == handle:
                es.setindexprop(entity,'CEntityFlame.m_flLifetime', 0)
                break

def AddXp(userid, steamid, amount, reason = '', message=True):
    """
    A function to Add XP to the user, then will check
    to see if the user has gained a level. If so, then
    check to see if the popup state is active. If so then
    send the popup. If the user is a bot, then do Bot Functin
    (see below)
    """
    if turboMode:
        amount = float(es.ServerVar('srpg_turboExperienceMultiplier')) * amount
    xp, level, credits = players.query(('Xp', 'Level', 'Credits'), steamid)
    if message and int(es.ServerVar('srpg_AnnounceXP')) and userid and int(userid):
        tokens = {'name' : es.getplayername(userid), 'amount' : amount, 'reason' : reason, 'prefix' : es.ServerVar('srpg_Prefix') }
        es.tell(userid,'#multi',text('xp gained',tokens,playerlib.getPlayer(userid).get('lang') ) )
    xp += amount
    nextlevelxp = (level - 1) * int(es.ServerVar('srpg_XpIncrement')) + int(es.ServerVar('srpg_StartXP'))
    amountoflevels = 0
    while xp >= nextlevelxp:
        xp -= nextlevelxp
        amountoflevels += 1
        nextlevelxp += int(es.ServerVar('srpg_XpIncrement'))
    if amountoflevels:
        level += amountoflevels
        if not int(es.ServerVar('srpg_MaxLevel')) or level <= int(es.ServerVar('srpg_MaxLevel')):
            credits += amountoflevels * int(es.ServerVar('srpg_CreditIncrement'))
            
            if turboMode:
                credits *= int(float(es.ServerVar('srpg_turboCreditMultiplier')))
            
            players.update({'Level' : level, 'Credits' : credits}, steamid)
            
            if userid and int(userid) and not es.getplayerprop(userid,'CBasePlayer.pl.deadflag'):
                location = es.getplayerlocation(userid)
                if isEst:
                    es.server.queuecmd('est_effect 10 #a 0 "sprites/steam1.vmt" %s %s %s 20 50 3 20 5 2 255 200 0 200 1'%(location[0],location[1],location[2]))
            if userid and int(userid) and es.ServerVar('srpg_LevelUpSound'):
                es.emitsound('player',userid,es.ServerVar('srpg_LevelUpSound'),'0.7','0.5')
            if userid and int(userid) and "BOT" not in steamid and players.query('Popup', steamid):
                CreateSkillMenu(userid,steamid)
                skillmenu = 'skill_%s'%userid
                popuplib.send(skillmenu,userid)
            elif "BOT" in steamid:
                if int(es.ServerVar('srpg_BotMaxLevel')):
                    if level > int(es.ServerVar('srpg_BotMaxLevel')):
                        ResetSkills(userid if es.exists('userid', userid) else steamid, None, None)
                        return
                if es.exists('userid',userid):
                    BotLevelUp(userid,steamid,credits)
            if int(es.ServerVar('srpg_LevelUp')):
                if es.exists('userid',userid):
                    tokens = {'name':es.getplayername(userid),'level':level,'xp':xp,'nextxp':nextlevelxp,'prefix':es.ServerVar('srpg_Prefix')}
                    for userid in es.getUseridList():
                        es.tell(userid,'#multi',text('level gained global',tokens,playerlib.getPlayer(userid).get('lang')))
            elif es.exists('userid',userid):
                tokens = {'level':level,'xp':xp,'nextxp':nextlevelxp,'prefix':es.ServerVar('srpg_Prefix')}
                es.tell(userid,'#multi',text('level gained private', tokens, playerlib.getPlayer(userid).get('lang')))
        elif int(es.ServerVar('srpg_MaxLevelReset')) and int(es.ServerVar('srpg_MaxLevel')):
            if es.exists('userid', userid):
                ResetSkills(userid)
            else:
                ResetSkills(steamid)
    players.update({'Xp' : xp}, steamid)
    
def BotLevelUp(userid, steamid, credits = None):
    """
    A function which randomly chooses a bots skill to level.
    If the bot has enough credits, then set that skill to the level. 
    """
    userid = str(userid)
    if credits is None:
        credits = players.query('Credits', steamid)
    randomList = []
    for skill in ['Health','Regen','RegenAmmo','NapalmNade','Vampire','Stealth','LongJump','IceStab','FrostPistol','StunNade','SmogNade','Speed','Gravity','Disable','RecoverWeapons','RegenArmor','Medic','Adrenaline']:
        if int(es.ServerVar('srpg_%s' % skill)):
            level    = players.query(skill, steamid)
            maxLevel = int(es.ServerVar('srpg_%sMax' % skill))
            if level < maxLevel:
                creditsNeeded = (level * int(es.ServerVar('srpg_%sCreditsIncrement' % skill)) + int(es.ServerVar('srpg_%sCreditsStart' % skill)))
                if credits >= creditsNeeded:
                    randomList.append(skill)
    if not randomList: 
        return
    skill         = random.choice(randomList)
    creditsNeeded = (level * int(es.ServerVar('srpg_%sCreditsIncrement'%skill)) + int(es.ServerVar('srpg_%sCreditsStart' % skill)))
    players.increment({skill: 1, 'Credits' : creditsNeeded * -1}, steamid)
    if skill == "Health":
        Command(userid).HealthAdd(int(es.ServerVar('srpg_HealthIncrement')))
    elif skill == "Stealth":
        alpha = (255 - round((255/(int(es.ServerVar('srpg_StealthMax') + 1))) * players.query('Stealth', steamid) ) )
        Command(userid).Color(255, 255, 255, alpha)
    elif skill == "Speed":
        speed = 1 + (((float(es.ServerVar('srpg_SpeedMaxMovementSpeed')) - 1)/float(es.ServerVar('srpg_SpeedMax') ) ) * players.query('Speed', steamid) )
        Command(userid).Speed(speed)
    if es.ServerVar('srpg_SkillUpgradeSound'):
        es.emitsound('player', userid, es.ServerVar('srpg_SkillUpgradeSound'), '0.7', '0.5')
    BotLevelUp(userid, steamid)
    
def CreateSkillMenu(userid,steamid):
    """
    THis function creates a specific popup just for that user.
    It contains his skills, and whether or not he can buy them.
    It will also calculate how much it will cost to buy each skill
    and show it.
    """
    p = 'skill_%s'%userid
    
    credits, healthl, regenl, regenammol, firenadel, vampirel, stealthl, longjumpl,\
    icestabl, frostpistoll, stunnadel, smognadel, speedl, gravityl, disablel,\
    recoverweaponsl, regenarmorl, adrenalinel, medicl = players.query(('Credits',\
    'Health', 'Regen', 'RegenAmmo', 'NapalmNade', 'Vampire', 'Stealth', 'LongJump',\
    'IceStab', 'FrostPistol', 'StunNade', 'SmogNade', 'Speed', 'Gravity', 'Disable',\
    'RecoverWeapons', 'RegenArmor', 'Adrenaline', 'Medic'), steamid)
    
    a = popuplib.easymenu(p, '_popup_choice', UpgradeSkill)
    a.settitle('Please Select A Skill To Upgrade\n        Credits Available: %s\n               Page: '%credits)
    if int(es.ServerVar('srpg_Health')):
        if healthl < int(es.ServerVar('srpg_HealthMax')):
            a.addoption('Health','Health+ Lvl %s [Cost: %s]'%(healthl + 1, healthl * int(es.ServerVar('srpg_HealthCreditsIncrement')) + int(es.ServerVar('srpg_HealthCreditsStart'))))
        else:
            a.addoption('HealthMax','Health+ (MAX)',False)
    if int(es.ServerVar('srpg_Regen')):        
        if regenl < int(es.ServerVar('srpg_RegenMax')):
            a.addoption('Regen','Regeneration Lvl %s [Cost: %s]'%(regenl + 1, regenl * int(es.ServerVar('srpg_RegenCreditsIncrement')) + int(es.ServerVar('srpg_RegenCreditsStart'))))
        else:    
            a.addoption('RegenMax','Regeneration (MAX)',False)
    if int(es.ServerVar('srpg_RegenAmmo')):        
        if regenammol < int(es.ServerVar('srpg_RegenAmmoMax')):    
            a.addoption('RegenAmmo','Regenerate Ammo Lvl %s [Cost: %s]'%(regenammol + 1, regenammol * int(es.ServerVar('srpg_RegenAmmoCreditsIncrement')) + int(es.ServerVar('srpg_RegenAmmoCreditsStart'))))
        else:        
            a.addoption('Regenerate AmmoMax','Regenerate Ammo (MAX)',False)
    if int(es.ServerVar('srpg_NapalmNade')):        
        if firenadel < int(es.ServerVar('srpg_NapalmNadeMax')):    
            a.addoption('NapalmNade','Napalm Grenades Lvl %s [Cost: %s]'%(firenadel + 1, firenadel * int(es.ServerVar('srpg_NapalmNadeCreditsIncrement')) + int(es.ServerVar('srpg_NapalmNadeCreditsStart'))))
        else:
            a.addoption('Napalm GrenadeMax','Napalm Grenades (MAX)',False)
    if int(es.ServerVar('srpg_Vampire')):        
        if vampirel < int(es.ServerVar('srpg_VampireMax')):    
            a.addoption('Vampire','Vampire Lvl %s [Cost: %s]'%(vampirel + 1, vampirel * int(es.ServerVar('srpg_VampireCreditsIncrement')) + int(es.ServerVar('srpg_VampireCreditsStart'))))
        else:
            a.addoption('VampireMax','Vampire (MAX)',False)
    if int(es.ServerVar('srpg_Stealth')):        
        if stealthl < int(es.ServerVar('srpg_StealthMax')):    
            a.addoption('Stealth','Stealth Lvl %s [Cost: %s]'%(stealthl + 1, stealthl * int(es.ServerVar('srpg_StealthCreditsIncrement')) + int(es.ServerVar('srpg_StealthCreditsStart'))))
        else:
            a.addoption('StealthMax','Stealth (MAX)',False)
    if int(es.ServerVar('srpg_LongJump')):        
        if longjumpl < int(es.ServerVar('srpg_LongJumpMax')):    
            a.addoption('LongJump','Long Jump Lvl %s [Cost: %s]'%(longjumpl + 1, longjumpl * int(es.ServerVar('srpg_LongJumpCreditsIncrement')) + int(es.ServerVar('srpg_LongJumpCreditsStart'))))
        else:
            a.addoption('Long JumpMax','Long Jump (MAX)',False)
    if int(es.ServerVar('srpg_IceStab')):        
        if icestabl < int(es.ServerVar('srpg_IceStabMax')):    
            a.addoption('IceStab','Ice Stab Lvl %s [Cost: %s]'%(icestabl + 1, icestabl * int(es.ServerVar('srpg_IceStabCreditsIncrement')) + int(es.ServerVar('srpg_IceStabCreditsStart'))))
        else:
            a.addoption('Ice StabMax','Ice Stab (MAX)',False)
    if int(es.ServerVar('srpg_FrostPistol')):       
        if frostpistoll < int(es.ServerVar('srpg_FrostPistolMax')):    
            a.addoption('FrostPistol','Frost Pistol Lvl %s [Cost: %s]'%(frostpistoll + 1, frostpistoll * int(es.ServerVar('srpg_FrostPistolCreditsIncrement')) + int(es.ServerVar('srpg_FrostPistolCreditsStart'))))
        else:
            a.addoption('Frost PistolMax','Frost Pistol (MAX)',False)
    if int(es.ServerVar('srpg_StunNade')):        
        if stunnadel < int(es.ServerVar('srpg_StunNadeMax')):    
            a.addoption('StunNade','Stun Grenade Lvl %s [Cost: %s]'%(stunnadel + 1, stunnadel * int(es.ServerVar('srpg_StunNadeCreditsIncrement')) + int(es.ServerVar('srpg_StunNadeCreditsStart'))))
        else:
            a.addoption('Stun GrenadeMax','Stun Grenade (MAX)',False)
    if int(es.ServerVar('srpg_SmogNade')):        
        if smognadel < int(es.ServerVar('srpg_SmogNadeMax')):    
            a.addoption('SmogNade','Smog Grenade Lvl %s [Cost: %s]'%(smognadel + 1, smognadel * int(es.ServerVar('srpg_SmogNadeCreditsIncrement')) + int(es.ServerVar('srpg_SmogNadeCreditsStart'))))
        else:
            a.addoption('Smog GrenadeMax','Smog Grenade (MAX)',False)
    if int(es.ServerVar('srpg_Speed')):        
        if speedl < int(es.ServerVar('srpg_SpeedMax')):    
            a.addoption('Speed','Speed+ Lvl %s [Cost: %s]'%(speedl + 1, speedl * int(es.ServerVar('srpg_SpeedCreditsIncrement')) + int(es.ServerVar('srpg_SpeedCreditsStart'))))
        else:
            a.addoption('SpeedMax','Speed+ (MAX)',False)
    if int(es.ServerVar('srpg_Gravity')):        
        if gravityl < int(es.ServerVar('srpg_GravityMax')):    
            a.addoption('Gravity','Gravity- Lvl %s [Cost: %s]'%(gravityl + 1, gravityl * int(es.ServerVar('srpg_GravityCreditsIncrement')) + int(es.ServerVar('srpg_GravityCreditsStart'))))
        else:
            a.addoption('GravityMax','Gravity- (MAX)',False)
    if int(es.ServerVar('srpg_Disable')):        
        if disablel < int(es.ServerVar('srpg_DisableMax')):    
            a.addoption('Disable','Disable Lvl %s [Cost: %s]'%(disablel + 1, disablel * int(es.ServerVar('srpg_DisableCreditsIncrement')) + int(es.ServerVar('srpg_DisableCreditsStart'))))
        else:
            a.addoption('DisableMax','Disable (MAX)',False)
    if int(es.ServerVar('srpg_RecoverWeapons')):        
        if recoverweaponsl < int(es.ServerVar('srpg_RecoverWeaponsMax')):    
            a.addoption('RecoverWeapons','Recover Weapons Lvl %s [Cost: %s]'%(recoverweaponsl + 1, recoverweaponsl * int(es.ServerVar('srpg_RecoverWeaponsCreditsIncrement')) + int(es.ServerVar('srpg_RecoverWeaponsCreditsStart'))))
        else:
            a.addoption('Recover WeaponsMax','Recover Weapons (MAX)',False)
    if int(es.ServerVar('srpg_RegenArmor')):        
        if regenarmorl < int(es.ServerVar('srpg_RegenArmorMax')):
            a.addoption('RegenArmor','Regenerate Armor Lvl %s [Cost: %s]'%(regenarmorl + 1, regenarmorl * int(es.ServerVar('srpg_RegenArmorCreditsIncrement')) + int(es.ServerVar('srpg_RegenArmorCreditsStart'))))
        else:
            a.addoption('Regen ArmorMax','Regenerate Armor (MAX)',False)
    if int(es.ServerVar('srpg_Adrenaline')):        
        if adrenalinel < int(es.ServerVar('srpg_AdrenalineMax')):
            a.addoption('Adrenaline','Adrenaline Lvl %s [Cost: %s]'%(adrenalinel + 1, adrenalinel * int(es.ServerVar('srpg_AdrenalineCreditsIncrement')) + int(es.ServerVar('srpg_AdrenalineCreditsStart'))))
        else:
            a.addoption('AdrenalineMax','Adrenaline (MAX)',False)
    if int(es.ServerVar('srpg_Medic')):        
        if medicl < int(es.ServerVar('srpg_MedicMax')):
            a.addoption('Medic','Medic Lvl %s [Cost: %s]'%(medicl + 1, medicl * int(es.ServerVar('srpg_MedicCreditsIncrement')) + int(es.ServerVar('srpg_MedicCreditsStart'))))
        else:
            a.addoption('MedicMax','Medic (MAX)',False)
        
def UpgradeSkill(userid, choice, popupid):
    """
    This function is called when a user selects a skill
    to upgrade. It will check that 'Maximum' is not in the
    skill choice name... If it isn't, then it will calculate
    if the user has enough credits, and if he does, then deduct
    the credits it took to buy it away from his total credits,
    and add 1 to the skill
    """
    userid = str(userid)
    steamid = ReturnSteam(userid)
    if not steamid: 
        return
    if 'Max' not in choice:
        if int(es.ServerVar('srpg_' + choice)):
            level = players.query(choice, steamid) 
            if level < 0: 
                level = 0
            creditIncrement = 'srpg_%sCreditsIncrement'%choice
            creditStart     = 'srpg_%sCreditsStart'%choice
            credits         = players.query('Credits', steamid)
            creditsRequired = level * int(es.ServerVar(creditIncrement)) + int(es.ServerVar(creditStart))
            if credits >= creditsRequired:
                level += 1
                credits -= creditsRequired
                players.update({choice : level, 'Credits' : credits}, steamid)
                if choice == "Regen":            choice = "Regeneration"
                elif choice == "RegenAmmo":      choice = "Regenerate Ammo"
                elif choice == "NapalmNade":     choice = "Napalm Grenade"
                elif choice == "LongJump":       choice = "Long Jump"
                elif choice == "IceStab":        choice = "Ice Stab"
                elif choice == "FrostPistol":    choice = "Frost Pistol"
                elif choice == "StunNade":       choice = "Stun Grenade"
                elif choice == "SmogNade":       choice = "Smog Grenade"
                elif choice == "RecoverWeapons": choice = "Recover Weapons"
                elif choice == "RegenArmor":     choice = "Regenerate Armor"
                elif choice == "Health":
                    Command(userid).HealthAdd(int(es.ServerVar('srpg_HealthIncrement')))
                elif choice == "Stealth":
                    alpha = (255 - round((255/(int(es.ServerVar('srpg_StealthMax') + 1))) * players.query('Stealth', steamid) ) )
                    Command(userid).Color(255, 255, 255, alpha)
                elif choice == "Speed":
                    speed = 1 + ( ( (float(es.ServerVar('srpg_SpeedMaxMovementSpeed')) - 1)/float(es.ServerVar('srpg_SpeedMax'))) * players.query('Speed', steamid) )
                    Command(userid).Speed(speed)
                if str(es.ServerVar('srpg_SkillUpgradeSound')):
                    es.emitsound('player', userid, str(es.ServerVar('srpg_SkillUpgradeSound')), '0.7', '0.5')
                tokens = {'prefix' : es.ServerVar('srpg_Prefix'), 'level' : level, 'skill' : choice}
                es.tell(userid, '#multi', text('skill upgrade', tokens, playerlib.getPlayer(userid).get('lang') ) )
            else:
                tokens = {'credreq' : creditsRequired, 'amountofcred' : creditsRequired - credits, 'prefix' : es.ServerVar('srpg_Prefix'), 'credits' : credits}
                es.tell(userid, '#multi', text('insufficient credits', tokens, playerlib.getPlayer(userid).get('lang') ) )
        else:
            tokens = {'skill' : choice, 'prefix' : es.ServerVar('srpg_Prefix')}
            es.tell(userid,'#multi',text('disabled skill',tokens,playerlib.getPlayer(userid).get('lang')))
            
    CreateSkillMenu(userid,steamid)
    skillmenu = popuplib.find('skill_%s' % userid)
    lang      = skillmenu.i_userlang(userid)
    index     = filter(lambda x: skillmenu.options[lang][x].value == choice, skillmenu.options[lang])
    skillmenu.sendPage(userid, skillmenu.getPageNumber(index[0] if index else 1, skillmenu.i_userlang(userid) ) )

def CreateSellMenu(userid,steamid):
    """
    This Function is called when a user selects 'sell skills'
    on the rpgmenu, or types rpgsell. This will then show
    whether the user can sell the skill (incase he doesn't
    have a level), and tell him how much he can sell each skill
    for. It will also calculate the level the skill will go down
    to if he sells it.
    """
    p = 'sell_%s'%userid
    
    credits, healthl, regenl, regenammol, firenadel, vampirel, stealthl, longjumpl,\
    icestabl, frostpistoll, stunnadel, smognadel, speedl, gravityl, disablel,\
    recoverweaponsl, regenarmorl, adrenalinel, medicl = players.query(('Credits',\
    'Health', 'Regen', 'RegenAmmo', 'NapalmNade', 'Vampire', 'Stealth', 'LongJump',\
    'IceStab', 'FrostPistol', 'StunNade', 'SmogNade', 'Speed', 'Gravity', 'Disable',\
    'RecoverWeapons', 'RegenArmor', 'Adrenaline', 'Medic'), steamid)
    
    a = popuplib.easymenu(p, '_popup_choice', DowngradeSkill)
    a.settitle('Please Select A Skill To Sell\n        Credits Available: %s\n        Sales Percentage: %s\n               Page: '%(credits,int(es.ServerVar('srpg_SellPercentage'))))
    if int(es.ServerVar('srpg_Health')):
        if healthl:
            a.addoption('Health','Health+ Lvl %s [Sell Price: %s]'%(healthl - 1, int((((healthl - 1) * int(es.ServerVar('srpg_HealthCreditsIncrement'))) + (int(es.ServerVar('srpg_HealthCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('HealthMax','Health+ - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_Regen')):
        if regenl:
            a.addoption('Regen','Regeneration Lvl %s [Sell Price: %s]'%(regenl - 1, int((((regenl - 1) * int(es.ServerVar('srpg_RegenCreditsIncrement'))) + (int(es.ServerVar('srpg_RegenCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:    
            a.addoption('RegenMax','Regeneration - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_RegenAmmo')):
        if regenammol:    
            a.addoption('RegenAmmo','Regenerate Ammo Lvl %s [Sell Price: %s]'%(regenammol - 1, int((((regenammol - 1) * int(es.ServerVar('srpg_RegenAmmoCreditsIncrement'))) + (int(es.ServerVar('srpg_RegenAmmoCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:        
            a.addoption('Regenerate AmmoMax','Regenerate Ammo - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_NapalmNade')):
        if firenadel:    
            a.addoption('NapalmNade','Napalm Grenades Lvl %s [Sell Price: %s]'%(firenadel - 1, int((((firenadel - 1) * int(es.ServerVar('srpg_NapalmNadeCreditsIncrement'))) + (int(es.ServerVar('srpg_NapalmNadeCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('Napalm GrenadeMax','Napalm Grenades - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_Vampire')):
        if vampirel:    
            a.addoption('Vampire','Vampire Lvl %s [Sell Price: %s]'%(vampirel - 1, int((((vampirel - 1) * int(es.ServerVar('srpg_VampireCreditsIncrement'))) + (int(es.ServerVar('srpg_VampireCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('VampireMax','Vampire - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_Stealth')):
        if stealthl:    
            a.addoption('Stealth','Stealth Lvl %s [Sell Price: %s]'%(stealthl - 1, int((((stealthl - 1) * int(es.ServerVar('srpg_StealthCreditsIncrement'))) + (int(es.ServerVar('srpg_StealthCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('StealthMax','Stealth - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_LongJump')):
        if longjumpl:    
            a.addoption('LongJump','Long Jump Lvl %s [Sell Price: %s]'%(longjumpl - 1, int((((longjumpl - 1) * int(es.ServerVar('srpg_LongJumpCreditsIncrement'))) + (int(es.ServerVar('srpg_LongJumpCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('Long JumpMax','Long Jump - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_IceStab')):
        if icestabl:    
            a.addoption('IceStab','Ice Stab Lvl %s [Sell Price: %s]'%(icestabl - 1, int((((icestabl - 1) * int(es.ServerVar('srpg_IceStabCreditsIncrement'))) + (int(es.ServerVar('srpg_IceStabCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('Ice StabMax','Ice Stab - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_FrostPistol')):
        if frostpistoll:    
            a.addoption('FrostPistol','Frost Pistol Lvl %s [Sell Price: %s]'%(frostpistoll - 1, int((((frostpistoll - 1) * int(es.ServerVar('srpg_FrostPistolCreditsIncrement'))) + (int(es.ServerVar('srpg_FrostPistolCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('Frost PistolMax','Frost Pistol - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_StunNade')):
        if stunnadel:    
            a.addoption('StunNade','Stun Grenade Lvl %s [Sell Price: %s]'%(stunnadel - 1, int((((stunnadel - 1) * int(es.ServerVar('srpg_StunNadeCreditsIncrement'))) + (int(es.ServerVar('srpg_StunNadeCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('Stun GrenadeMax','Stun Grenade - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_SmogNade')):
        if smognadel:    
            a.addoption('SmogNade','Smog Grenade Lvl %s [Sell Price: %s]'%(smognadel - 1, int((((smognadel - 1) * int(es.ServerVar('srpg_SmogNadeCreditsIncrement'))) + (int(es.ServerVar('srpg_SmogNadeCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('Smog GrenadeMax','Smog Grenade - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_Speed')):
        if speedl:    
            a.addoption('Speed','Speed+ Lvl %s [Sell Price: %s]'%(speedl - 1, int((((speedl - 1) * int(es.ServerVar('srpg_SpeedCreditsIncrement'))) + (int(es.ServerVar('srpg_SpeedCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('SpeedMax','Speed+ - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_Gravity')):
        if gravityl:    
            a.addoption('Gravity','Gravity- Lvl %s [Sell Price: %s]'%(gravityl - 1, int((((gravityl - 1) * int(es.ServerVar('srpg_GravityCreditsIncrement'))) + (int(es.ServerVar('srpg_GravityCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('GravityMax','Gravity- - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_Disable')):
        if disablel:    
            a.addoption('Disable','Disable Lvl %s [Sell Price: %s]'%(disablel - 1, int((((disablel - 1) * int(es.ServerVar('srpg_DisableCreditsIncrement'))) + (int(es.ServerVar('srpg_DisableCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('DisableMax','Disable - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_RecoverWeapons')):
        if recoverweaponsl:    
            a.addoption('RecoverWeapons','Recover Weapons Lvl %s [Sell Price: %s]'%(recoverweaponsl - 1, int((((recoverweaponsl - 1) * int(es.ServerVar('srpg_RecoverWeaponsCreditsIncrement'))) + (int(es.ServerVar('srpg_RecoverWeaponsCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('Recover WeaponsMax','Recover Weapons - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_RegenArmor')):
        if regenarmorl:    
            a.addoption('RegenArmor','Regenerate Armor Lvl %s [Sell Price: %s]'%(regenarmorl - 1, int((((regenarmorl - 1) * int(es.ServerVar('srpg_RegenArmorCreditsIncrement'))) + (int(es.ServerVar('srpg_RegenArmorCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('Regenerate ArmorMax','Regenerate Armor - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_Adrenaline')):   
        if adrenalinel:    
            a.addoption('Adrenaline','Adrenaline Lvl %s [Sell Price: %s]'%(adrenalinel - 1, int((((adrenalinel - 1) * int(es.ServerVar('srpg_AdrenalineCreditsIncrement'))) + (int(es.ServerVar('srpg_AdrenalineCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('Adrenaline','Adrenaline - Need a Level to Sell',False)
    if int(es.ServerVar('srpg_Medic')): 
        if medicl:    
            a.addoption('Medic','Medic Lvl %s [Sell Price: %s]'%(medicl - 1, int((((medicl - 1) * int(es.ServerVar('srpg_MedicCreditsIncrement'))) + (int(es.ServerVar('srpg_MedicCreditsStart')))) * int(es.ServerVar('srpg_SellPercentage'))/100)))
        else:
            a.addoption('Medic','Medic - Need a Level to Sell',False)

def DowngradeSkill(userid, choice, popupid):
    """
    Will check to see if the user has at least level 1 in the skill,
    works out how much they will receive, then deduct a level and
    add the credits
    """
    userid = str(userid)
    steamid = ReturnSteam(userid)
    if 'Max' not in choice:
        level = players.query(choice, steamid) 
        creditIncrement = int(es.ServerVar('srpg_%sCreditsIncrement' % choice) )
        creditStart     = int(es.ServerVar('srpg_%sCreditsStart' % choice) )
        percentage      = int(es.ServerVar('srpg_SellPercentage') )
        credits         = players.query('Credits', steamid)
        creditsgained   = int( ( ( (level - 1) * creditIncrement) + creditStart) * percentage / 100)
        level          -= 1
        credits        += creditsgained
        players.update({choice: level, 'Credits' : credits}, steamid)
        
        if choice == "Regen":            choice = "Regeneration"
        elif choice == "RegenAmmo":      choice = "Regenerate Ammo"
        elif choice == "NapalmNade":     choice = "Napalm Grenade"
        elif choice == "LongJump":       choice = "Long Jump"
        elif choice == "IceStab":        choice = "Ice Stab"
        elif choice == "FrostPistol":    choice = "Frost Pistol"
        elif choice == "StunNade":       choice = "Stun Grenade"
        elif choice == "SmogNade":       choice = "Smog Grenade"
        elif choice == "RecoverWeapons": choice = "Recover Weapons"
        elif choice == "RegenArmor":     choice = "Regenerate Armor"
        elif choice == "Health":
            Command(userid).HealthAdd(int(es.ServerVar('srpg_HealthIncrement') ) * (-1))
        elif choice == "Stealth":
            alpha = (255 - round( (255/(int(es.ServerVar('srpg_StealthMax') + 1) ) ) * players.query("Stealth", steamid) ) )
            Command(userid).Color(255, 255, 255, alpha)
        elif choice == "Speed":
            speed = 1 + ( ( (float(es.ServerVar('srpg_SpeedMaxMovementSpeed') ) - 1) / float(es.ServerVar('srpg_SpeedMax') ) ) * players.query("Speed", steamid) )
            Command(userid).Speed(speed)
        if str(es.ServerVar('srpg_SkillDowngradeSound')):
            es.emitsound('player', userid, str(es.ServerVar('srpg_SkillDowngradeSound')), '0.7', '0.5')
        tokens = {'prefix':es.ServerVar('srpg_Prefix'),'level':level,'skill':choice}
        es.tell(userid,'#multi',text('skill downgrade',tokens,playerlib.getPlayer(userid).get('lang')))
    CreateSellMenu(userid,steamid)
    sellmenu = popuplib.find('sell_%s' % userid)
    lang     = sellmenu.i_userlang(userid)
    index    = filter(lambda x: sellmenu.options[lang][x].value == choice, sellmenu.options[lang])
    sellmenu.sendPage(userid, sellmenu.getPageNumber(index[0] if index else 1, sellmenu.i_userlang(userid) ) )
    #popuplib.send(sellmenu, userid) 
                 
def IsEnabled(x):
    """
    Simple function to return whether or not the skill is enabled or disabled
    """
    if x: return '[Enabled]'
    else: return '[Disabled]'

def setup_auth():
    """
    Sets up an auth check service, to return whether or not the user is authed.
    """
    global isAuthed
    if services.isRegistered('auth'):
        auth_service = services.use('auth')
        auth_service.registerCapability('sourcerpg_admin', auth_service.ADMIN)
        isAuthed = lambda x: auth_service.isUseridAuthorized(x, 'sourcerpg_admin')
    else:
        isAuthed = lambda x: False
      
def AdminAddXp(adminid = None, steamid = None, amount = None, reason = ""):
    """
    Checks to see if the arguments are correct, then adds the xp to the user
    """
    if adminid is None and target is None and amount is None and reason is None:
        adminid = es.getcmduserid()
        tempid = str(es.getargv(1))
        if tempid.isdigit():
            userid  = tempid
            steamid = ReturnSteam(tempid)
        elif tempid.lower().startswith('steam_'):
            steamid = tempid.replace('/',':')
            userid  = None
        else:
            userid  = str(es.getuserid(tempid))
            steamid = ReturnSteam(userid)
        amount = str(es.getargv(2))
        if not amount.isdigit():
            es.tell(adminid, '#green', es.ServerVar('srpg_Prefix') + ' The correct syntax is: rpg_addlevel <userid/name/steamid> <amount>')
            return
        length = es.getargc()
        if es.getargc() > 3:
            reason = ' '.join(es.getargs().split()[3:])
    if not isAuthed(adminid):
        es.tell(adminid, '#green', 'You are not authorised to run the \'rpg_addlevel\' command!')
        return
        
    userid = es.getuserid(steamid)
    AddXp(userid, steamid, int(amount), reason)
    
def AdminAddLevel(adminid = None, steamid = None, amount = None):
    """
    Checks to see if the arguments are correct, then adds levels to the user.
    """
    if adminid is None and target is None and amount is None:
        adminid = es.getcmduserid()
        tempid = str(es.getargv(1))
        if tempid.isdigit():
            steamid = ReturnSteam(tempid)
        elif tempid.lower().startswith('steam_'):
            steamid = tempid.replace('/',':')
        else:
            steamid = ReturnSteam(userid)
        amount = str(es.getargv(2))
        if not amount.isdigit():
            es.tell(adminid, '#green', es.ServerVar('srpg_Prefix') + ' The correct syntax is: rpg_addlevel <userid/name/steamid> <amount>')
            return
    if not isAuthed(adminid):
        es.tell(adminid, '#green', 'You are not authorised to run the \'rpg_addlevel\' command!')
        return
                    
    level, xp  = players.query(("Level", "Xp"), steamid)
    level     += int(amount)
    userid     = es.getuserid(steamid)
    if not int(es.ServerVar('srpg_MaxLevel')) or level <= int(es.ServerVar('srpg_MaxLevel')):
        credits     = players.query('credits', steamid)
        credits    += int(amount) * int(es.ServerVar('srpg_CreditIncrement'))
        players.update({'Credits' : credits, 'Level': level}, steamid)
        nextlevelxp = (level - 1) * int(es.ServerVar('srpg_XpIncrement')) + int(es.ServerVar('srpg_StartXP'))
        if userid and not es.getplayerprop(userid, 'CBasePlayer.pl.deadflag'):
            location = es.getplayerlocation(userid)
            if isEst:
                es.server.queuecmd('est_effect 10 #a 0 "sprites/steam1.vmt" %s %s %s 20 50 3 20 5 2 255 200 0 200 1'%(location[0],location[1],location[2]))
            if str(es.ServerVar('srpg_LevelUpSound')):
                es.emitsound('player', userid, str(es.ServerVar('srpg_LevelUpSound')), '0.7', '0.5')
        if userid and "BOT" not in steamid:
            CreateSkillMenu(userid,steamid)
            skillmenu = 'skill_%s'%userid
            popuplib.send(skillmenu,userid)
        else:
            if es.exists('userid', userid):
                BotLevelUp(userid, steamid, credits)
        if userid and int(es.ServerVar('srpg_LevelUp')):
            tokens = {'name':es.getplayername(userid), 'level' : level, 'xp' : xp, 'nextxp' : nextlevelxp, 'prefix' : es.ServerVar('srpg_Prefix')}
            for userid in es.getUseridList():
                es.tell(userid, '#multi', text('level gained global', tokens, playerlib.getPlayer(userid).get('lang') ) )
        elif userid:
            tokens = {'level' : level, 'xp' : xp, 'nextxp' : nextlevelxp, 'prefix' : es.ServerVar('srpg_Prefix')}
            es.tell(userid,'#multi',text('level gained private', tokens, playerlib.getPlayer(userid).get('lang')))
    elif userid and int(es.ServerVar('srpg_MaxLevelReset')) and int(es.ServerVar('srpg_MaxLevel')):
        es.tell(userid, '#multi', text('maximum level reached', {'prefix':es.ServerVar('srpg_Prefix')}, playerlib.getPlayer(userid).get('lang')))
        ResetSkills(userid)
        
def AdminAddCredit(userid = None, steamid = None, amount = None, reason = ' for being loved by the admin'):
    """
    Checks to see if the args are correct, if so, then retrive the targets
    credits, adds the amount, then sets it
    """
    if userid is None and target is None and amount is None:
        userid = es.getcmduserid()
        tempid = str(es.getargv(1))
        if tempid.isdigit():
            steamid = ReturnSteam(tempid)
        elif tempid.lower().startswith('steam_'):
            steamid = tempid.replace('/',':')
        else:
            steamid = ReturnSteam(userid)
        amount = str(es.getargv(2))
        if not amount.isdigit():
            es.tell(userid, '#green', es.ServerVar('srpg_Prefix') + ' The correct syntax is: rpg_addlevel <userid/name/steamid> <amount>')
            return
            
    if not isAuthed(userid):
        es.tell(userid, '#green', 'You are not authorised to run the \'rpg_addcredit\' command!')
        return
        
    userid = es.getuserid(steamid)
    length = es.getargc()
    if es.getargc() > 3:
        reason = ' '.join(es.getargs().split()[3:])
    if str(amount).isdigit():
        players.increment({'Credits': int(amount)}, steamid)
        if userid:
            tokens = {'adminname' : es.getplayername(es.getcmduserid()), 'name':es.getplayername(userid),'creditsgave':amount,'prefix':es.ServerVar('srpg_Prefix'),'reason':reason}
            for userid in es.getUseridList():
                es.tell(userid,'#multi',text('admin gave credits',tokens,playerlib.getPlayer(userid).get('lang')))

def SendSkillsMenuFromPopup(userid, choice, popupid):
    """
    This menu Creates a new Skills popup for the user
    """
    CreateSkillMenu(userid,ReturnSteam(userid))
    skillmenu = 'skill_%s'%userid
    popuplib.send(skillmenu,userid)
    
def SendSellMenuFromPopup(userid, choice, popupid):
    """
    This menu creates a new unique sell popup for the player
    """
    CreateSellMenu(userid, ReturnSteam(userid) )
    sellmenu = 'sell_%s' % userid
    popuplib.send(sellmenu, userid)
    
def SendRank(steamid,name):
    """
    Sorted the dict out by level, then returns the index of the user.
    """
    database     = players.sort()
    position     = database.index(steamid) + 1
    totalranked  = len(database)
    
    xp, level, credits = players.query(('Xp', 'Level', 'Credits'), steamid)
    
    nextlevelxp = (level - 1) * int(es.ServerVar('srpg_XpIncrement')) + int(es.ServerVar('srpg_StartXP'))
    tokens = {'prefix' : es.ServerVar('srpg_Prefix'), 'name' : name, 'level' : level, 'rank' : position, 'total' : totalranked, 'xp' : xp, 'nextxp' : nextlevelxp, 'credits' : credits}
    for player in es.getUseridList():
        es.tell(player, '#multi', text('rank', tokens, playerlib.getPlayer(player).get('lang') ) )
    
def BuildStatsMenu(userid, choice, popupid):
    """
    Builds a custom stats menu for the user
    """
    steamid     = ReturnSteam(userid)
    database    = players.sort(10)
    position    = database.index(steamid) + 1
    total       = len(database)
    nextlevelxp = (players.query('Level', steamid) - 1) * int(es.ServerVar('srpg_XpIncrement')) + int(es.ServerVar('srpg_StartXP'))
    statsmenu   = popuplib.create('stats_%s' % userid)
    a           = statsmenu.addline
    a('=== SourceRPG Stats ===')
    a('-------------')
    a('Total Time: %.2f hours\n \nLevel: %s\nXP: %s/%s' % (players.query( ('TotalTime', 'Level', 'Xp'), steamid ) + (nextlevelxp,) ) )
    a('XP Needed to Level: %s' % (nextlevelxp - players.query('Xp', steamid) ) )
    a('Rank: %s/%s' % (position, total) )
    a(' ')
    a('-------------')
    a('9. Skill Stats')
    a('0. Back')
    statsmenu.select(9, SendSkillStats)
    statsmenu.submenu(10, 'rpgmenu')
    statsmenu.send(userid)
    
def SendSkillStats(userid, choice, popupid):
    """
    This will get the levels of the users stats, and add them
    to a popup to display all the skills
    """
    skillsMenu = popuplib.create('s_%s'%userid)
    steamid    = ReturnSteam(userid)
    skillsMenu.addline("""\
=== SourceRPG Skills ===
Credits: %s
-------------
Health+ - %s
Regeneration - %s
Regenerate Ammo - %s
Napalm Grenade - %s
Vampire - %s
Stealth - %s
Long Jump - %s
Ice Stab - %s
Frost Pistol - %s
Stun Grenade - %s
Smog Grenade - %s
Speed+ - %s
Gravity- - %s
Disable - %s
Recover Weapons - %s
Regenerate Armor - %s
Adrenaline - %s
Medic - %s            
-------------
0. Back""" % players.query(('Credits', 'Health', 'Regen', 'RegenAmmo', 'NapalmNade', 'Vampire', 'Stealth',
                                               'LongJump', 'IceStab', 'FrostPistol', 'StunNade', 'SmogNade', 'Speed',
                                               'Gravity', 'Disable', 'RecoverWeapons', 'RegenArmor', 'Adrenaline', 'Medic'), steamid) )
    skillsMenu.select(10,BuildStatsMenu)
    skillsMenu.send(userid)

def ResetSkills(userid = None, choice = None, popupid = None):
    '''This resets all the players skills and allows them to restart
    a fresh game.'''
    steamid = getSteamId(userid)
    if steamid is not None:
        players.execute("DELETE FROM players WHERE Steamid='" + steamid + "'")
        userid = es.getuserid(steamid)
        if es.exists('userid', userid):
            tokens = {'prefix': es.ServerVar('srpg_Prefix')}
            es.tell(userid, '#multi', text('info deleted', tokens, playerlib.getPlayer(userid).get('lang') ) )
            es.server.queuecmd('damage %s %s' % (userid, es.getplayerprop(userid, 'CBasePlayer.m_iHealth') ) )
            gamethread.delayed(0.1, Command(userid).ResetDict)
            gamethread.delayed(0.2, Command(userid).SetGravity, 1.0)
            gamethread.delayed(0.2, Command(userid).Color)
            players.addPlayer(steamid)
    
def isOnline(player):
    """ Returns True/False depnding on whether the player is currently online or not """
    return bool(es.getuserid(player))
    
def getSteamId(player):
    """ Return the steamid of the player despite the type and target I give it """
    steamid = None
    if str(player).isdigit():
        """ Okay, we were passed an integer, or a players userid; convert to steam """
        if es.exists('userid', player):
            steamid = playerlib.uniqueid(player, True)
    elif str(player).startswith(('STEAM_', 'BOT_')):
        """ We were passed a steamid, so do nothing; just check if the steamid is in the admin list """
        steamid = player
    else:
        """ Okay, we were either passed a name or something else... Check for userid via es.getuserid()"""
        tempUserid = es.getuserid(player)
        if es.exists('userid', tempUserid):
            steamid = playerlib.uniqueid(tempUserid, True)
    return steamid
    
def DeleteDatabase(userid=None, choice=None, popupid=None):
    '''This will delete all the people in the database, and reset
    all the players starts then restart the game'''
    if isAuthed(userid) or not userid:
        tokens = {}
        tokens['prefix'] = str(es.ServerVar('srpg_Prefix'))
        if userid:
            tokens['admin'] = es.getplayername(userid)
        else:
            tokens['admin'] = 'Server'
        for player in playerlib.getPlayerList('#all'):
            es.sexec(int(player),'kill')
            es.tell(int(player), '#multi', text('deleteing database', tokens, player.get('lang')))
        players.delete()
        for player in es.getUseridList():
            steamid = ReturnSteam(a)
            players.addPlayer(steamid)
            Command(userid).SetGravity(1.0)
            popuplib.send('helpmenu',a)
            players.update({'LastConnected' : datetime.date.today(), 'Name' : es.getplayername(player) }, steamid)
        es.server.queuecmd('mp_restartgame 1')
    
def debugMsg(level, text, addToFile=True, writeTime=True):
    """ This method prints text to the console, and if addToFile is true, it will
        open a log file and append the log and time to it. """
    if level <= int(es.ServerVar('srpg_DebugMode')):
        print text
        if addToFile:
            strfile = es.getAddonPath('sourcerpg') + '/debug/debuglog.txt'
            if not os.path.isfile(strfile):
                myfile = open(strfile, 'w')
            else:
                myfile = open(strfile, 'a')
            if writeTime:
                myfile.writelines(time.strftime('%A %m %Y - %H:%M:%S') + " - " + text + "\n")
            else:
                myfile.writelines(text + "\n")
            myfile.close()
    
def ReturnSteam(userid):
    '''This returns the steam of a player using uniqueid'''
    if es.exists('userid',userid):
        return playerlib.uniqueid(userid, True)
    return None
		
def ReturnLevel(userid, level):
    '''This returns the level of a player'''
    steamid = ReturnSteam(userid)
    if not steamid: 
        return None
    if steamid in players:
        if (steamid, 'Level') in players:
            return players.query('Level', steamid)
    
"""
The following Conversion tool was made by the excellent JoeyT2008
(Jordan Thomas). He is an excellent coder, and I take no credit
for this!
"""
    
class ReadSql:
    "Class to read the SQL Database from cssrpg.db"
    def __init__(self, db):
        self.db = db
        if not os.path.exists(db):
            return None
        self.connection = None
        
    def open(self):
        """
        Open the connection of the database with SQLite
        """
        self.connection = sqlite.connect(self.db)
        self.connection.text_factory = str
        self.cursor = self.connection.cursor()
        
    def close(self):
        """
        Close the connection of the database with SQLite
        """
        self.connection.close()
        self.connection = None
        self.cursor = None
        
    def readItems(self):
        """
        Read all items (skills) from the SQL Database
        """
        query = self.cursor.execute("SELECT * FROM items")
        return query.fetchall()
        
    def readPlayers(self):
        """
        Read a specific player's stats, including levels,
        xp annd credits etc.
        """
        query = self.cursor.execute("SELECT * FROM players")
        return query.fetchall()
    
def convertEntries(db):
    """
    This method converts all of the cssrpg's Database items over to the cPickle
    syntax, and all of SourceRPG's variable names.
    """
    rpgPlayers = {}
    itemID     = {}
    rpgName    = {0: "Speed", 1: "Gravity", 2: "StunNade", 3: "SmogNade", 4: "Disable", 5: "TotalTime"}
    f          = ReadSql(db)
    f.open()
    cssrpg     = f.readPlayers()
    items      = f.readItems()
    f.close()
    for x in range(len(cssrpg)):
        steamid = str(cssrpg[x][2])
        if steamid == "BOT":
            steamid = "BOT_%s"%(cssrpg[x][1])
        rpgPlayers[steamid] = {}
        rpgPlayers[steamid]["Name"]    = cssrpg[x][1]
        rpgPlayers[steamid]["Level"]   = cssrpg[x][3]
        rpgPlayers[steamid]["Xp"]      = cssrpg[x][4]
        rpgPlayers[steamid]["Credits"] = cssrpg[x][5]
            
        itemID[players[x][8]] = steamid
    for x in range(len(items)):
        try:
            if items[x][0] in itemID:
                steamid = itemID[items[x][0]]
                rpgPlayers[steamid]["Regen"]          = items[x][1]
                rpgPlayers[steamid]["Health"]         = items[x][2]
                rpgPlayers[steamid]["RegenAmmo"]      = items[x][3]
                rpgPlayers[steamid]["Vampire"]        = items[x][4]
                rpgPlayers[steamid]["Stealth"]        = items[x][5]
                rpgPlayers[steamid]["LongJump"]       = items[x][6]
                rpgPlayers[steamid]["NapalmNade"]     = items[x][7]
                rpgPlayers[steamid]["IceStab"]        = items[x][8]
                rpgPlayers[steamid]["FrostPistol"]    = items[x][9]
                rpgPlayers[steamid]["Adrenaline"]     = items[x][10]
                rpgPlayers[steamid]["RecoverWeapons"] = items[x][11]
                rpgPlayers[steamid]["Medic"]          = items[x][12]
        except IndexError:
            pass
    for x in rpgPlayers:
        if len(rpgPlayers[x]) == 16:
            for i in range(6):
                rpgPlayers[x][rpgName[i]] = 0
    return rpgPlayers
    
def writeEntries(str_path):
    """
    This loops through the SQL Converted DB (which is now a dictionary),
    and checks it against the players.db... If the SteamID's are different,
    then that SteamID is appended to player.db, then at the end, remove the
    cssrpg.db, and write the players.db to disk
    """
    entries = convertEntries(str_path)
    minus   = 0
    errors  = 0
    for steamid in entries:
        if (steamid in players and int(es.ServerVar('srpg_ConverterOverwrite') ) ) or steamid not in players:
            try:
                if steamid in players:
                    players.execute("DELETE FROM players WHERE Steamid='" + steamid +"'")
                players.addPlayer(steamid)
                players.update(entries[steamid], steamid)
            except sqlite3.OperationalError:
                debugMsg(0, 'SourceRPG: Conversion error converting %s' % steamid)
                errors += 1
        else:
            minus += 1
                
    total = (len(entries) - minus - errors)
    
    move(str_path, es.getAddonPath('sourcerpg') + '/backup')
        
    saveDatabase()
        
    debugMsg(0,"SourceRPG: Converted and inserted %d entries!" % total)
    debugMsg(0, 'SourceRPG: Converted with %s errors' % errors)
    debugMsg(0,"SourceRPG: Conversion tool made by JoeyT2008")
    
    
def convertOldDictionary(strPath):
    import cPickle
    if os.path.isfile(strPath):
        fileUsers = open(strPath)
        database  = cPickle.load(fileUsers)
        fileUsers.close()
        
        minus  = 0
        errors = 0
        for steamid in database:
            if steamid not in players or steamid in players and int(es.ServerVar('srpg_ConverterOverwrite') ):
                try:
                    if steamid in players:
                        players.execute("DELETE FROM players WHERE Steamid='" + steamid +"'")
                    players.addPlayer(steamid)
                    players.update(database[steamid], steamid)
                except sqlite3.OperationalError:
                    debugMsg(0, 'SourceRPG: Conversion error converting %s' % steamid)
                    errors += 1
            else:
                minus += 1
                
        move(strPath, es.getAddonPath('sourcerpg') + '/backup')
        debugMsg(0,"SourceRPG: Converted and inserted %d entries!" % (len(database) - minus - errors) )
        debugMsg(0, 'SourceRPG: Converted with %s errors' % errors)
        players.saveDatabase()
                
def checkXa():
    global isXa
    isXa = False
    if filter(lambda module_x: module_x.__name__[0:module_x.__name__.rfind('.')].replace('.', '/') == 'xa', es.addons.getAddonList() ):
        isXa = True
    if isXa:
        global xa
        from xa import xa
        languages = {}
        for language in ['en', 'de', 'default', 'fr']:
            languages[language] =  "SourceRPG Admin Menu"
        xa.Admin_module("sourcerpg").addMenu('srpg_mainAdminMenu', languages, "srpg_mainAdminMenu", "rpg_admin", "#admin")
    
def SaveDatabase():
    debugMsg(1,'\n***********************', writeTime=False)
    turboMode = bool(int ( es.ServerVar('srpg_turboMode') ) )
    debugMsg(1,'SourceRPG: Saving Database\nTurbo Mode: %s' % turboMode)
    if not turboMode:
        players.saveDatabase()
        if es.ServerVar('srpg_DatabaseSaveType') == "intervals":
            gamethread.delayedname(int(es.ServerVar('srpg_DatabaseIntervalLength')), 'save_interval', SaveDatabase)
        debugMsg(1,'SourceRPG: Database Saved!')
    else:
        debugMsg(1,'SourceRPG: Database not saving as turbo mode is on.')
    debugMsg(1,'***********************\n', writeTime=False)
    
def SendPopupMethods(userid, choice, popupid):
    steamid = es.ServerVar('srpg_steamid')
    if choice == 1:
        ResetSkills(steamid, None, None)
    elif choice == 2:
        CreateXpInputBox(userid, steamid, None)
    elif choice == 3:
        CreateLevelInputBox(userid, steamid, None)
    elif choice == 4:
        CreateCreditInputBox(userid, steamid, None)
         
command_instances = {}
def Command(userid):
    userid = str(userid)
    if not userid in command_instances:
        command_instances[userid] = Command_Manager(userid)
    return command_instances[userid]
    
command_dict = {}
class Command_Manager:
    "Class for all the commands"
    
    def __init__(self, userid):
        '''
        This runs whenever Command(userid) is called.
        It initializes the class, and sets up the dict
        options for the user
        '''
        
        self.userid  = int(userid)
        if es.exists('userid', self.userid):
            self.steamid = ReturnSteam(self.userid)
            if not command_dict.has_key(self.userid) and self.steamid is not None:
                command_dict[self.userid] = {}
                self.key = command_dict[self.userid]
                if self.steamid in players:
                    self.key['MaxHealth']      = players.query('Health', self.steamid) * int(es.ServerVar('srpg_HealthIncrement')) + 100
                    self.key['MaxSpeed']       = (1 + ( ( (float(es.ServerVar('srpg_SpeedMaxMovementSpeed') ) - 1) / float(es.ServerVar('srpg_SpeedMax') ) ) * players.query('Speed', self.steamid) ) )
                    self.key['MaxGrav']        = 1 - ( ( (1.0 / (int(es.ServerVar('srpg_GravityMax') ) ) ) - (float(es.ServerVar('srpg_GravityMinGravity') ) / int(es.ServerVar('srpg_GravityMax') ) ) ) * players.query('Gravity', self.steamid) )
                    self.key['MinAlpha']       =  255 - round( ( (255/(int(es.ServerVar('srpg_StealthMax') ) + 1) ) ) * players.query('Stealth', self.steamid) )
                else:
                    self.key['MaxHealth']      = 100
                    self.key['MaxSpeed']       = 1
                    self.key['MaxGrav']        = 1
                    self.key['MinAlpha']       = 255
                self.key['AlreadyAdrenalined'] = 0
                self.key['Frozen']             = 0
                self.key['Slowed']             = 0
                self.key['Weighed']            = 0
                self.key['RegenLoop']          = 0
                self.key['RegenAmmoLoop']      = 0
                self.key['RegenArmorLoop']     = 0
                
                debugMsg(2,'\nPlayers Dictionary Items:\n--------------------------------\n')
                for a in self.key:
                    debugMsg(2,'%s - %s'%(a, self.key[a]), writeTime=False)
                debugMsg(2,'--------------------------------\n', writeTime=False)
                
            self.key = command_dict[self.userid]
            
    def ResetDict(self):
        '''
        This resets all the players dictionary items
        back to default settings
        '''
        if es.exists('userid', self.userid):
            gamethread.cancelDelayed('resetDict%s' % self.userid)
            if self.steamid and self.steamid in players:
                self.key['MaxHealth']      = players.query('Health', self.steamid) * int(es.ServerVar('srpg_HealthIncrement')) + 100
                self.key['MaxSpeed']       = (1 + ( ( (float(es.ServerVar('srpg_SpeedMaxMovementSpeed') ) - 1) / float(es.ServerVar('srpg_SpeedMax') ) ) * players.query('Speed', self.steamid) ) )
                self.key['MaxGrav']        = 1 - ( ( (1.0 / (int(es.ServerVar('srpg_GravityMax') ) ) ) - (float(es.ServerVar('srpg_GravityMinGravity') ) / int(es.ServerVar('srpg_GravityMax') ) ) ) * players.query('Gravity', self.steamid) )
                self.key['MinAlpha']       =  255 - round( ( (255/(int(es.ServerVar('srpg_StealthMax') ) + 1) ) ) * players.query('Stealth', self.steamid) )
            else:
                self.key['MaxHealth'] = 100
                self.key['MaxSpeed']  = 1
                self.key['MaxGrav']   = 1
                self.key['MinAlpha']  = 255
            self.key['AlreadyAdrenalined'] = 0
            self.key['Frozen']         = 0
            self.key['Slowed']         = 0
            self.key['Weighed']        = 0
            self.key['RegenLoop']      = 0
            self.key['RegenAmmoLoop']  = 0
            self.key['RegenArmorLoop'] = 0
    
    def __getitem__(self, key):
        if self.userid:
            if key in self.key:
                return self.key[key]
    
    def __setitem__(self, key, value):
        if self.userid:
            self.key[key] = value
    
    def UpdateDict(self, key, amount):
        '''
        This command updates a players dictionary item
        to a new value
        '''
        if es.exists('userid', self.userid):
            self.key[key] = amount
        
    def ModDict(self, key, amount):
        '''
        This command modifies an existing value for an item
        in a players dictionary
        '''
        if es.exists('userid', self.userid):
            if self.key.has_key(key):
                self.key[key] += amount
            else:
                self.key[key] = amount
            
    def ResetRecover(self):
        '''
        Resets the Recover Items keys inside the players dictionary
        This is so that you do not rejoin with the same weapons.
        '''
        if es.exists('userid', self.userid):
            self.UpdateDict('RecoverActive', 0)
            self.UpdateDict('RecoverVest', 0)
            self.UpdateDict('RecoverNvgs', 0)
            self.UpdateDict('RecoverVestHelm', 0)
            self.UpdateDict('RecoverHe', 0)
            self.UpdateDict('RecoverSmoke', 0)
            self.UpdateDict('RecoverFlashbang', 0)
            self.UpdateDict('RecoverSecondary', 0)
            self.UpdateDict('RecoverPrimary', 0)
            
    def ReturnDict(self, key):
        '''
        This will return the value of the key inside the players
        dict
        '''
        if es.exists('userid', self.userid):
            if self.key.has_key(key):
                return self.key[key]
            return None
        
    def Color(self, r = 255, g = 255, b = 255, a = None, time=None):
        '''
        This will change a players color, and can change the alpha.
        After X seconds it will change a players color back if 
        that argument is given.
        '''
        if es.exists('userid', self.userid):
            if not a:
                a = int(self.ReturnDict('MinAlpha'))
            
            color = r
            color += g << 8
            color += b << 16
            color += a << 24
            if color >= 2**31: 
                color -= 2**32
            oldRenderMode = es.getplayerprop(self.userid, "CBaseEntity.m_nRenderMode")
            oldRenderFX   = es.getplayerprop(self.userid, "CBaseEntity.m_nRenderFX")
            newRenderMode = oldRenderMode | 1
            newRenderFX   = oldRenderFX | 256
            es.setplayerprop(self.userid, "CBaseEntity.m_nRenderMode", newRenderMode)
            es.setplayerprop(self.userid, "CBaseEntity.m_nRenderFX", newRenderFX)
            es.setplayerprop(self.userid, "CBaseEntity.m_clrRender", color)
            for entity in es.createentitylist(playerlib.getPlayer(self.userid).get("weapon")):
                if es.getplayerhandle(self.userid) == es.getindexprop(entity, 'CBaseEntity.m_hOwnerEntity'):
                    oldRenderMode = es.getindexprop(entity, "CBaseEntity.m_nRenderMode")
                    oldRenderFX = es.getindexprop(entity, "CBaseEntity.m_nRenderFX")
                    newRenderMode = oldRenderMode | 1
                    newRenderFX = oldRenderFX | 256
                    es.setindexprop(entity, "CBaseEntity.m_nRenderMode", newRenderMode)
                    es.setindexprop(entity, "CBaseEntity.m_nRenderFX", newRenderFX)
                    es.setindexprop(entity, "CBaseEntity.m_clrRender", color)
                    break
            
            if time is not None:
                gamethread.delayedname(time, 'resetDict%s' % self.userid, self.Color, kw = {'a' : a})
            
    def Heal(self, amount):
        '''
        Heals a players health... If there health is full, then check their
        armor.
        '''
        if es.exists('userid', self.userid):
            health = int(es.getplayerprop(self.userid, 'CBasePlayer.m_iHealth'))
            mhealth = self.ReturnDict('MaxHealth')
            if health + amount <= mhealth:
                if health + amount:
                    es.setplayerprop(self.userid, 'CBasePlayer.m_iHealth', health + amount)
                else:
                    es.sexec(self.userid, 'kill')
            else:
                if es.getgame() == "Counter-Strike: Source":
                    es.setplayerprop(self.userid, 'CBasePlayer.m_iHealth', mhealth)
                    amount -= (mhealth - health)
                    armor = int(es.getplayerprop(self.userid, 'CCSPlayer.m_ArmorValue'))
                    armor += amount
                    if armor <= mhealth:
                        es.setplayerprop(self.userid, 'CCSPlayer.m_ArmorValue', armor)
                    else:
                        es.setplayerprop(self.userid, 'CCSPlayer.m_ArmorValue', mhealth)
                else: 
                    es.setplayerprop(self.userid, 'CBasePlayer.m_iHealth', mhealth)
        
    def HealthAdd(self, amount):
        '''
        Adds a value to the current value of the players health
        '''
        if es.exists('userid', self.userid):
            health = int(es.getplayerprop(self.userid,'CBasePlayer.m_iHealth'))
            health += amount
            if health > 0:
                self.key['MaxHealth'] += amount
                es.setplayerprop(self.userid,'CBasePlayer.m_iHealth',health)
        
    def Health(self, amount):
        '''
        Sets a new value to the players maximum health
        '''
        if es.exists('userid', self.userid):
            self.key['MaxHealth'] = amount
            es.setplayerprop(self.userid,'CBasePlayer.m_iHealth',amount)
        
    def SpeedAdd(self, amount):
        '''
        Adds an amount to the current value for the players speed
        '''
        if es.exists('userid', self.userid):
            speed = self.ReturnDict('MaxSpeed')
            speed += amount
            debugMsg(1, 'Changing player %s\'s speed from %s to %s'%(es.getplayername(self.userid), speed - amount , speed))
            if speed < 0:
                speed = 0 
            self.UpdateDict('MaxSpeed', speed)
            es.setplayerprop(self.userid, 'CBasePlayer.localdata.m_flLaggedMovementValue', speed)
        
    def Speed(self, amount):
        '''
        Sets a new value to the players current speed
        '''
        if es.exists('userid', self.userid):
            debugMsg(1, 'Changin player %s\'s speed to %s'%(es.getplayername(self.userid), amount) )
            self.UpdateDict('MaxSpeed', amount)
            es.setplayerprop(self.userid, 'CBasePlayer.localdata.m_flLaggedMovementValue', amount)
        
    def Slow(self, amount, time):
        '''
        Slow down a player by X amount for X seconds
        '''
        if es.exists('userid', self.userid):
            debugMsg(2, 'Testing for the slow command')
            if not self.ReturnDict('Slowed'):
                self.UpdateDict('Slowed', 1)
                self.SpeedAdd(amount * -1)
                gamethread.delayedname(time, 'resetDict%s' % self.userid, self.SpeedAdd, amount)
                gamethread.delayedname(time, 'resetDict%s' % self.userid, self.UpdateDict, ('Slowed', 0) )
            
    def SetGravity(self, amount):
        '''
        Set a new value for the players Gravity
        '''
        if es.exists('userid', self.userid):
            self.key['MaxGrav'] = amount
            if amount == 1.0:
                removeGravity(self.userid)
            else:
                addGravity(self.userid, amount)
        
    def ChangeGravity(self, amount):
        '''
        Add a certain amount to the players gravity
        '''
        if es.exists('userid', self.userid):
            gravity = self.ReturnDict('MaxGrav')
            gravity += amount
            if gravity < 0: 
                gravity = 0
            
            if gravity == 1.0:
                removeGravity(self.userid)
            else:
                addGravity(self.userid, gravity)
            self.key['MaxGrav'] = gravity
        
    def WeighDown(self, amount, time):
        '''
        Add a certain amount of gravity to the player for 
        x seconds
        '''
        if es.exists('userid', self.userid):
            if not self.ReturnKey('Weighed'):
                self.key['Weighed'] = 1
                gravity = self.ReturnDict('MaxGrav')
                gravity += amount
                self.key['MaxGrav'] = gravity
                self.SetGravity(gravity)
                gravity += amount
                gamethread.delayedname(time, 'resetDict%s' % self.userid, self.UpdateDict, ('MaxGrav', gravity))
                gamethread.delayedname(time, 'resetDict%s' % self.userid, self.SetGravity, gravity)
                gamethread.delayedname(time, 'resetDict%s' % self.userid, self.UpdateDict, ('Weighed', 0) )
            
    def Shake(self,time,violence):
        """ Shakes the players screen """
        if es.exists('userid', self.userid):
            if not self.IsDead():
                if isEst:
                    es.server.queuecmd('est_Shake %s %s %s %s'%(self.userid, time, violence, violence))
                else:
                    es.usermsg('create', 'shake', 'Shake')
                    es.usermsg('write', 'byte',  'shake', 0)
                    es.usermsg('write', 'float', 'shake', violence)
                    es.usermsg('write', 'float', 'shake', 1.0)
                    es.usermsg('write', 'float', 'shake', time)
                    es.usermsg('send', 'shake', self.userid)
                    es.usermsg('delete', 'shake')
            
    def Freeze(self, time):
        '''
        Freeze a player for X seconds
        '''
        if es.exists('userid', self.userid):
            player = playerlib.getPlayer(self.userid)
            player.set("freeze", 1)
            es.emitsound('player', self.userid, 'physics/glass/glass_impact_bullet%s.wav'%random.randint(1,4), '1.0', '0.5')
            gamethread.delayedname(time, 'resetDict%s' % self.userid, player.set, ("freeze", 0))
        
    def IsDead(self):
        '''
        Returns if the player is dead or not
        '''
        if es.exists('userid', self.userid):
            return es.getplayerprop(self.userid, 'CBasePlayer.pl.deadflag')
        
    def Regen(self):
        '''
        Begins the regeneration loop for a player
        '''
        if es.exists('userid', self.userid):
            if not self.ReturnDict('RegenLoop'):
                self.UpdateDict('RegenLoop', 1)
                gamethread.delayedname(int(es.ServerVar('srpg_RegenDelay')), 'resetDict%s' % self.userid, self.RegenLoop)

    def RegenArmor(self):
        """
        Begins the regen armor loop for a player
        """
        if es.exists('userid', self.userid):
            if not self.ReturnDict('RegenArmorLoop'):
                self.UpdateDict('RegenArmorLoop', 1)
                gamethread.delayedname(int(es.ServerVar('srpg_RegenArmorDelay')), 'resetDict%s' % self.userid, self.RegenArmorLoop)
        
    def RegenAmmo(self):
        """
        Begins the regen ammo loop for a player
        """
        if es.exists('userid', self.userid):
            if not self.ReturnDict('RegenAmmoLoop'):
                self.UpdateDict('RegenAmmoLoop', 1)
                gamethread.delayedname(int(es.ServerVar('srpg_RegenArmorDelay')), 'resetDict%s' % self.userid, self.RegenAmmoLoop)
            
    def MedicLoop(self):
        """
        Creates a loop to run the Medic skill.
        Runs the AreaRegen loop
        """
        if es.exists('userid', self.userid):
            if es.exists('userid', self.userid):
                level = players.query('Medic', self.steamid)
                if level and int(es.ServerVar('srpg_Medic')) and not es.getplayerprop(self.userid, 'CBasePlayer.pl.deadflag'):
                    amount = level * int(es.ServerVar('srpg_MedicHealingIncrement'))
                    size = (level - 1) * int(es.ServerVar('srpg_MedicDistanceIncrement')) + int(es.ServerVar('srpg_MedicMinDistance'))
                    self.AreaRegen(size, amount, '#ct' if int(es.getplayerteam(self.userid)) == 3 else '#t')
                    gamethread.delayedname(int(es.ServerVar('srpg_MedicDelay')), 'medic_%s' % self.userid, self.MedicLoop)
            
    def RegenLoop(self):
        """
        Will create a loop to check if the user
        has a regen active... If it does, return
        the current health, plus the level of the
        regen level, then check if it's more than
        the max level. If so, set the health to 
        his max health, then stop the regen.
        """
        if es.exists('userid', self.userid):
            if es.exists('userid',self.userid):
                ramount = players.query('Regen', self.steamid)
                if ramount and self.ReturnDict('RegenLoop'):
                    health = int(es.getplayerprop(self.userid,'CBasePlayer.m_iHealth'))
                    health += ramount
                    maxhealth = self.ReturnDict('MaxHealth')
                    if health < maxhealth:
                        es.setplayerprop(self.userid,'CBasePlayer.m_iHealth',health)
                        gamethread.delayedname(int(es.ServerVar('srpg_RegenDelay')), 'resetDict%s' % self.userid, self.RegenLoop)
                    else:
                        es.setplayerprop(self.userid,'CBasePlayer.m_iHealth', maxhealth)
                        self.UpdateDict('RegenLoop',0)
                
    def RegenAmmoLoop(self):
        """
        Creates a loop to retrieve the active weapon of the user
        and compare it against the default ammo variables taken
        from the server.cfg. 
        """
        if es.exists('userid',self.userid):
            steamid = ReturnSteam(self.userid)
            ramount = players.query('RegenAmmo', self.steamid)
            if ramount and self.ReturnDict('RegenAmmoLoop'):   
                userid = playerlib.getPlayer(self.userid)
                gun = userid.attributes['weapon']
                if gun: gun = gun.replace("weapon_","")
                if gun in pistols:  
                    ammo = userid.get('ammo','secondary')
                    ammo += ramount
                    if ammo <= pistols[gun]:
                        userid.set('ammo',['secondary',ammo])
                        gamethread.delayedname(int(es.ServerVar('srpg_RegenAmmoDelay')), 'resetDict%s' % self.userid, self.RegenAmmoLoop)
                        return
                    else:
                        userid.set('ammo',['secondary',pistols[gun]])
                        self.UpdateDict('RegenAmmoLoop',0)
                elif gun in rifles:
                    ammo = userid.get('ammo','primary')
                    ammo += ramount
                    if ammo <= rifles[gun]:
                        userid.set('ammo',['primary',ammo])
                        gamethread.delayedname(int(es.ServerVar('srpg_RegenAmmoDelay')), 'resetDict%s' % self.userid, self.RegenAmmoLoop)
                        return
                    else:
                        userid.set('ammo',['primary',rifles[gun]])
                        self.UpdateDict('RegenAmmoLoop',0)
                        
    def RegenArmorLoop(self):
        """
        Create a repeat loop to restore the users armor. Retrieves the armor level,
        then compares it against the maximum health, then does the check to see if they
        are past that, if so, set it to maximum, else repeat the loop.
        """
        if es.exists('userid', self.userid):
            if es.exists('userid',self.userid) and int(es.ServerVar('srpg_RegenAmmo')):
                ramount = players.query('RegenArmor', self.steamid)
                if ramount and self.ReturnDict('RegenArmorLoop'):   
                    armor = int(es.getplayerprop(self.userid,'CCSPlayer.m_ArmorValue'))
                    armor += ramount
                    maxarmor = self.ReturnDict('MaxHealth')
                    if armor <= maxarmor:
                        es.setplayerprop(self.userid,'CCSPlayer.m_ArmorValue',armor)
                        gamethread.delayedname(int(es.ServerVar('srpg_RegenArmorDelay')), 'resetDict%s' % self.userid, self.RegenArmorLoop)
                    else:
                        es.setplayerprop(self.userid,'CCSPlayer.m_ArmorValue',maxarmor)
                        self.UpdateDict('RegenArmorLoop',0)
                    
    def AreaRegen(self, area, amount, filt='#all'):
        """
        Regenerates an area... THe filter is the playerlib filter
        to test for playes within the area. Do a symple pythag
        distance check, then Heal all players inside that area.
        """
        if es.exists('userid', self.userid):
            if not es.getplayerprop(self.userid, 'CBasePlayer.pl.deadflag'):
                x,y,z = es.getplayerlocation(self.userid)
                for player in playerlib.getUseridList(filt):
                    effect = 0
                    if player != self.userid:
                        xx,yy,zz = es.getplayerlocation(player)
                        distance = ((x - xx) ** 2 + (y - yy) ** 2 + (z - zz) ** 2 ) ** 0.5
                        if distance <= area:
                            effect = 1
                            Command(player).Heal(amount)
                    if effect and int(es.ServerVar('srpg_MedicEffects')):
                        x,y,z = es.getplayerlocation(self.userid)
                        if isEst:
                            es.server.queuecmd('est_effect 10 %s 0 "sprites/lgtning.vmt" %s %s %s %s 20 0.2 10 10 0 0 255 0 255 30'%(filt.replace('ct','c'),x,y,z, area))
                            es.server.queuecmd('est_effect 10 %s 0.2 "sprites/lgtning.vmt" %s %s %s %s 20 0.2 10 10 0 0 255 0 255 30'%(filt.replace('ct','c'),x,y,z, area))
  
class gravityManager(object):
    """ Class to manager the tick listener, and to manage the players gravity """
    def __init__(self):
        """ Create 2 self. variables """
        self.gravityList = {}
       
    def addGravityChange(self, userid, amount):
        """ Check if there are already any players in the gravityChange list.
            If there isn't, start the tick listener. Following this, check
            if the userid is in the dictionary, if so, remove them. Then create
            a new instance. """
        userid = str(userid)
        if not len(self.gravityList):
            gamethread.delayedname(0.25, 'gravity_check', self._ticker)
        if self.gravityList.has_key(userid):
            self.removeGravityChange(userid)
        if es.exists('userid', userid):
            self.gravityList[userid] = {'lastairvalue': es.getplayerprop(userid, 'CBasePlayer.m_fFlags') & 1, 'gravity': amount, 'lastmovementvalue': es.getplayerprop(userid, 'CBaseEntity.movetype')}
        else:
            self.gravityList[userid] = {'lastairvalue': 0, 'gravity': amount, 'lastmovementvalue': 2}
        self._resetGravity(userid, amount)
       
    def removeGravityChange(self, userid):
        """ Check if the player is in the dictioanry. If so, reset their gravity to 1
            and delete their instance from the dictionary. If there are no more players
            within the gravityList, remove the tick listener """
        userid = str(userid)
        if self.gravityList.has_key(userid):
            del self.gravityList[userid]
        if isOb:
            es.fire(userid, '!self', 'addouput', "gravity 1.0", 0.1, 1)
        else:
            es.server.queuecmd('es_xfire %s !self addoutput "gravity %s" 0.1 1'%(userid, 1.0))
       
    def deleteGravityList(self):
        """ Loop through all the players, reset their gravity to 1, delete the gravity
            list then unregister the tick listener. """
        for player in self.gravityList:
            _resetGravity(player, 1.0)
        del self.gravityList
        gamethread.cancelDelayed('gravity_check')
       
    def _ticker(self):
        """ Here we loop through all of the players, and check their gravity etc. """
        for player in self.gravityList:
            try:
                if es.exists('userid', player):
                    newaval = es.getplayerprop(player, 'CBasePlayer.m_fFlags') & 1
                    newmval = es.getplayerprop(player, 'CBaseEntity.movetype')
                else:
                    newaval = 0
                    newmval = 2
                if self.gravityList[player]['lastairvalue'] <> newaval:
                    """ Player has jumped """
                    self._resetGravity(player, self.gravityList[player]['gravity'])

                elif self.gravityList[player]['lastmovementvalue'] <> newmval and newmval == 2:
                    """ Player has changed move type and is back to normal (I.E, just came off a ladder) """
                    self._resetGravity(player, self.gravityList[player]['gravity'])
                self.gravityList[player]['lastairvalue']      = newaval
                self.gravityList[player]['lastmovementvalue'] = newmval
            except:
                debugMsg(0, "Gravity Error: An Unkown error occured attempting to set %s's gravity" % player)
        gamethread.delayedname(0.25, 'gravity_check', self._ticker)

    def _resetGravity(self, userid, amount):
        """ Change the players gravity to value amount. """
        if isOb:
            es.fire(userid, '!self', 'addoutput', "gravity %s" % amount, 0.1, 1)
        else:
            es.server.queuecmd('es_xfire %s !self addoutput "gravity %s" 0.1 1'%(userid, amount))
       
gravity = gravityManager()

def addGravity(userid, amount):
    """ Add a new player to the gravity list """
    gravity.addGravityChange(userid, amount)
   
def removeGravity(userid):
    """ Remove a player from the gravity list """
    gravity.removeGravityChange(userid)
                
class SQLiteManager(object):
    connected = False
    
    def __init__(self, path):
        self.connected               = True
        self.connection              = sqlite.connect(path)
        self.connection.text_factory = str
        self.cursor                  = self.connection.cursor()
        self.cursor.execute("""CREATE TABLE IF NOT EXISTS players (Steamid TEXT PRIMARY KEY NOT NULL, Level INTEGER DEFAULT 1,  
                                                               Xp INTEGER DEFAULT 0, Credits INTEGER DEFAULT """ + 
                                                               str(es.ServerVar('srpg_StartCredits')) + """, Regen INTEGER DEFAULT 0,
                                                               Health INTEGER DEFAULT 0, RegenAmmo INTEGER DEFAULT 0, Stealth INTEGER
                                                               DEFAULT 0, Vampire INTEGER DEFAULT 0, NapalmNade INTEGER DEFAULT 0,
                                                               IceStab INTEGER DEFAULT 0, FrostPistol INTEGER DEFAULT 0, LongJump INTEGER
                                                               DEFAULT 0, Speed INTEGER DEFAULT 0, Gravity INTEGER DEFAULT 0, StunNade
                                                               INTEGER DEFAULT 0, SmogNade INTEGER DEFAULT 0, RecoverWeapons INTEGER DEFAULT
                                                               0, Disable INTEGER DEFAULT 0, TotalTime REAL DEFAULT 0.0, RegenArmor INTEGER
                                                               DEFAULT 0, Popup INTEGER DEFAULT """ + str(es.ServerVar('srpg_StartPopupStatus')) + 
                                                               """, Adrenaline INTEGER DEFAULT 0, Medic INTEGER DEFAULT 0, Name TEXT DEFAULT 
                                                               'Default', LastConnected TEXT DEFAULT '0') """)
        self.cursor.execute("PRAGMA journal_mode = OFF;")
                                                               
    def __contains__(self, key):
        if self.connected:
            if key is None:
                return None
            if type(key) in (tuple, list):
                try:
                    self.cursor.execute("SELECT " + key[1] + " FROM players WHERE Steamid='" + key[0] + "'")
                    return bool(self.cursor.fetchone() )
                except sqlite3.OperationalError:
                    return False
            else:
                self.cursor.execute("SELECT Level FROM players WHERE Steamid='" + key + "'")
            return bool(self.cursor.fetchone() )
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
            return False
        
    def __iter__(self):
        if self.connected:
            self.cursor.execute("SELECT Steamid FROM players")
            for steamid in self.cursor.fetchall():
                yield steamid[0]
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
        
    def __delitem__(self, steamid):
        if self.connected:
            if self.__contains__(steamid):
                self.cursor.execute("DELETE FROM players WHERE Steamid='" + steamid + "'")
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
            
    def __getitem__(self, steamid):
        if self.connected:
            if self.__contains__(steamid):
                values = {}
                for item in ['Level', 'Xp', 'Credits', 'Regen', 'Health', 'RegenAmmo', 'Stealth', 'Vampire', 'NapalmNade',
                             'IceStab', 'FrostPistol', 'LongJump', 'Speed', 'Gravity', 'StunNade', 'SmogNade', 'RecoverWeapons',
                             'Disable', 'TotalTime', 'RegenArmor', 'Popup', 'Adrenaline', 'Medic', 'Name', 'LastConnected']:
                             self.cursor.execute("SELECT " + item + " FROM players WHERE Steamid='" + steamid + "'")
                             values[item] = self.fetchone()
                return values
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
            return {}
            
    def __setitem__(self, steamid, value):
        if self.connected:
            if self.__contains__(steamid):
                self.update(value, steamid)
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
        
    def __len__(self):
        if self.connected:
            a = 0
            for i in self.__iter__():
                a += 1
            return a
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
            return 0
        
    def execute(self, command):
        if self.connected:
            self.cursor.execute(command)
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
        
    def update(self, keys, steamid):
        try:
            if self.connected:
                if isinstance(keys, dict):
                    try:
                        if not self.__contains__(steamid):
                            return
                        mystring = ""
                        for key in keys:
                            mystring += "%s='%s'," % (key, keys[key])
                        mystring = mystring[:-1]
                        self.cursor.execute("UPDATE players SET " + mystring + " WHERE Steamid='" + steamid + "'")
                    except sqlite3.OperationalError:
                        pass
            else:
                debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
        except:
            debugMsg(0, "ERROR: Error updating steamid %s and key %s" % (steamid, keys) )
        
    def increment(self, keys, steamid):
        if self.connected:
            if isinstance(keys, dict):
                if not self.__contains__(steamid):
                    return
                mystring = ""
                for key in keys:
                    myvalue   = self.query(key, steamid)
                    myvalue  += keys[key]
                    mystring += "%s='%s'," % (key, myvalue)
                mystring = mystring[:-1]
                self.cursor.execute("UPDATE players SET " + mystring + " WHERE Steamid='" + steamid + "'")
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
        
    def query(self, keys, steamid):
        if self.connected:
            returnValue = None
            if self.__contains__(steamid):
                if type(keys) in (tuple, list):
                    self.cursor.execute("SELECT " + ','.join(keys) + " FROM players WHERE Steamid='" + steamid + "'")
                    returnValue = self.cursor.fetchall()[0]
                elif isinstance(keys, str):
                    self.cursor.execute("SELECT " + keys + " FROM players WHERE Steamid='" + steamid + "'")
                    returnValue = self.cursor.fetchone()[0]
            else:
                debugMsg(0, "Error: Steamid %s does not exists in the SQLite datbase!" % steamid)
            if returnValue is None:
                debugMsg(0, "ERROR: SQL Locked! Closing connection and restarting server now!!!")
                for player in playerlib.getPlayerList('#all'):
                    es.tell(int(player), '#multi', text('server restart lock', {'prefix' : str(es.ServerVar('srpg_prefix') )}, player.get("lang") ) )
                self.close()
                es.server.queuecmd('mp_restartgame 1')
                return 0
            else:
                return returnValue
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
            return 0
                    
    def addPlayer(self, steamid):
        if self.connected:
            if not self.__contains__(steamid):
                if isinstance(steamid, str):
                    self.cursor.execute("INSERT INTO players (Steamid) VALUES ('" + steamid + "')")
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
            
    def sort(self, limit = None):
        if self.connected:
            if limit is not None:
                self.cursor.execute("SELECT Steamid FROM players ORDER BY Level DESC,Xp DESC LIMIT " + str(limit) )
            else:
                self.cursor.execute("SELECT Steamid FROM players ORDER BY Level DESC,Xp DESC")
            results       = self.cursor.fetchall()
            returnResults = []
            for steamid in results:
                returnResults.append(steamid[0])
            return returnResults
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
            return []
            
    def fetchall(self):
        if self.connected:
            trueValues = []
            for value in self.cursor.fetchall():
                if len(value) > 1:
                    trueValues.append(value)
                else:
                    trueValues.append(value[0])
            return trueValues
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
            return []
        
    def fetchone(self):
        if self.connected:
            return self.cursor.fetchone()[0]
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
            return 0
            
    def saveDatabase(self):
        if self.connected:
            if not turboMode:
                self.connection.commit()
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
        
    def clear(self):
        if self.connected:
            self.cursor.execute("DELETE FROM players")
            self.saveDatabase()
        else:
            debugMsg(1, "ERROR: SQLite Database not connected! Will not do any SQLite operations!")
        
    def close(self):
        if self.connected:
            self.cursor.close()
            self.connection.close()
            self.connected = False
        else:
            debugMsg(0, "ERROR: SQLite Database not connected! Cannot close the database if it's already closed!")
        
    def connect(self):
        if self.connected is not False:
            debugMsg(1, "ERROR: Cannot connect to database - connection is already open.")
            return
        debugMsg(1, "Connecting to the database again!")
        self.__init__(os.path.join (es.getAddonPath('sourcerpg'), 'players.sqldb' ) )
    
players = SQLiteManager( os.path.join (es.getAddonPath('sourcerpg'), 'players.sqldb' ) )
        
class ChatInputManager(object):    
    def __init__(self):
        es.addons.registerSayFilter(self.sayFilter)
        self.players = {}
    
    def addInput(self, player, function, time = 30, *args):
        if not self.players:
            es.addons.registerSayFilter(self.sayFilter)
        player = int(player)
        if player in self.players:
            self.removePlayer(player)
        self.players[player] = ChatInputPlayer(time, function, player, args)
        gamethread.delayedname(float(time), 'srpg_chatInput_user%s' % player, self.removePlayer, player)
        
    def removePlayer(self, userid):
        gamethread.cancelDelayed('srpg_chatInput_user%s' % userid)
        del self.players[int(userid)]
        if not self.players:
            es.addons.unregisterSayFilter(self.sayFilter)
        
    def sayFilter(self, userid, text, teamOnly):
        if userid in self.players:
            text = text.strip('"').strip()
            self.players[userid].runFunction(text)
            self.removePlayer(userid)
            return (0, "", 0)
        return userid, text,teamOnly

class ChatInputPlayer(ChatInputManager):
    def __init__(self, time, function, userid, args):
        self.function = function
        self.args     = args
        self.userid   = userid
        
    def runFunction(self, values):
        if callable(self.function):
            if self.args:
                self.function(self.userid, values, *self.args)
            else:
                self.function(self.userid, values)
    
chatInput = ChatInputManager()
    
#######################
#### END OF SCRIPT ####
#######################
