import es
import popuplib
import playerlib
import time

import sourcerpg
from sourcerpg import sourcerpg

text = sourcerpg.text

def load():
    adminMenu = popuplib.create('srpg_mainAdminMenu')
    adminMenu.addline('=== SourceRPG Admin ===')
    adminMenu.addline('-----------------------')
    adminMenu.addline('->1. Online Players')
    adminMenu.addline('->2. Offline Playes')
    adminMenu.addline('->3. Enable/Disable Skills')
    adminMenu.addline('->4. Delete Database')
    adminMenu.addline('-----------------------')
    adminMenu.addline('0. Cancel')
    
    adminMenu.submenu(1, 'srpg_onlineMenu')
    adminMenu.submenu(2, 'srpg_offlineMenu')
    adminMenu.select(3, sendToggleSkills)
    adminMenu.select(4, sendDeleteDatabase)
    adminMenu.select(10, sendMenu)
    
    iterIndex   = 1
    onlineMenuPopup  = popuplib.create('srpg_onlineMenu')
    offlineMenuPopup = popuplib.create('srpg_offlineMenu')
    onlineMenuPopup.addline('SourceRPG Admin Menu\nOnline Users\n%s' % ('-' * 25) )
    offlineMenuPopup.addline('SourceRPG Admin Menu\nOffline Users\n%s' % ('-' * 25) )
    for option in ['Give Levels', 'Give XP', 'Give Credits', 'Upgrade a player\'s skill', 'Downgrade a player\'s Skill', 'Reset a players information', 'See detailed stats', 'Max all player\'s Skills']: 
        onlineMenuPopup.addline('->%s. %s' % (iterIndex, option) )
        offlineMenuPopup.addline('->%s. %s' % (iterIndex, option) )
        iterIndex += 1
    onlineMenuPopup.addline('-' * 25)
    onlineMenuPopup.addline('0. Back')
    offlineMenuPopup.addline('-' * 25)
    offlineMenuPopup.addline('0. Back')
    onlineMenuPopup.menuselect  = onlineMenuMenuSelect
    offlineMenuPopup.menuselect = offlineMenuMenuSelect 
    
def sendMenu(userid, choice, popupid):
    if sourcerpg.isXa:
        __import__('xa.xa', fromlist = ['xa']).__dict__['sendMenu'](userid)
    
def sendAdmin():
    userid = es.getcmduserid()
    if sourcerpg.isAuthed(userid):
        popuplib.send('srpg_mainAdminMenu', userid)
    else:
        es.tell(userid, '#multi', 'You are not authorized to run the command \'rpg_admin\'')
if not es.exists('saycommand', 'rpg_admin'):
    es.regsaycmd('rpg_admin', 'sourcerpg/admin/sendAdmin')
if not es.exists('clientcommand', 'rpg_admin'):
    es.regclientcmd('rpg_admin', 'sourcerpg/admin/sendAdmin')
    
def isOnline(player):
    """ Returns True/False depnding on whether the player is currently online or not """
    return bool(es.getuserid(player))
    
def getSteamId(player):
    """ Return the steamid of the player despite the type and target I give it """
    steamid = None
    if str(player).isdigit():
        """ Okay, we were passed an integer, or a players userid; convert to steam """
        if es.exists('userid', player):
            steamid = playerlib.uniqueid(player, True)
    elif str(player).startswith(('STEAM_', 'BOT_')):
        """ We were passed a steamid, so do nothing; just check if the steamid is in the admin list """
        steamid = player
    else:
        """ Okay, we were either passed a name or something else... Check for userid via es.getuserid()"""
        tempUserid = es.getuserid(player)
        if es.exists('userid', tempUserid):
            steamid = playerlib.uniqueid(tempUserid, True)
    return steamid
    
def chooseSkill(userid, choice, popupid):
    """ This method runs when a player from the offline player list has been selected """
    function        = choice[1][0]
    skillMenu       = popuplib.easymenu('srpg_skillMenu_user%s' % userid, '_popup_choice', function)
    skillMenu.settitle('Sourcerpg Admin Offline Menu\nSelect a race from the player\'s list.')
    steamid         = choice[0]
    
    for skill in (('Health', 'Health +'), ('Regen', 'Regeneration'), ('RegenAmmo', 'Regenerate Ammo'), ('NapalmNade', 'Napalm Grenade'),\
                  ('Vampire', 'Vampire'), ('Stealth', 'Stealth'), ('LongJump', 'Long Jump'),\
                  ('IceStab', 'Ice Stab'), ('FrostPistol', 'Frost Pistol'), ('StunNade', 'Stun Grenade'), ('SmogNade', 'Smog Grenade'),\
                  ('Speed', 'Speed +'), ('Gravity', 'Gravity-'), ('Disable', 'Disable'), ('RecoverWeapons', 'Recover Weapons'), \
                  ('RegenArmor', 'Regenerate Armor'), ('Adrenaline', 'Adrenaline'), ('Medic', 'Medic') ):
        skillMenu.addoption([steamid, skill[0]], "%s (Current Level: %s)" % (skill[1], sourcerpg.players.query(skill[0], steamid) ) )
    skillMenu.send(userid)
    
def showSkills(userid, function):
    skillMenu = popuplib.easymenu('srpg_toggleSkills_user%s' % userid, '_popup_choice', function)
    skillMenu.settitle('Toggle a skill on or off')
    skillMenu.addoption('Health',         'Health+ %s'          % sourcerpg.IsEnabled(int( es.ServerVar('srpg_Health') ) ) )
    skillMenu.addoption('Regen',          'Regeneration %s'     % sourcerpg.IsEnabled(int( es.ServerVar('srpg_Regen') ) ) )
    skillMenu.addoption('RegenAmmo',      'Regenerate Ammo %s'  % sourcerpg.IsEnabled(int( es.ServerVar('srpg_RegenAmmo') ) ) )
    skillMenu.addoption('NapalmNade',     'Napalm Grenade %s'   % sourcerpg.IsEnabled(int( es.ServerVar('srpg_NapalmNade') ) ) )
    skillMenu.addoption('Vampire',        'Vampire %s'          % sourcerpg.IsEnabled(int( es.ServerVar('srpg_Vampire') ) ) )
    skillMenu.addoption('Stealth',        'Stealth %s'          % sourcerpg.IsEnabled(int( es.ServerVar('srpg_Stealth') ) ) )
    skillMenu.addoption('LongJump',       'Long Jump %s'        % sourcerpg.IsEnabled(int( es.ServerVar('srpg_LongJump') ) ) )
    skillMenu.addoption('IceStab',        'Ice Stab %s'         % sourcerpg.IsEnabled(int( es.ServerVar('srpg_IceStab') ) ) )
    skillMenu.addoption('FrostPistol',    'Frost Pistol %s'     % sourcerpg.IsEnabled(int( es.ServerVar('srpg_FrostPistol') ) ) )
    skillMenu.addoption('StunNade',       'Stun Grenade %s'     % sourcerpg.IsEnabled(int( es.ServerVar('srpg_StunNade') ) ) )
    skillMenu.addoption('SmogNade',       'Smog Grenade %s'     % sourcerpg.IsEnabled(int( es.ServerVar('srpg_SmogNade') ) ) )
    skillMenu.addoption('Speed',          'Speed+ %s'           % sourcerpg.IsEnabled(int( es.ServerVar('srpg_Speed') ) ) )
    skillMenu.addoption('Gravity',        'Gravity- %s'         % sourcerpg.IsEnabled(int( es.ServerVar('srpg_Gravity') ) ) )
    skillMenu.addoption('Disable',        'Disable %s'          % sourcerpg.IsEnabled(int( es.ServerVar('srpg_Disable') ) ) )
    skillMenu.addoption('RecoverWeapons', 'Recover Weapons %s'  % sourcerpg.IsEnabled(int( es.ServerVar('srpg_RecoverWeapons') ) ) )
    skillMenu.addoption('RegenArmor',     'Regenerate Armor %s' % sourcerpg.IsEnabled(int( es.ServerVar('srpg_RegenArmor') ) ) )
    skillMenu.addoption('Adrenaline',     'Adrenaline %s'       % sourcerpg.IsEnabled(int( es.ServerVar('srpg_Adrenaline') ) ) )
    skillMenu.addoption('Medic',          'Medic %s'            % sourcerpg.IsEnabled(int( es.ServerVar('srpg_Medic') ) ) )
    skillMenu.send(userid)
    
def warn(userid, choice, popupid = None):
    if popupid is None:
        function = choice
    else:
        function = choice[1][0]
    warn = popuplib.easymenu('srpg_warn_user%s' % userid, '_popup_choice', function)
    warn.settitle('WARNING!!!! This action cannot be reversed...\nAre you sure you want to do this?')
    if popupid is not None:
        warn.addoption([choice[0], "Yes"], "Yes")
        warn.addoption([choice[0], "No"], "No")
    else:
        warn.addoption("Yes", "Yes")
        warn.addoption("No", "No")
    warn.send(userid)
    
def createAmountList(userid, target, function, *args):
    """ 
    This function creates a default set of values to make it 'easier' to choose a value. If the player
    wants a custom value, then they can choose the 'custom' option.
    """
    try:
        amountMenu = popuplib.easymenu('srpg_amountList_user%s' % userid, '_popup_choice', sendFunctionWithValue)
        amountMenu.settitle('Select an amount')
        amountMenu.addoption([1,    function, target, args], "1"   )
        amountMenu.addoption([2,    function, target, args], "2"   )
        amountMenu.addoption([5,    function, target, args], "5"   )
        amountMenu.addoption([10,   function, target, args], "10"  )
        amountMenu.addoption([20,   function, target, args], "20"  )
        amountMenu.addoption([50,   function, target, args], "50"  )
        amountMenu.addoption([100,  function, target, args], "100" )
        amountMenu.addoption([1000, function, target, args], "1000")
        amountMenu.addoption(["custom", function, target, args], "Custom (escape menu)")
        amountMenu.submenu(10, 'srpg_mainAdminMenu')
        amountMenu.send(userid)
    except BaseException, e:
    	es.dbgmsg(0,'Popuplib: Exception when calling function "%s" for popup "%s":'%(f.func_name, p))
    	es.excepter(*sys.exc_info())
    
def sendFunctionWithValue(userid, choice, popupid):
    """ This function controls which function will be sent after a player chooses a value from the 'valuelist' popup """
    amount, function, target, args = choice
    if isinstance(amount, str) and amount == "custom":
        """ Okay, we have to send them an escape input box to input a custom value """
        es.tell(userid, '#multi', text('escmenu', {'prefix' : es.ServerVar('srpg_prefix')}, playerlib.getPlayer(userid).get("lang") ) )
        if args:
            """ We got some additional args, so join them via the <string>.join(<iterable>) """
            """ Note: The Function returns <function [function name] at [memory address] > so split it and return the value in item 1"""
            sourcerpg.chatInput.addInput(userid, globals()['%sInput'%str(function).split()[1]], 30, target, *args )
        else:
            """ No args, so just run the command with the target """
            sourcerpg.chatInput.addInput(userid, globals()['%sInput'%str(function).split()[1]], 30, target)
    else:
        """ We're calling the local function directly and passing the values """ 
        if callable(function):
            if args:
                """ Okay we have some args, so send them unpacked """
                function(userid, target, amount, *args)
            else:
                """ No additional arguments, so we have no need to send any. """
                function(userid, target, amount)
    
def onlineMenuMenuSelect(userid, choice, popupid):
    """ This method runs when an admin selects an option to do for the online players """
    if 1 <= choice <= 8:
        if choice == 1:
            createOnlinePlayerList(userid, giveLevel)
        elif choice == 2:
            createOnlinePlayerList(userid, giveXp)
        elif choice == 3:
            createOnlinePlayerList(userid, giveCredits)
        elif choice == 4:
            createOnlinePlayerList(userid, chooseSkill, upgradeLevel)
        elif choice == 5:
            createOnlinePlayerList(userid, chooseSkill, downgradeLevel)
        elif choice == 6:
            createOnlinePlayerList(userid, warn, deletePlayer)
        elif choice == 7:
            createOnlinePlayerList(userid, sendPlayerInfo)
        elif choice == 8:
            createOnlinePlayerList(userid, maxSkills)
    elif choice == 10:
        popuplib.send('srpg_mainAdminMenu', userid)
    else:
        popuplib.send('srpg_onlineMenu', userid)
    
def createOnlinePlayerList(admin, function, *args):
    onlinePlayerList = popuplib.easymenu('srpg_onlinePlayerList_user%s' % admin, '_popup_choice', function)
    onlinePlayerList.settitle('Select a player\nPage:')
    for player in es.getUseridList():
        steamid = getSteamId(player)
        if args:
            onlinePlayerList.addoption([steamid, args], es.getplayername(player))
        else:
            onlinePlayerList.addoption(steamid, es.getplayername(player))
    onlinePlayerList.submenu(10, 'srpg_onlineMenu')
    onlinePlayerList.cc_exitformat = "0. Back"
    onlinePlayerList.send(admin)
    
def offlineMenuMenuSelect(userid, choice, popupid):
    """ This method runs when an admin selects an option to do for the offline players """
    if 1 <= choice <= 7:
        if choice == 1:
            createOfflinePlayerList(userid, giveLevel)
        elif choice == 2:
            createOfflinePlayerList(userid, giveXp)
        elif choice == 3:
            createOfflinePlayerList(userid, giveCredits)
        elif choice == 4:
            createOfflinePlayerList(userid, chooseSkill, upgradeLevel)
        elif choice == 5:
            createOfflinePlayerList(userid, chooseSkill, downgradeLevel)
        elif choice == 6:
            createOfflinePlayerList(userid, warn, deletePlayer)
        elif choice == 7:
            createOfflinePlayerList(userid, sendPlayerInfo)
        elif choice == 8:
            createOfflinePlayerList(userid, maxSkills)
    elif choice == 10:
        popuplib.send('srpg_mainAdminMenu', userid)
    else:
        popuplib.send('srpg_offlineMenu', userid)
        
def createOfflinePlayerList(userid, function, *args):
    """ This function re-creates a new popup of all the players currently offline. """
    offlinePlayerList = popuplib.easymenu('srpg_offlinePlayerList_user%s' % userid, '_popup_choice', function) 
    offlinePlayerList.settitle('Select a player\nPage:')
    sourcerpg.players.execute("SELECT Steamid,Name FROM players ORDER BY Name ASC")
    if args:
        for steamid, name in sourcerpg.players.fetchall():
            if not es.exists('userid', es.getuserid(steamid) ):
                offlinePlayerList.addoption([steamid, args], "%s (%s)" % (name, steamid ) )
    else:
        for steamid, name in sourcerpg.players.fetchall():
            if not es.exists('userid', es.getuserid(steamid) ):
                offlinePlayerList.addoption(steamid, "%s (%s)" % (name, steamid ) )
    offlinePlayerList.submenu(10, 'srpg_offlineMenu')
    offlinePlayerList.cc_exitformat = "0. Back"
    offlinePlayerList.send(userid)
    
""" """
    
def giveLevel(userid, choice, popupid):
    createAmountList(userid, choice, commandGiveLevel)
    
def commandGiveLevel(userid, target, amount):
    sourcerpg.AdminAddLevel(userid, target, amount)
    popuplib.send('srpg_mainAdminMenu', userid)
        
def commandGiveLevelInput(userid, amount, target):
    if amount.isdigit():
        sourcerpg.AdminAddLevel(userid, target, amount)
        popuplib.send('srpg_mainAdminMenu', userid)

""" """
    
def giveXp(userid, choice, popupid):
    createAmountList(userid, choice, commandGiveXp)        
        
def commandGiveXp(userid , target, amount):
    sourcerpg.AdminAddXp(userid, target, amount, ' for being loved by an admin')
    popuplib.send('srpg_mainAdminMenu', userid)
    
def commandGiveXpInput(userid, amount, target):
    if amount.isdigit():
        sourcerpg.AdminAddXp(userid, target, amount, ' for being loved by an admin')
        popuplib.send('srpg_mainAdminMenu', userid)
    
""" """
    
def giveCredits(userid, choice, popupid):
    createAmountList(userid, choice, commandGiveCredits)
    
def commandGiveCredits(userid, target, amount):
    sourcerpg.AdminAddCredit(userid, target, amount, ' for being loved by an admin')
    popuplib.send('srpg_mainAdminMenu', userid)
    
def commandGiveCreditsInput(userid, amount, target):
    if amount.isdigit():
        sourcerpg.AdminAddCredit(userid, target, amount, ' for being loved by an admin')
        popuplib.send('srpg_mainAdminMenu', userid)
    
""" """
    
def upgradeLevel(userid, choice, popupid):
    target, skill = choice
    createAmountList(userid, target, commandUpgradeLevel, skill)
    
def commandUpgradeLevel(userid, target, amount, skill, sendMenu = True):
    """ This method gives the selected race additional levels, and also it initializes the event """
    maxLevel     = int(es.ServerVar('srpg_%sMax' % skill))
    currentLevel = sourcerpg.players.query(skill, target)
    if currentLevel + amount > maxLevel:
        amount = maxLevel - currentLevel
    sourcerpg.players.increment({skill : amount}, target)
    if sendMenu is True:
        popuplib.send('srpg_mainAdminMenu', userid)
    
def commandUpgradeLevelInput(userid, amount, target, skill):
    if amount.isdigit():
        commandUpgradeLevel(userid, target, int(amount), skill)
    
""" """ 
        
def downgradeLevel(userid, choice, popupid):
    target, skill = choice
    createAmountList(userid, target, commandDowngradeLevel, skill)
        
def commandDowngradeLevel(userid, target, amount, skill):
    """ This method gives the selected race additional levels, and also it initializes the event """
    currentLevel = sourcerpg.players.query(skill, target)
    if currentLevel - amount < 0:
        amount  -= abs(currentLevel - amount)
    sourcerpg.players.increment({skill : amount * -1}, target)
    popuplib.send('srpg_mainAdminMenu', userid)
    
def commandDowngradeLevelInput(userid, amount, target, skill):
    if amount.isdigit():
        commandDowngradeLevel(userid, target, int(amount), skill)
    
""" """
    
def sendToggleSkills(userid, choice, popupid):
    showSkills(userid, toggleSkill)
    
def toggleSkill(userid, choice, popupid):
    skill = 'srpg_%s' % choice
    if sourcerpg.IsEnabled(int(es.ServerVar(skill) ) ) == "[Enabled]":
        es.ServerVar(skill).set(0)
        es.tell(userid,'#green','The skill is now Deactivated.')
    else:
        es.ServerVar(skill).set(1)
        es.tell(userid,'#green','The skill is now Activated')
    showSkills(userid, toggleSkill)
        
def deletePlayer(userid, choice, popupid):
    target, choice = choice
    if choice == "Yes":
        sourcerpg.players.execute("DELETE FROM players WHERE Steamid='" + target + "'")
        if isOnline(target):
            userid = es.getuserid(target)
            sourcerpg.Command(userid).SetGravity(1.0)
            es.server.queuecmd('damage %s %s' % (userid, es.getplayerprop(userid, 'CBasePlayer.m_ihealth') ) )
            sourcerpg.player_activate({'userid' : userid, 'es_username' : es.getplayername(userid)})
    else:
        popuplib.send('srpg_mainAdminMenu', userid)
        
def sendDeleteDatabase(userid, choice, popupid):
    warn(userid, deleteDatabase)
        
def deleteDatabase(userid, choice, popupid):
    if choice == "Yes":
        sourcerpg.players.clear()
        for player in es.getUseridList():
            sourcerpg.Command(player).SetGravity(1.0)
            sourcerpg.player_activate({'userid' : player, 'es_username' : es.getplayername(player)})
        es.server.queuecmd('mp_restartgame 1')
    else:
        popuplib.send('srpg_mainAdminMenu', userid)

def sendPlayerInfo(userid, choice, popupid):
    ppopup = popuplib.easymenu('srpg_detailedPlayer_user%s' % userid, '_popup_choice', sendOption)
    ppopup.settitle("""\
Detailed Specification
----------------------
Total Time: %.2f hours
 
Level: %s
XP: %s
Credits: %s
 
""" % sourcerpg.players.query(("TotalTime", "Level", "Xp", "Credits"), choice) )
    ppopup.addoption([1, choice], 'Delete %s' % sourcerpg.players.query('Name', choice) )
    ppopup.addoption([2, choice], 'Give Xp')
    ppopup.addoption([3, choice], 'Give Levels')
    ppopup.addoption([4, choice], 'Give Credits')
    ppopup.cc_exitformat = "0. Back"
    ppopup.submenu(10, 'srpg_mainAdminMenu')
    ppopup.send(userid)
    
def sendOption(userid, choice, popupid):
    choice, target = choice
    if 1 <= choice <= 4:
        if choice == 1:
            warn(userid, (target, (deleteDatabase,) ), 'None' )
        elif choice == 2:
            giveXp(userid, target, '')
        elif choice == 3:
            giveLevel(userid, target, '')
        elif choice == 4:
            giveCredits(userid, target, '')
    else:
        sendPlayerInfo(userid, target, '')
        
def maxSkills(userid, choice, popupid):
    for skill in ('Health', 'Regen', 'RegenAmmo', 'NapalmNade',
                  'Vampire', 'Stealth', 'LongJump',
                  'IceStab', 'FrostPistol', 'StunNade', 'SmogNade',
                  'Speed', 'Gravity', 'Disable', 'RecoverWeapons', 
                  'RegenArmor', 'Adrenaline', 'Medic'):
        commandUpgradeLevel(userid, choice, int(es.ServerVar('srpg_%sMax' % skill)), skill, False)
    popuplib.send('srpg_mainAdminMenu', userid)
