import es, os

info = es.AddonInfo()
info.name     = "Addon Manager - Dynamic Manager"
info.version  = "2.0.2"
info.url      = "http://forums.mattie.info/cs/forums/viewtopic.php?p=257533"
info.basename = "addon_manager/manager"
info.author   = "DanielB"

am = es.import_addon('addon_manager')

class Addon:
    def __init__(self, loadname):
        self.loadname = loadname
        self.mapmanage = None
        self.playermanage = None
        self.maps = []
        self.players = 0
        
addons = {}
currentmap = es.ServerVar('eventscripts_currentmap')
    
def load():
    es.regcmd('am_control', 'addon_manager/manager/cmd', 'Addon Managers Dynamic Controller')
    cfgPath = es.getAddonPath('addon_manager/manager') + os.sep + 'settings.cfg'
    if os.path.isfile(cfgPath):
        es.server.queuecmd('es_xmexec ../addons/eventscripts/addon_manager/manager/settings.cfg')
    else:
        a = open(cfgPath, 'w')
        a.write('// You can place am_control cammands here')
        a.close()
    
    checkAll()
    amv = es.ServerVar('addon_manager_ver')
    amv.set(str(amv)+' m/%s'%info.version)

def isLoaded(loadname):
    return am.isLoaded(loadname)
    
def checkPlayers(basename):
    pCount = len(es.getUseridList())
    if not addons[basename].playermanage is None:
            if not addons[basename].playermanage:
                if addons[basename].players > pCount:
                    #es.server.queuecmd('es_load %s'%addons[basename].loadname)
                    return True
                else:
                    #es.server.queuecmd('es_unload %s'%addons[basename].loadname)
                    return False
            else:
                if addons[basename].players < pCount:
                    #es.server.queuecmd('es_load %s'%addons[basename].loadname)
                    return True
                else:
                    #es.server.queuecmd('es_unload %s'%addons[basename].loadname)
                    return False
    return None
    
def checkMap(basename):
    cmap = str(currentmap)
    if not addons[basename].mapmanage is None:
            if addons[basename].mapmanage:
                if cmap in addons[basename].maps: return True
                else: return False
            else:
                if cmap in addons[basename].maps: return False
                else: return True
    return None

def checkAddon(loadname):
    p = checkPlayers(loadname)
    c = checkMap(loadname)
    if (p and c) or (p is None and c) or (p and c is None):
        if not isLoaded(loadname):
            es.load(loadname)
    else:
        if isLoaded(loadname):
            es.unload(loadname)

def checkAll():
    for i in addons:
        checkAddon(addons[i].loadname)
        
      
def es_map_start(ev):
    checkAll()
        

def player_connect(ev):
    checkAll()

def player_disconnect(ev):
    checkAll() 
    
def cmd():
    global addons
    arg1 = es.getargv(1)
    argc = es.getargc()
    
    if arg1:
        if arg1 == 'include':
            loadname = es.getargv(2)
            if loadname:
                addons[loadname] = Addon(loadname)
            else:
                es.dbgmsg(0, 'invalid syntax: am_control include <addon>')
        elif arg1 == 'exclude':
            loadname = es.getargv(2)
            if loadname:
                if loadname in addons:
                    del loadname[addons]
                else:
                    es.dbgmsg(0, '%s was not being controlled!'%loadname)
        elif arg1 in addons:
            arg2 = es.getargv(2)
            arg3 = es.getargv(3)
            if argc == 4:
                if arg2 == 'map':
                    addons[arg1].mapmanage = True
                    addons[arg1].maps.append(arg3)
                elif arg2 == 'notmap':
                    addons[arg1].mapmanage = False
                    addons[arg1].maps.append(arg3)
                elif arg2 == 'players':
                    if arg3.startswith('<'): addons[arg1].playermanage = False
                    elif arg3.startswith('>'): addons[arg1].playermanage = True
                    else: 
                        es.dbgmsg(0, 'Invalid Syntax')
                        return
                    players = arg3[1:]
                    if players.isdigit():
                        addons[arg1].players = int(players)
                    else:
                        es.dbgmsg(0, 'Invalid Syntax')
                        addons[arg1].playermanage = None
        else:
            es.dbgmsg(0, 'Invalid syntax or addon has not been included')
            
    
    