#############################
#####- EDIT BELOW HERE -#####

## How long the tracers will stay (in seconds) | DEFAULT = 0.7 ##
at_duration = 0.7

## Set to one to make team coloured tracers, set to 0 for user-defined | DEFAULT = 0 [not team colours] ##
at_team_colours = 0

###- BUT NOT BELOW HERE! -###
#############################

import es,effectlib,popuplib,os.path,cPickle,gamethread

info = es.AddonInfo()
info.name = "awesomeTracer"
info.version = "1.00"
info.author = "DeathX9 [Xtreme Gaming]"
info.basename = "atracer"
info.url = "http://addons.eventscripts.com/addons/view/atracer"
info.description = "Bullet tracer addon in team colours or user selected colours"

es.ServerVar('atracer_ver','1.00','awesomeTracer Version').makepublic()

tdata = {}

def lcselect(userid,choice,popupname):
  global tdata
  steamid = es.getplayersteamid(userid)
  if choice == 'Green':
    tdata[steamid]['laser_blue'] = 0
    tdata[steamid]['laser_red'] = 0
    tdata[steamid]['laser_green'] = 255
    es.tell(userid,'#multi','#green[#lightgreenaTracer#green] You\'re tracer colour is now#lightgreen',choice)
  elif choice == 'Blue':
    tdata[steamid]['laser_blue'] = 255
    tdata[steamid]['laser_red'] = 0
    tdata[steamid]['laser_green'] = 0
    es.tell(userid,'#multi','#green[#lightgreenaTracer#green] You\'re tracer colour is now#lightgreen',choice)
  elif choice == 'Red':
    tdata[steamid]['laser_blue'] = 0
    tdata[steamid]['laser_red'] = 255
    tdata[steamid]['laser_green'] = 0
    es.tell(userid,'#multi','#green[#lightgreenaTracer#green] You\'re tracer colour is now#lightgreen',choice)
  elif choice == 'Purple':
    tdata[steamid]['laser_blue'] = 128
    tdata[steamid]['laser_red'] = 128
    tdata[steamid]['laser_green'] = 0
    es.tell(userid,'#multi','#green[#lightgreenaTracer#green] You\'re tracer colour is now#lightgreen',choice)
  elif choice == 'Yellow':
    tdata[steamid]['laser_blue'] = 0
    tdata[steamid]['laser_red'] = 255
    tdata[steamid]['laser_green'] = 255
    es.tell(userid,'#multi','#green[#lightgreenaTracer#green] You\'re tracer colour is now#lightgreen',choice)
  elif choice == 'Orange':
    tdata[steamid]['laser_blue'] = 0
    tdata[steamid]['laser_red'] = 255
    tdata[steamid]['laser_green'] = 165
    es.tell(userid,'#multi','#green[#lightgreenaTracer#green] You\'re tracer colour is now#lightgreen',choice)
  elif choice == 'White':
    tdata[steamid]['laser_blue'] = 255
    tdata[steamid]['laser_red'] = 255
    tdata[steamid]['laser_green'] = 255
    es.tell(userid,'#multi','#green[#lightgreenaTracer#green] You\'re tracer colour is now#lightgreen',choice) 

def load():
  global tdata
  es.regsaycmd('!tracer','atracer/showmenu')
  es.regsaycmd('!laser','atracer/showmenu')
  global lcmenu
  lcmenu = popuplib.easymenu('lasercolour_menu',None,lcselect)
  lcmenu.settitle('Select Tracer Colour:')
  lcmenu.setdescription('-aTracer v1.00-')
  lcmenu.addoption('Red','Red [Default]')
  lcmenu.addoption('Green','Green')
  lcmenu.addoption('Blue','Blue')
  lcmenu.addoption('Purple','Purple')
  lcmenu.addoption('Yellow','Yellow')
  lcmenu.addoption('Orange','Orange')
  lcmenu.addoption('White','White')
  global stmenu
  stmenu = popuplib.create('playerjoin_menu')
  stmenu.addline('--awesomeTracer--')
  stmenu.addline('---------------------')
  stmenu.addline(' ')
  stmenu.addline('awesomeTracer creates bullet tracers')
  stmenu.addline('(or lasers) where you shoot. To')
  stmenu.addline('pick what colour you want your tracer')
  stmenu.addline('to be, type !tracer or !laser in chat.')
  stmenu.addline(' ')
  stmenu.addline(' ')
  stmenu.addline(' ')
  stmenu.addline('0. Exit')
  str_path = es.getAddonPath('atracer') + '/tracerdata.db'
  if os.path.isfile(str_path):
    file_users = open(str_path)
    tdata = cPickle.load(file_users)
    file_users.close()
  for user in es.getUseridList():
    xsteam = es.getplayersteamid(user)
    if not tdata.has_key(xsteam):
      tdata[xsteam] = {}
      tdata[xsteam]['laser_blue'] = 0
      tdata[xsteam]['laser_red'] = 255
      tdata[xsteam]['laser_green'] = 0
  es.doblock('corelib/noisy_on')
  es.dbgmsg(0,'[awesomeTracer] Loaded!')

def showmenu():
  userid = es.getcmduserid()
  if at_team_colours != 1:
    lcmenu.send(userid)
  else:
    es.tell(userid,'#multi','#greenYou cannot change your tracer colour when#lightgreen team-coloured tracers#green are active.')

def dump_data():
  global tdata
  str_path = open(es.getAddonPath('atracer') + '/tracerdata.db', 'w')
  cPickle.dump(tdata, str_path)
  str_path.close()

def unload():
  es.doblock('corelib/noisy_off')
  dump_data()
  lcmenu.delete()
  stmenu.delete()
  es.unregsaycmd('!tracer')
  es.unregsaycmd('!laser')
  es.dbgmsg(0,'[awesomeTracer] Unloaded!')

def round_end(ev):
  dump_data()

def player_activate(ev):
  global tdata
  if not tdata.has_key(ev['es_steamid']):
    tdata[ev['es_steamid']] = {}
    tdata[ev['es_steamid']]['laser_blue'] = 0
    tdata[ev['es_steamid']]['laser_red'] = 255
    tdata[ev['es_steamid']]['laser_green'] = 0
    if at_team_colours != 1:
      stmenu.send(ev['userid'])
  if at_team_colours != 1:
    gamethread.delayed(5,es.tell,(ev['userid'],'#multi','#default----#greenTo change your#lightgreen tracer colour#green, type#lightgreen !tracer#green or#lightgreen !laser#green in chat#default----'))

def bullet_impact(ev):
  at_px,at_py,at_pz = es.getplayerlocation(ev['userid'])
  if at_team_colours == 1:
    if ev['es_userteam'] == '2':
      at_red = 255
      at_green = 0
      at_blue = 0
    elif ev['es_userteam'] == '3':
      at_red = 0
      at_green = 0
      at_blue = 255
  else:
    at_red = tdata[ev['es_steamid']]['laser_red']
    at_green = tdata[ev['es_steamid']]['laser_green']
    at_blue = tdata[ev['es_steamid']]['laser_blue']
  at_crouched = es.getplayerprop(ev['userid'],'CBasePlayer.localdata.m_Local.m_bDucked')
  if at_crouched == 1:
    at_pz += 44
  else:
    at_pz += 62
  at_vector = '%s,%s,%s'%(at_px,at_py,at_pz)
  at_vector2 = "%s,%s,%s"%(ev['x'],ev['y'],ev['z'])
  effectlib.drawLine(at_vector,at_vector2,'materials/sprites/laser.vmt','materials/sprites/laser.vmt',at_duration,'3','3',at_red,at_green,at_blue,'255','10','0','0','0','0')