# Scott Easterday
# CampPCT

import es
import playerlib
import popuplib

###################Config Section#########################

# Amount of time in seconds before CampPCT starts tracking
pre_camp = 30

# Percentage allowed to campe on the server
camp_pct = 60

# Amount of time in seconds before you start slapping
camp_count = 30

# The radius to consider as camping
camp_radius = 100

# Default: slap 5 heath every 5 percent over
# Example: 12% over would be 10 health
slap_pct = 5
slap_health = 5

###########################################################
#################Do Not Edit Below#########################
###########################################################

info = es.AddonInfo()
info.name = 'CampPCT'
info.version = '0.1'
info.basename = 'camppct'
info.author = 'Scottix@GMail.com'

# Init Variables
camp = {} # Count the number of time camping 
count = {} # Count the number of times checked
pct = {} # Current Percentage of user
dead = {} # Check if the player is dead
pos = {} # Players last position
total_count = 0 # This is used for initial time

def load():
	es.set(info.basename,info.version)
	es.makepublic(info.basename)
	es.msg('#multi','#green[CampPCT]#default Loaded.')
	
def unload():
	es.msg('#multi','#green[CampPCT]#default Unloaded.')

def init():
	global camp,count,pct,dead,pos,total_count

	# Init Variables
	camp = {}
	count = {}
	pct = {}
	dead = {}
	pos = {}
	total_count = 0

def player_say(e):
	global pct
	userid = e['userid']
	text = e['text']

	if(text == 'campers'):
		campers = popuplib.create('campers')
		campers.addline('->1 - Top Campers')
		counter = 0
		items = sorted(pct.items(), key=lambda(k,v):(v,k), reverse=True)
		for k, v in items:
			if (counter < 10):
				campers.addline(str(es.getplayername(k))+' - '+str(v)+'%')
			counter += 1
		campers.timeout('view',5)
		campers.send(userid)

def sorteddict(adict):
	keys = adict.keys()
	keys.sort()
	return map(adict.get, keys)

def player_activate(e):
	global camp,count,pct,dead,pos
	userid = e['userid']

	# Add player to array
	camp[userid] = 0
	count[userid] = 0
	pct[userid] = 0
	dead[userid] = 1
	pos[userid] = 0

def player_disconnect(e):
	global camp,count,pct,dead,pos
	userid = e['userid']

	# Remove player from array
	del camp[userid]
	del count[userid]
	del pct[userid]
	del dead[userid]
	del pos[userid]

def verify_vector(userid):
	global camp,camp_radius,count,pct,dead,pos
	
	if(dead[userid] == 0):
		loc = es.getplayerprop(userid,'CBaseEntity.m_vecOrigin')
		(x, y, z) = es.splitvectorstring(loc)
		(x2, y2, z2) = es.splitvectorstring(pos[userid])

		x = abs(x-x2)
		y = abs(y-y2)
		z = abs(z-z2)

		if((x < camp_radius) and (y < camp_radius) and (z < camp_radius)):
			camp[userid] += 1

		count[userid] += 1
		pct[userid] = round((float(camp[userid])/float(count[userid]))*100,0)
		pos[userid] = loc


def check_player():
	global pct,pre_camp,total_count
	if(total_count > pre_camp):
		for k, v in pct.iteritems():
			verify_vector(k)
	else:
		total_count += 1;
	es.delayed(1,'es_doblock camppct/check_player')


def es_map_start(e):
	init()
	check_player()

def player_spawn(e):
	global pct,count,dead,pos,camp_pct,camp_count,slap_pct,slap_health,total_count,pre_camp
	userid = e['userid']
	dead[userid] = 0
	loc = es.getplayerprop(userid,'CBaseEntity.m_vecOrigin')
	pos[userid] = loc

	if (pct[userid] >= camp_pct and count[userid] >= camp_count):
		slapped = 100 - (round(((pct[userid] - camp_pct) / slap_pct),0) * slap_health)
		player=playerlib.getPlayer(userid)
		player.set('health',slapped)
		es.tell(userid,'#multi','#green[CampPCT]#default '+str(pct[userid])+'% Camping rate slapped '+str(100-slapped)+' health.')
	elif (total_count <= pre_camp):
		es.tell(userid,'#multi','#green[CampPCT]#default Tracking begins in '+str(pre_camp-total_count)+' seconds')
	else:
		es.tell(userid,'#multi','#green[CampPCT]#default '+str(int(pct[userid]))+'% Camping rate')
	
def player_death(e):
	global dead
	userid = e['userid']
	dead[userid] = 1

def round_end(e):
	global dead
	for k, v in dead.iteritems():
		dead[k] = 1
