import es
import playerlib
import os.path
import random
import cPickle
import gamethread

enable_models = 1        # Should the Players get Models?
gift = 1                 # Should the Players can get a gift?
sound = 1                # Should the Players hear a sound, when joining?

info = es.AddonInfo()
info.name = "Xmas Mod"
info.version = "1.0"
info.author = "Popoklopsi"
info.url = "http://www.hlpr-clan.de/"
info.basename = "xmas"
info.description = "Xmas Mod with Gifts, Models and sound"

download3 = ['models/player/admin/xmas_grinch/terror.dx80.vtx', 'models/player/admin/xmas_grinch/terror.dx90.vtx', 'models/player/admin/xmas_grinch/terror.mdl', 'models/player/admin/xmas_grinch/terror.phy', 'models/player/admin/xmas_grinch/terror.sw.vtx', 'models/player/admin/xmas_grinch/terror.vvd', 'models/player/admin/xmas_grinch/terror.xbox.vtx', 'materials/models/player/admin/xmas_grinch/t_phoenix.vmt', 'materials/models/player/admin/xmas_grinch/t_phoenix.vtf']
download4 = ['materials/models/player/slow/santa_claus/slow_santa.vmt', 'materials/models/player/slow/santa_claus/slow_santa.vtf', 'materials/models/player/slow/santa_claus/slow_santa_bump.vtf', 'materials/models/player/slow/santa_claus/slow_santa_cloth.vmt', 'materials/models/player/slow/santa_claus/slow_santa_cloth.vtf', 'materials/models/player/slow/santa_claus/slow_santa_detail.vtf', 'models/player/slow/santa_claus/slow_fix.dx80.vtx', 'models/player/slow/santa_claus/slow_fix.dx90.vtx', 'models/player/slow/santa_claus/slow_fix.mdl', 'models/player/slow/santa_claus/slow_fix.phy', 'models/player/slow/santa_claus/slow_fix.sw.vtx', 'models/player/slow/santa_claus/slow_fix.vvd']
xpeople = {}
file = es.getAddonPath('xmas') + '/xmas.db'

def load():
	global xpeople
	if gift == 1:
		es.regsaycmd('!gift', 'xmas/getgift', 'Get the Gift')
		if os.path.isfile(file):
			file_players = open(file)
			xpeople = cPickle.load(file_players)
			file_players.close()
		else:
			save_dictionary()
	if enable_models == 1:
		gamethread.delayed(1, download,())
	if sound == 1:
		gamethread.delayed(1, download2,())
	es.set("%s" % info.basename,info.version)
	es.makepublic("%s" % info.basename)
	
def unload():
	if gift == 1:
		es.unregsaycmd('!gift')
		save_dictionary()
	
def download():
	for x in download3:
		es.stringtable("downloadables", x)
	for x in download4:
		es.stringtable("downloadables", x)

def download2():
	es.stringtable("downloadables", 'sound/xmas/xmas.mp3')
		
def round_start(ev):
	if gift == 1:
		save_dictionary()
		
def es_map_start(ev):
	if gift == 1:
		save_dictionary()
	if enable_models == 1:
		gamethread.delayed(1, download,())
	if sound == 1:
		gamethread.delayed(1, download2,())
		
def save_dictionary():
	file_players = open(file, 'wb')
	cPickle.dump(xpeople, file_players)
	file_players.close()
	
def es_player_validated(ev):
	if gift == 1:
		steamid2 = ev["networkid"]
		if steamid2 != 'BOT':
			if steamid2 != 'STEAM_ID_PENDING':
				if not xpeople.has_key(steamid2):
					xpeople[steamid2] = {}
					xpeople[steamid2]["gift"] = 0
					xpeople[steamid2]["giftname"] = 0
	
def player_spawn(ev):
	ran = int(ev['es_userteam'])
	player = playerlib.getPlayer(ev['userid'])
	steamid = ev['es_steamid']
	if enable_models == 1:
		if ran == 3:
			player.set("model", 'player/slow/santa_claus/slow_fix.mdl')
		if ran == 2:
			player.set("model", 'player/admin/xmas_grinch/terror.mdl')
	if gift == 1:
		if ev['es_steamid'] in xpeople:
			if xpeople[steamid]["gift"] == 0:
				es.tell(ev['userid'], '#multi', "#lightgreen It's #green Xmas Time #lightgreen, type #green !gift #lightgreen to get #green YOUR gift")
			if xpeople[steamid]["gift"] == 1:
				if xpeople[steamid]["giftname"] == 'hp1':
					hp = es.getplayerprop(ev['userid'], 'CBasePlayer.m_iHealth')
					es.setplayerprop(ev['userid'], 'CBasePlayer.m_iHealth', hp + 25)
				if xpeople[steamid]["giftname"] == 'hp2':
					hp = es.getplayerprop(ev['userid'], 'CBasePlayer.m_iHealth')
					es.setplayerprop(ev['userid'], 'CBasePlayer.m_iHealth', hp + 50)
				if xpeople[steamid]["giftname"] == 'hp3':
					hp = es.getplayerprop(ev['userid'], 'CBasePlayer.m_iHealth')
					es.setplayerprop(ev['userid'], 'CBasePlayer.m_iHealth', hp + 65)
				if xpeople[steamid]["giftname"] == 'deagle':
					gamethread.delayed(1, es.server.queuecmd, ('es_give %s weapon_deagle' %ev['userid']))
				if xpeople[steamid]["giftname"] == 'he':
					gamethread.delayed(1, es.server.queuecmd, ('es_give %s weapon_hegrenade' %ev['userid']))
				if xpeople[steamid]["giftname"] == 'flash':
					gamethread.delayed(1, es.server.queuecmd, ('es_give %s weapon_flashbang' %ev['userid']))
				if xpeople[steamid]["giftname"] == 'speed':
					es.setplayerprop(ev['userid'], 'CBasePlayer.localdata.m_flLaggedMovementValue', 1.2)
					
def player_activate(ev):
	if sound == 1:
		gamethread.delayed(5, es.cexec_all,('play xmas/xmas.mp3'))
				
def getgift():
	if gift == 1:
		userid = es.getcmduserid()
		steamid3 = es.getplayersteamid(userid)
		name = es.getplayername(userid)
		if xpeople[steamid3]["gift"] == 0:
			rzahl = random.randint(1, 7)
			if rzahl == 1:
				xpeople[steamid3]["giftname"] = 'hp1'
				es.msg('#multi', "#green %s's #lightgreen gift is #green 25 Extra HP" % name)
			if rzahl == 2:
				xpeople[steamid3]["giftname"] = 'hp2'
				es.msg('#multi', "#green %s's #lightgreen gift is #green 50 Extra HP" % name)
			if rzahl == 3:
				xpeople[steamid3]["giftname"] = 'hp3'
				es.msg('#multi', "#green %s's #lightgreen gift is #green 65 Extra HP" % name)
			if rzahl == 4:
				xpeople[steamid3]["giftname"] = 'deagle'
				es.msg('#multi', "#green %s's #lightgreen gift is #green a extra Deagle" % name)
			if rzahl == 5:
				xpeople[steamid3]["giftname"] = 'he'
				es.msg('#multi', "#green %s's #lightgreen gift is #green a extra Hegrenade" % name)
			if rzahl == 6:
				xpeople[steamid3]["giftname"] = 'flash'
				es.msg('#multi', "#green %s's #lightgreen gift is #green a extra Flashbang" % name)
			if rzahl == 7:
				xpeople[steamid3]["giftname"] = 'speed'
				es.msg('#multi', "#green %s's #lightgreen gift is #green a 0.2 extra Speed" % name)
			xpeople[steamid3]["gift"] = 1
		else:
			es.tell(ev['userid'], '#multi', '#lightgreen You have already #green Your gift!')
		