import timeparse  #A custom module to make it easier to turn minute:second timing into pure second timing

#PURPOSE
	#To parse a karaoke txt file into its various parts and return them as global variables.

def parse(songFile , onpc = False):
	#We're setting a lot of global variables instead of simply returning the seperate parts of the file as a list
    global lyrics
    global times
    global songBin
    global songTitle
    global length
    if not onpc:
        import es
        songFile = gamedir = str(es.ServerVar('eventscripts_gamedir')) +'/addons/eventscripts/karaoke/' + songFile + '.txt'  #We're going to assume that ALL song files are in this dir.  And also that it doesn't include the .txt

    lyrics = [] #Define lyrics and times as lists
    times = []
    f = open(songFile , 'r')  #Open the song file in read only mode
    rawList = f.readlines()  #Simply dump all the lines on to a list
    f.close()  #Close the file...
    SsongBin = False
    Slength = False
    SsongTitle = False
    #songBin = rawList.pop(0)  #Grab the first entry on the list, which is assumed to be the name of the lyric file's mp3
    #length = timeparse.parse(rawList.pop(0))  #Grabs the second entry on the list, which is assumed to be the song's length
    #songTitle = rawList.pop(0)  #Grabs the third entry, assumed to be the song's Artist -- Title (but it doesn't have to be)
    for i in range(len(rawList)):  #Every entry left in the list is assumed to be lyric lines.  (We don't have to specifiy a starting point because pop actually REMOVES the next in line from the list
        cLI = rawList.pop(0).strip(' ')  #cLI (current list item) Grab the raw "minute:second=Lyrics go here"
        if not cLI.startswith('#') and cLI != '\n' and cLI != '\r\n':  #BOOL FAIL.  Basically, if it doesn't start with a '#', isn't a linux newline, and isn't a windows newline, it will pass.
            if not SsongBin:
                songBin = cLI.strip('\n')
                SsongBin = True
            elif not Slength:
                length = timeparse.parse(cLI)
                Slength = True
            elif not SsongTitle:
                songTitle = cLI.strip('\n')
                SsongTitle = True
            else:
                TLtuple = cLI.partition('=')  #Divide cLI by the first = sign on the list  item
                times.append(timeparse.parse((TLtuple[0])))  #add the current timing code to the times list (the first intry on the tuple previously defined).  It also parses any time using a colon into pure seconds.
                lyrics.append(TLtuple[2].strip('\n'))  #Add the current lyric to the lyrics list (the third entry on TLtuple).  It removes any whitespace before or after the lyric in the process
