
import es
import os
import time
import socket
import urllib2
import datetime
import gamethread

info = es.AddonInfo()
info.name      = 'ServSecurity'
info.version   = '0.1'
info.basename  = 'servsecurity'
info.author    = 'Dark Session'

es.ServerVar('servsecurity', info.version, 'Powerful script by Dark Session to prevent server lags, hacking attemps, abuse and crashes').makepublic()

BlockedCommands = [
    "_restart",
    "cmd",
    "dbghist_addline",
    "dbghist_dump",
    "dump_entity_sizes",
    "dump_globals",
    "dump_terrain",
    "dumpcountedstrings",
    "dumpentityfactories",
    "dumpeventqueue",
    "ent_create",
    "ent_fire",
    "exit",
    "groundlist",
    "listmaps",
    "ListServerUserMessages",
    "nextmap",
    "ma_map",
    "ma_showrestrict",
    "ma_timeleft",
    "mem_dump",
    "mp_dump_timers",
    "physics_debug_entity",
    "physics_select",
    "quit",
    "quti",
    "report_entities",
    "report_touchlinks",
    "restart",
    "rr_reloadresponsesystems",
    "scene_flush",
    "soundscape_flush",
    "sv_soundemitter_filecheck",
    "sv_soundemitter_flush",
    "sv_soundscape_printdebuginfo",
    "timeleft",
    "wc_update_safe_entities"
    ]

ForbiddenUsernames = [
    "",
    "0",
    "unnamed",
    "unconnected",
    "empty"
    ]

TmpIPs = {}
BlockedCMDs = []

UpdatecheckURL = "http://www.swiss-esport.ch/servsecurity/updatecheck.php"
ScriptVersion = info.version
_AllowUnload = False
_UnloadPassword = ""
_UpdateCheck = True
securevar = ""

def load():
    global securevar

    log("Load ServSecurity...")

    gamethread.cancelDelayed('ss_thread1')
    gamethread.cancelDelayed('ss_thread2')
    gamethread.cancelDelayed('ss_thread3')

    DefaultVars = {
                "servsecurity_logtype": 1,
                "servsecurity_cmdblocker": 1,
                "servsecurity_ipblocker": 1,
                "servsecurity_maxconnects": 5,
                "servsecurity_blockusernames": 1,
                "servsecurity_crashreport": 1,
                "servsecurity_disablerconexploit": 1,
                "servsecurity_kicksteamidpending": 1,
                "servsecurity_kicksvcheatsbypass": 1,
                "servsecurity_protectrconpassword": 1
                }

    es.regcmd('servsecurity_unload', 'servsecurity/UnloadServSecurity', 'Unload the ServSecurity script (password required)')
    es.regcmd('servsecurity_setpassword', 'servsecurity/SetServSecurityPassword', 'Set the ServSecurity password')

    for Varname in DefaultVars:
        if not es.exists('variable', Varname):
            VarDefault = DefaultVars[Varname]
            es.set(Varname, VarDefault)

    es.server.cmd("exec servsecurity.cfg")

    if int(es.ServerVar('servsecurity_crashreport')) == 1:
        reportfile = es.getAddonPath('servsecurity') + "/crashreport.txt"
        if not os.path.isfile(reportfile):
            fp = open(reportfile, 'w')
            fp.write("")
            fp.close()

        tmpfile = es.getAddonPath('servsecurity') + "/tmpcrashreport.txt"

        if os.path.isfile(tmpfile):
            fp = open(tmpfile, 'r')
            crashtime = fp.read(128)
            fp.close()
            if crashtime:
                crashtime = float(crashtime)
                if crashtime > 0:
                    crash = datetime.datetime.fromtimestamp(crashtime)
                    now = datetime.datetime.now()
                    logtext = "Server crashed at %s.%s.%s %s:%s:%s! Started at %s.%s.%s %s:%s:%s" % (crash.day, crash.month, crash.year, crash.hour, crash.minute, crash.second, now.day, now.month, now.year, now.hour, now.minute, now.second)
                    log(logtext)
                    fp = open(reportfile, 'a')
                    fp.write(logtext)
                    fp.close()
        else:
            fp = open(tmpfile, 'w')
            fp.write(str(time.time()))
            fp.close()

        Backgrounder()

    if int(es.ServerVar('servsecurity_cmdblocker')) == 1:
        for blockedcmd in BlockedCommands:
            doblockcmd(blockedcmd)
        log("%s Commands auto-blocked!" % len(BlockedCommands))
        es.regcmd("es_blockcommand", "servsecurity/blockcmd", "Blocks a command (adds cheat flag)")
        es.regcmd("es_unblockcommand", "servsecurity/unblockcmd", "Unblocks a command")


    if int(es.ServerVar('servsecurity_disablerconexploit')) == 1:
        es.forcevalue('sv_rcon_minfailures', 99999999)
        es.forcevalue('sv_rcon_maxfailures', 99999999)
        es.forcevalue('sv_rcon_minfailuretime', 1)
        log("Disabled RCON-PW-Crash-Exploit")

    Backgrounder2()

    if int(es.ServerVar('servsecurity_protectrconpassword')) == 1:
        securevar = str(es.ServerVar('rcon_password'))
        if securevar != "":
            log("RCON-Password catched")
        es.flags('add','notify','rcon_password')
        es.flags('add','notify','eventscripts_protectrcon')
        # Against bypasses
        Backgrounder3()

    log('ServSecurity loaded')
    es.forcevalue('sv_cheats', 0)
    CheckUpdates()


def unload():
    global _AllowUnload
    log("Unload ServSecurity...")

    if _UnloadPassword != "" and not _AllowUnload:
        gamethread.delayed(0.5, es.server.queuecmd, ("es_load servsecurity"))
        gamethread.delayed(0.6, es.server.queuecmd, ("servsecurity_setpassword %s" % _UnloadPassword))
        log("Prevented from unloading!")
    else:
        _AllowUnload = True

    tmpfile = es.getAddonPath('servsecurity') + "/tmpcrashreport.txt"

    if os.path.isfile(tmpfile):
        tmpfile = es.getAddonPath('servsecurity') + "/tmpcrashreport.txt"
        fp = open(tmpfile, 'w')
        fp.write(str("0"))
        fp.close()

    if int(es.ServerVar('servsecurity_cmdblocker')) == 1 and _AllowUnload:
        for blockedcmd in BlockedCommands:
            dounblockcmd(blockedcmd)

    gamethread.cancelDelayed('ss_thread1')
    gamethread.cancelDelayed('ss_thread2')
    gamethread.cancelDelayed('ss_thread3')
    es.flags('add', 'remove', 'rcon_password')
    es.flags('add', 'remove', 'eventscripts_protectrcon')

    log('ServSecurity unloaded')

def server_shutdown(ev):
    log("Server shutdown")
    tmpfile = es.getAddonPath('servsecurity') + "/tmpcrashreport.txt"
    if os.path.isfile(tmpfile):
        tmpfile = es.getAddonPath('servsecurity') + "/tmpcrashreport.txt"
        fp = open(tmpfile, 'w')
        fp.write(str("0"))
        fp.close()

def server_cvar(ev):
    global securevar

    var = ev["cvarname"]
    value = ev["cvarvalue"]
    if var == "sv_cheats":
        es.forcevalue('sv_cheats', 0)
        log("sv_cheats changed! Resetted!")
    elif var == "rcon_password":
        if securevar != "":
            es.forcevalue('rcon_password', securevar)
            log("RCON-Password changed! Resetted!")
        else:
            securevar = str(es.ServerVar('rcon_password'))
            if securevar != "":
                log("RCON-Password catched")
    elif var == "eventscripts_protectrcon":
        es.forcevalue("eventscripts_protectrcon", 1)
        log("eventscripts_protectrcon changed! Resetted!")

def SetServSecurityPassword():
    global _UnloadPassword
    global _AllowUnload
    if es.getargc() < 2:
        log("Set ServSecurity password failed! No password!")
        return

    pw = es.getargv(1)
    if _UnloadPassword == "":
        if len(pw) < 6:
            log("Set ServSecurity password failed! Too short!")
            return
        _UnloadPassword = pw
        log("ServSecurity password set!")
    else:
        log("Set ServSecurity password failed! Password already set!")

def UnloadServSecurity():
    global _AllowUnload
    if _UnloadPassword == "":
        _AllowUnload = True
        es.server.queuecmd("es_unload servsecurity")
        return

    if es.getargc() < 2:
        log("ServSecurity unload failed! No password!")
        return

    pw = es.getargv(1)
    if pw != _UnloadPassword:
        _AllowUnload = False
        log("ServSecurity unload failed! Wrong password!")
    else:
        _AllowUnload = True
        es.server.queuecmd("es_unload servsecurity")

def CheckUpdates():
    if not _UpdateCheck:
        return

    try:
        socket.setdefaulttimeout(0.5)
        fp = urllib2.urlopen(UpdatecheckURL)
        new_version = float(fp.read())
        fp.close()
        if new_version > float(ScriptVersion):
            log("New ServSecurity Update available!")
            es.msg("#multi", "#green New ServSecurity Update available!")
            es.msg("#multi", "#lightgreen New ServSecurity Update available!")
        else:
            log("ServSecurity up-to-date!")
    except:
        return

def round_start(ev):
    if int(es.ServerVar('servsecurity_disablerconexploit')) == 1:
        es.forcevalue('sv_rcon_minfailures', 99999999)
        es.forcevalue('sv_rcon_maxfailures', 99999999)
        es.forcevalue('sv_rcon_minfailuretime', 1)

        log("Disabled RCON-PW-Crash-Exploit")

def player_connect(ev):
    if int(es.ServerVar('servsecurity_blockusernames')) == 1:
        username = ev["name"].replace(" ", "").replace("	", "").replace(".", "").replace("_", "")

        if username in ForbiddenUsernames or len(username) <= 1:
            es.server.insertcmd("kickid %s [ServSecurity] Use a REAL username!" % ev["userid"])
            log("User %s kicked for using a forbidden username!" % ev["name"])
            return
        elif len(username) >= 32:
            es.server.insertcmd("kickid %s [ServSecurity] Your username is too long (max. 31 Characters)" % ev["userid"])
            log("User %s kicked for using a too long username!" % ev["name"])
            return
        elif '%' in username or "\\x" in username or '\x03' in username or '\x04' in username:
            es.server.insertcmd("kickid %s [ServSecurity] Your username contains invalid characters!" % ev["userid"])
            log("User %s kicked for using invalid characters in his username" % ev["name"])
            return

    if int(es.ServerVar('servsecurity_ipblocker')) == 1:
        tmp = ev["address"].split(":")
        ip = tmp[0]
        if ip == "127.0.0.1":
            return
        if not TmpIPs.has_key(ip):
            TmpIPs[ip] = 1
        else:
            TmpIPs[ip] += 1

        if TmpIPs[ip] >= int(es.ServerVar('servsecurity_maxconnects')):
            es.server.insertcmd("kickid %s [ServSecurity] Too many connection attempts! Your IP got banned!" % ev["userid"])
            es.server.insertcmd("addip 86400 %s" % ip)
            log("IP %s banned for too many connection attemps" % ip)
            return

def player_activate(ev):
    if int(es.ServerVar('servsecurity_kicksteamidpending')) == 1:
        steamid = ev["es_steamid"]
        if steamid == "STEAM_ID_PENDING":
            es.server.queuecmd("kickid %s [ServSecurity] Your Steam-ID is still pending! Try again!" % ev["userid"])

    # To check more "bad" clientvars, please use
    # http://addons.eventscripts.com/addons/view/enforcevars

    if int(es.ServerVar('servsecurity_kicksvcheatsbypass')) == 1:
        sv_cheats = es.ServerVar('sv_cheats')
        if es.getclientvar(ev["userid"], 'sv_cheats') == 1 and not sv_cheats in [1,"1"]:
            es.server.queuecmd("kickid %s [ServSecurity] sv_cheats bypass? :-P" % ev["userid"])

def Backgrounder():
    if int(es.ServerVar('servsecurity_crashreport')) == 1:
        gamethread.delayedname(2, 'ss_thread1', Backgrounder, ())
    try:
        tmpfile = es.getAddonPath('servsecurity') + "/tmpcrashreport.txt"
        fp = open(tmpfile, 'w')
        fp.write(str(time.time()))
        fp.close()
    except e:
        return

def Backgrounder2():
    global TmpIPs

    if int(es.ServerVar('servsecurity_ipblocker')) == 1:
        gamethread.delayedname(60, 'ss_thread2', Backgrounder2, ())

    TmpIPs = {}

def Backgrounder3():
    global securevar
    gamethread.delayedname(5, 'ss_thread3', Backgrounder3, ())
    es.forcevalue('eventscripts_protectrcon', 1)
    es.forcevalue('sv_cheats', 0)

    if securevar != "":
        if es.ServerVar('rcon_password') != securevar:
            es.forcevalue('rcon_password', securevar)
            log("RCON-Password changed! Resetted!")
    else:
        securevar = str(es.ServerVar('rcon_password'))
        if securevar != "":
            log("RCON-Password catched")

def log(text):
    logtype = int(es.ServerVar('servsecurity_logtype'))
    if logtype == 0:
        return

    now = datetime.datetime.now()
    text = "[ServSecurity Log @ %s.%s.%s %s:%s:%s] %s" % (now.day, now.month, now.year, now.hour, now.minute, now.second, text)

    if logtype in [1,3]:
        es.log(text)
    if logtype in [2,3]:
        try:
            file = es.getAddonPath('servsecurity') + "/logs/log.txt"
            fp = open(file, 'a')
            fp.write(text + "\r\n")
            fp.close()
        except e:
            es.log(text)

def blockcmd():
    arguments = es.getargc()
    cmdname = es.getargv(1)
    if arguments < 2:
        es.dbgmsg(0, "ES-Security: %s requires 1 parameter! %s <command_name>" % (cmdname, cmdname))
        return
    blockcmd = es.getargv(2)
    doblockcmd(blockcmd)


def doblockcmd(cmd):
    if cmd in BlockedCMDs:
        es.dbgmsg(0, "ServSecurity: Command %s is already blocked!" % cmd)
        return False

    es.flags('add', 'cheat', cmd)
    BlockedCMDs.append(cmd)
    log("%s is now a blocked command!" % cmd)
    return True


def unblockcmd():
    arguments = es.getargc()
    cmdname = es.getargv(0)
    if arguments < 2:
        es.dbgmsg(0, "ServSecurity: %s requires 1 parameter! %s <command_name>" % (cmdname, cmdname))
        return
    bannedcmd = es.getargv(1)
    dounbancmd(bannedcmd)


def dounblockcmd(blockedcmd):
    if not blockedcmd in BlockedCMDs:
        es.dbgmsg(0, "ServSecurity: Command %s is not blocked!" % blockedcmd)
        return False

    es.flags('remove', 'cheat', blockedcmd)
    BlockedCMDs.remove(blockedcmd)
    log("Command %s is now unblocked!" % blockedcmd)
    return True