# ./addons/eventscripts/extendedevents/events/player_zone.py

"""
player_zone
"""


""" Event imports """

import es
import vecmath

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerZone(extendedevents.Event):
   def __init__(self, gamename):
      if gamename <> 'cstrike': raise NotImplementedError, 'Event player_zone (player_bombzone/player_buyzone/player_rescuezone) is only available for CS:S'

      self.players = {}

   def mapStart(self):
      self.loadRes('player_zone')
      self.players.clear()

   def playerSpawn(self, userid):
      self.players[userid] = {'bomb':self.getBombZone(userid), 'buy':self.getBuyZone(userid), 'rescue':self.getRescueZone(userid), 'site':'UNKNOWN'}

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]

   def tick(self, useridlist):
      for userid in useridlist:
         if userid in self.players:
            player = self.players[userid]

            oldstate = player['bomb']
            newstate = player['bomb'] = self.getBombZone(userid)

            if oldstate <> newstate:
               if newstate:
                  action = 'ENTER'
                  site   = player['site'] = self.findSiteName(userid)

               else:
                  action, site, player['site'] = 'EXIT', player['site'], 'UNKNOWN'

               self.fire('player_bombzone', {'userid':('int', userid), 'action':('string', action), 'site':('string', site)})

            oldstate = player['buy']
            newstate = player['buy'] = self.getBuyZone(userid)

            if oldstate <> newstate:
               self.fire('player_buyzone', {'userid':('int', userid), 'action':('string', 'ENTER' if newstate else 'EXIT')})

            oldstate = player['rescue']
            newstate = player['rescue'] = self.getRescueZone(userid)

            if oldstate <> newstate:
               self.fire('player_rescuezone', {'userid':('int', userid), 'action':('string', 'ENTER' if newstate else 'EXIT')})

         else:
            self.playerSpawn(userid)

   @staticmethod
   def findSiteName(userid):
      managerindex = es.getentityindex('cs_player_manager')
      if managerindex > 0:
         a_location      = vecmath.vector(es.getindexprop(managerindex, 'CCSPlayerResource.m_bombsiteCenterA'))
         b_location      = vecmath.vector(es.getindexprop(managerindex, 'CCSPlayerResource.m_bombsiteCenterB'))
         player_location = es.getplayerlocation(userid)

         for index in es.createentitylist('func_bomb_target'):
            current_min = vecmath.vector(es.getindexprop(index, 'CBaseEntity.m_Collision.m_vecMins'))
            current_max = vecmath.vector(es.getindexprop(index, 'CBaseEntity.m_Collision.m_vecMaxs'))
            if vecmath.isbetweenRect(player_location, current_min, current_max):
               if vecmath.isbetweenRect(a_location, current_min, current_max):
                  return 'A'
               elif vecmath.isbetweenRect(b_location, current_min, current_max):
                  return 'B'

               break

      return "UNKNOWN"

   @staticmethod
   def getBombZone(userid):
      return es.getplayerprop(userid, 'CCSPlayer.m_bInBombZone') % 2

   @staticmethod
   def getBuyZone(userid):
      return es.getplayerprop(userid, 'CCSPlayer.m_bInBuyZone') % 2

   @staticmethod
   def getRescueZone(userid):
      return es.getplayerprop(userid, 'CCSPlayer.m_bInHostageRescueZone') % 2


""" Event return function """

def getEvent():
   return PlayerZone