# ./addons/eventscripts/extendedevents/events/player_water.py

"""
player_water
"""


""" Event imports """

import es

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerWater(extendedevents.Event):
   def __init__(self, gamename):
      self.waterlevel = {}

   def mapStart(self):
      self.waterlevel.clear()
      self.loadRes('player_water')

   def playerSpawn(self, userid):
      self.waterlevel[userid] = self.getState(userid)

   def playerDisconnect(self, userid):
      if userid in self.waterlevel:
         del self.waterlevel[userid]

   def tick(self, useridlist):
      for userid in useridlist:
         if userid in self.waterlevel:
            oldval = self.waterlevel[userid]
            newval = self.waterlevel[userid] = self.getState(userid)

            if oldval <> newval:
               self.fire('player_water', {'userid':('int', userid), 'state':('int', newval)})

         else:
            self.playerSpawn(userid)

   @staticmethod
   def getState(userid):
      return es.getplayerprop(userid, 'CBasePlayer.localdata.m_nWaterLevel')


""" Event return function """

def getEvent():
   return PlayerWater