# ./addons/eventscripts/extendedevents/events/player_nightvision.py

"""
player_nightvision
"""


""" Event imports """

import es

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerNightvision(extendedevents.Event):
   def __init__(self, gamename):
      if gamename <> 'cstrike': raise NotImplementedError, 'Event player_nightvision is only available for CS:S'

      self.players = {}

   def mapStart(self):
      self.loadRes('player_nightvision')
      self.players.clear()

   def playerSpawn(self, userid):
      self.players[userid] = self.getState(userid)

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]

   def tick(self, useridlist):
      for userid in useridlist:
         if userid in self.players:
            oldstate = self.players[userid]
            newstate = self.players[userid] = self.getState(userid)

            if oldstate <> newstate:
               self.fire('player_nightvision', {'userid':('int', userid), 'state':('string', 'ON' if newstate else 'OFF')})

         else:
            self.players[userid] = self.getState(userid)

   @staticmethod
   def getState(userid):
      return es.getplayerprop(userid, 'CCSPlayer.m_bNightVisionOn') % 2


""" Event return function """

def getEvent():
   return PlayerNightvision