# ./addons/eventscripts/extendedevents/events/player_money.py

"""
player_money
weapon_purchase
"""


""" Event imports """

import es

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerMoney(extendedevents.Event):
   def __init__(self, gamename):
      if gamename <> 'cstrike': raise NotImplementedError, 'Event player_money (player_money/weapon_purchase) is only available for CS:S'

      self.players  = {}
      self.entities = {}

      self.registerForEvent('player_money', 'item_pickup', self.itemPickup)

   def mapStart(self):
      self.loadRes('player_money')

      self.players.clear()
      self.entities.clear()

   def playerSpawn(self, userid):
      self.players[userid] = self.getCash(userid)

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]

   def tick(self, useridlist):
      self.entities = es.createentitylist()

      for userid in useridlist:
         if userid in self.players:
            oldcash = self.players[userid]
            newcash = self.players[userid] = self.getCash(userid)

            if oldcash <> newcash:
               self.fire('player_money', {'userid':('int', userid), 'amount':('int', newcash), 'old_amount':('int', oldcash), 'change_amount':('int', newcash - oldcash)})

         else:
            self.players[userid] = self.getCash(userid)

   def itemPickup(self, event_var):
      userid = int(event_var['userid'])
      item   = event_var['item']

      index = self.getWeaponIndex(userid, item)
      if index in self.entities: return

      if userid in self.players:
         oldcash = self.players[userid]
         newcash = self.players[userid] = self.getCash(userid)

         cost = oldcash - newcash

      else:
         cost = 0

      self.fire('weapon_purchase', {'userid':('int', userid), 'weapon':('string', item), 'cost':('int', cost), 'index':('int', index)})
      self.entities = es.createentitylist()

   def unload(self):
      self.unregisterForEvent('player_money', 'item_pickup')

   @staticmethod
   def getCash(userid):
      return es.getplayerprop(userid, 'CCSPlayer.m_iAccount')

   @staticmethod
   def getWeaponIndex(userid, weapon):
      handle = es.getplayerhandle(userid)
      for index in es.createentitylist('weapon_' + weapon):
         if handle == es.getindexprop(index, 'CBaseEntity.m_hOwnerEntity'):
            return index

      return -1


""" Event return function """

def getEvent():
   return PlayerMoney