# ./addons/eventscripts/extendedevents/events/player_jump.py
# Submitted by EmbouT -- thanks!

import es
import psyco
psyco.full()

from extendedevents import extendedevents

class PlayerJump(extendedevents.Event):
   def __init__(self, gamename):
      if gamename <> 'dod': raise NotImplementedError, 'Event player_jump is only available for DoD:S'
      self.players = {}

   def mapStart(self):
      self.loadRes('player_jump')
      self.players.clear()

   def playerSpawn(self, userid):
      self.players[userid] = False

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]

   def tick(self, useridlist):
      for userid in useridlist:
         if userid in self.players:
            if self.getFallVelocity(userid) < 0 and self.getGroundEntity(userid) == -1:
               if not self.players[userid]:
                  self.players[userid] = True
                  self.fire('player_jump', {'userid':('int', userid)})
            else:
               self.players[userid] = False

   @staticmethod
   def getFallVelocity(userid):
      return es.getplayerprop(userid, "CBasePlayer.localdata.m_Local.m_flFallVelocity")

   @staticmethod
   def getGroundEntity(userid):
      return es.getplayerprop(userid, "CBasePlayer.localdata.m_hGroundEntity")

def getEvent():
   return PlayerJump