# ./addons/eventscripts/extendedevents/events/player_health.py

"""
player_health
"""


""" Event imports """

import es

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerHealth(extendedevents.Event):
   def __init__(self, gamename):
      self.players = {}

   def mapStart(self):
      self.loadRes('player_health')
      self.players.clear()

   def playerSpawn(self, userid):
      self.players[userid] = self.getHealth(userid)

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]

   def tick(self, useridlist):
      for userid in useridlist:
         if userid in self.players:
            oldhealth = self.players[userid]
            newhealth = self.players[userid] = self.getHealth(userid)

            if oldhealth <> newhealth:
               self.fire('player_health', {'userid':('int', userid), 'old_health':('int', oldhealth), 'change_health':('int', newhealth - oldhealth)})

         else:
            self.players[userid] = self.getHealth(userid)

   @staticmethod
   def getHealth(userid):
      return es.getplayerprop(userid, 'CBasePlayer.m_iHealth')


""" Event return function """

def getEvent():
   return PlayerHealth