# ./addons/eventscripts/extendedevents/events/player_flashed.py

"""
player_flashed
"""


""" Event imports """

import es
import gamethread

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerFlashed(extendedevents.Event):
   def __init__(self, gamename):
      if gamename <> 'cstrike': raise NotImplementedError, 'Event player_nightvision is only available for CS:S'

      self.players = {}
      self.blinded = set()
      self.flashed = set()

      self.registerForEvent('player_flashed', 'round_start', self.roundStart)
      self.registerForEvent('player_flashed', 'player_blind', self.playerBlind)
      self.registerForEvent('player_flashed', 'flashbang_detonate', self.flashbangDetonate)

   def mapStart(self):
      self.loadRes('player_flashed')
      self.clearDelays()
      self.players.clear()

   def playerSpawn(self, userid):
      self.players[userid] = self.getFlash(userid)

   def playerDeath(self, userid):
      self.removeDelay(userid)

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]
      self.removeDelay(userid)

   def tick(self, useridlist):
      for userid in useridlist:
         if userid in self.players:
            oldstate = self.players[userid]
            newstate = self.players[userid] = self.getFlash(userid)

            if oldstate <> newstate:
               alpha, duration = newstate
               if alpha and duration:
                  self.fire('player_flashed', {'userid':('int', userid), 'attacker':('int', 0), 'alpha':('int', alpha), 'duration':('float', duration)})
                  self.addFlash(userid, duration)

               elif userid in self.flashed:
                  self.removeDelay(userid)
                  self.fire('player_unflashed', {'userid':('int', userid)})

         else:
            self.players[userid] = self.getFlash(userid)


   def roundStart(self, event_var):
      self.blinded.clear()
      self.clearDelays()

   def playerBlind(self, event_var):
      self.blinded.add(int(event_var['userid']))

   def flashbangDetonate(self, event_var):
      attacker = int(event_var['userid'])
      for userid in self.blinded:
         alpha, duration = self.players[userid] = self.getFlash(userid)
         self.fire('player_flashed', {'userid':('int', userid), 'attacker':('int', attacker), 'alpha':('int', alpha), 'duration':('float', duration)})
         self.addFlash(userid, duration)

      self.blinded.clear()


   def unflash(self, userid):
      self.fire('player_unflashed', {'userid':('int', userid)})

      if userid in self.flashed:
         self.flashed.remove(userid)

   def addFlash(self, userid, duration):
      self.flashed.add(userid)
      gamethread.delayedname(duration, 'extendedevents_player_flashed_%s' % userid, self.unflash, userid)

   def removeDelay(self, userid):
      if userid in self.flashed:
         self.flashed.remove(userid)
         gamethread.cancelDelayed('extendedevents_player_flashed_%s' % userid)

   def clearDelays(self):
      for userid in self.flashed:
         gamethread.cancelDelayed('extendedevents_player_flashed_%s' % userid)
      self.flashed.clear()

   def unload(self):
      self.clearDelays()

      self.unregisterForEvent('player_flashed', 'round_start')
      self.unregisterForEvent('player_flashed', 'player_blind')
      self.unregisterForEvent('player_flashed', 'flashbang_detonate')

   @staticmethod
   def getFlash(userid):
      return es.getplayerprop(userid, 'CCSPlayer.m_flFlashMaxAlpha'), es.getplayerprop(userid, 'CCSPlayer.m_flFlashDuration')


""" Event return function """

def getEvent():
   return PlayerFlashed