# ./addons/eventscripts/extendedevents/events/player_flag.py


"""
map_end
player_air
player_flag
player_land
"""


""" Event imports """

import es

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerFlag(extendedevents.Event):
   map_ended = False

   def __init__(self, gamename):
      self.players = {}

   def mapStart(self):
      self.loadRes('player_flag')
      self.players.clear()

      self.map_ended = False

   def playerSpawn(self, userid):
      self.players[userid] = self.getFlags(userid)

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]

   def tick(self, useridlist):
      mapend = not self.map_ended
      for userid in useridlist:
         if userid in self.players:
            oldval = self.players[userid]
            newval = self.players[userid] = self.getFlags(userid)

         else:
            oldval = newval = self.players[userid] = self.getFlags(userid)

         for x in range(32):
            newstate = newval >> x & 1
            if newstate <> oldval >> x & 1:
               if not x:
                  self.fire('player_land' if newstate else 'player_air', {'userid':('int', userid)})
               self.fire('player_flag', {'userid':('int', userid), 'flag':('int', x), 'state':('string', 'ON' if newstate else 'OFF')})

            if x == 5 and not newstate:
               mapend = False

      if mapend and useridlist:
         self.fire('map_end')
         self.map_ended = True

   @staticmethod
   def getFlags(userid):
      return es.getplayerprop(userid, 'CBasePlayer.m_fFlags')


""" Event return function """

def getEvent():
   return PlayerFlag