# ./addons/eventscripts/extendedevents/events/player_duck.py

"""
player_duck
player_unduck
"""


""" Event imports """

import es

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerDuck(extendedevents.Event):
   def __init__(self, gamename):
      self.ducking = {}

   def mapStart(self):
      self.ducking.clear()
      self.loadRes('player_duck')

   def playerSpawn(self, userid):
      self.ducking[userid] = self.getState(userid)

   def playerDisconnect(self, userid):
      if userid in self.ducking:
         del self.ducking[userid]

   def tick(self, useridlist):
      for userid in useridlist:
         if userid in self.ducking:
            oldval = self.ducking[userid]
            newval = self.ducking[userid] = self.getState(userid)

            if oldval <> newval:
               if newval:
                  self.fire('player_duck', {'userid':('int', userid)})

               else:
                  self.fire('player_unduck', {'userid':('int', userid)})

         else:
            self.playerSpawn(userid)

   @staticmethod
   def getState(userid):
      return es.getplayerprop(userid, 'CBasePlayer.localdata.m_Local.m_bDucked') % 2


""" Event return function """

def getEvent():
   return PlayerDuck