# ./addons/eventscripts/extendedevents/events/player_drop.py

"""
player_activeweapon
player_drop
"""


""" Event imports """

import es
import gamethread

import psyco
psyco.full()


""" ExtendedEvents import """

from extendedevents import extendedevents


""" Event class """

class PlayerDrop(extendedevents.Event):
   def __init__(self, gamename):
      self.players = {}

   def mapStart(self):
      self.loadRes('player_drop')
      self.players.clear()

   def playerSpawn(self, userid):
      self.players[userid] = es.createplayerlist(userid)[userid]['weapon']

   def playerDisconnect(self, userid):
      if userid in self.players:
         del self.players[userid]

   def tick(self, useridlist):
      playerlist = es.createplayerlist()
      for userid in playerlist:
         if userid in self.players:
            oldweapon = self.players[userid]
            newweapon = self.players[userid] = playerlist[userid]['weapon']

            if oldweapon <> newweapon:
               self.fire('player_activeweapon', {'userid':('int', userid), 'weapon':('string', newweapon), 'old_weapon':('string', oldweapon)})

         else:
            self.players[userid] = playerlist[userid]['weapon']

   def clientFilter(self, userid, args):
      if args[0].lower() == 'drop':
         weapon = self.players[userid] = es.createplayerlist(userid)[userid]['weapon']
         gamethread.delayedname(0, 'extendedevents.player_drop', self._drop, (userid, weapon, self.getWeaponIndex(userid, weapon)))

   def _drop(self, userid, weapon, weapon_index):
      if es.createplayerlist(userid)[userid]['weapon'] == weapon: return

      index = -1
      if es.createentitylist(weapon_index):
         if es.getindexprop(weapon_index, 'CBaseEntity.m_hOwnerEntity') == -1:
            index = weapon_index

      self.fire('player_drop', {'userid':('int', userid), 'weapon':('string', weapon), 'index':('int', index)})

   def unload(self):
      gamethread.cancelDelayed('extendedevents.player_drop')

   @staticmethod
   def getWeaponIndex(userid, weapon):
      handle = es.getplayerhandle(userid)
      for index in es.createentitylist(weapon):
         if handle == es.getindexprop(index, 'CBaseEntity.m_hOwnerEntity'):
            return index

      return -1


""" Event return function """

def getEvent():
   return PlayerDrop