# ./addons/eventscripts/extendedevents/events/example_event.py


""" Event imports """

# Import modules used by the event

import es

import psyco
psyco.full()


""" ExtendedEvents import """

# Required by the event class for the extendedevents.Event subclass.

from extendedevents import extendedevents


""" Event class """

# This is the crux of the event. Each event class is a subclass of the extendedevents.Event class:

class ExampleEvent(extendedevents.Event):
   def __init__(self, gamename):
      """
      Initialize elements of the event. mapStart is called immediately after this function.
      Raise NotImplementedError if the event does not support the gamename (cstrike/dod/hl2mp/tf).
      """
      pass

   def mapStart(self):
      """
      Called when the map starts or the event is loaded.
      Good idea to call self.loadRes here to load the .res file.
      """
      pass

   def playerSpawn(self, userid):
      """
      Called when a player spawns with the player's userid as an integer.
      """
      pass

   def playerDisconnect(self, userid):
      """
      Called when a player disconnects with the player's userid as an integer.
      """
      pass

   def tick(self, useridlist):
      """
      Called several times a second (exact delay between calls determined by the extendedevents_tickstoupdate cvar) with the output from es.getUseridList().
      """
      pass

   def clientFilter(self, userid, args):
      """
      Called when a client uses a console command caught by the filter.
      Arguments are similiar to ES client command filters.
      """
      pass

   def unload(self):
      """
      Called when the individual event or ExtendedEvents is unloaded.
      """
      pass

   """
   Helper functions included in extendedevents.Event:

   def fire(self, name, event_var={}) # Fires an event where "event_var" is a dictionary of the event var types (int/string/float) and values indexed by name
   # Ex. self.fire('example_event', {'userid':('int', 4), 'weapon':('string', 'knife'), 'diving_score':('float', 8.6)}

   def loadRes(self, name) # Loads a .res file in the events folder (./addons/eventscripts/extendedevents/events/<name>.res)
   # Ex. self.loadRes('example_event')

   def registerForEvent(self, name, event, callback) # Registers the current class to receive events from ES
   # Ex. self.registerForEvent('example_event', 'item_pickup', self.itemPickup)
   # def itemPickup(self, event_var)

   def unregisterForEvent(self, name, event) # Unregisters an event received by the current class
   # NOTE: You _MUST_ unregister every registered event in unload.
   # Ex. self.unregisterForEvent('example_event', 'item_pickup')
   """


""" Event return function """

# Every event must have one of these. It is called by ExtendedEvents to load the event.

def getEvent():
   return ExampleEvent