#!/usr/bin/env python
# -*- coding: utf-8 -*- 
#
#       serverad.py
#       
#       Copyright 2009 k1llf1rst2 <www.eguclan.de>
#       
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.

#		Requirements:
#			EventScripts 2.0.0.250a or higher ( http://forums.eventscripts.com/ )

#		Installation:
#
#		1) Make sure if you matched all requirements.
#		2) Copy all files /addons/eventscripts/serverad/* to your gameserver directory
#		3) Edit the settings.cfg and the languages.ini to your liking
#		4) Add 'es_load serverad' to your autoexec.cfg or another .cfg file or load it via rcon 'rcon es_load serverad'
#		5) Restart your server or change your map ( only necessary when not loaded via rcon )
#		6) Done!

#		Notes:
#           This addon only supports Source Gameservers.
#           Special thanks to Adz and his serverRedirect Addon. It's a great one and I wanted to modify it :D

import es
import path
import base64
import cfglib
import langlib
import serverlib
import gamethread
from Queue import Queue
import threading

info = es.AddonInfo()
info.name = "ServerAd"
info.basename = "serverad"
info.author = "k1llf1rst2"
info.version = "1.1 Beta"
info.description = "An addon that advertises other servers"
info.url = "http://addons.eventscripts.com/addons/view/serverad"

config = cfglib.AddonCFG(es.getAddonPath("serverad") + "/settings.cfg")

config.text("******************************")
config.text("  ServerAd Settings")
config.text("******************************")

lang = config.cvar("serverad_language", "en", "Defines the language in which all adverts will be displayed (de/en)")
interval = config.cvar("serverad_interval", 300, "Defines the time interval in seconds in which adverts are being displayed. Must be integer")
startDelay = config.cvar("serverad_startdelay", 15, "Defines the time interval in seconds in which the server starts querying. Must be integer")
useHostname = config.cvar("serverad_hostname", 0, "Enables/Disables displaying the hostname")
use_altHostname = config.cvar("serverad_alternative_hostname", 1, "Enables/Disables displaying an alternative hostname instead of the hostname ( recommed if hostnames are too long )")
cssTag = config.cvar("serverad_csstag", "#green[#lightgreenCSS#green]", "Defines a tag that is being used in the advert. To disable leave it blank")
tf2Tag = config.cvar("serverad_tf2tag", "#green[#lightgreenTF2#green]", "Defines a tag that is being used in the advert. To disable leave it blank")
l4dTag = config.cvar("serverad_l4dtag", "#green[#lightgreenL4D#green]", "Defines a tag that is being used in the advert. To disable leave it blank")
otherTag = config.cvar("serverad_othertag", "", "Defines a tag that is being used in the advert. To disable leave it blank")

config.write()

ini = cfglib.AddonINI(es.getAddonPath('serverad') + '/languages.ini')

ini.setInitialComments(['******************************', 'ServerAd Language Settings', '******************************'])

ini.addGroup('ServerAd Announcement')
ini.addValueToGroup('ServerAd Announcement', 'en', '$tag #lightgreen$hostname #default- #lightgreen$ip#default - #lightgreen$player_online#default/#green$max_player #defaultplayers currently online')
ini.addValueToGroup('ServerAd Announcement', 'de', '$tag #lightgreen$hostname #default- #lightgreen$ip#default - #lightgreen$player_online#default/#green$max_player #defaultSpieler online')
ini.setGroupComments('ServerAd Announcement', 'Define here your message. Edit it to your liking ;)')

Comments = [ 'Variables:', ' - $tag : Displays the tag defined in your settings.cfg', ' - $hostname : Displays the hostname or the alternative hostname', ' - $ip : Displays the serverip', ' - $player_online : Displays the amount of online players', ' - $max_player : Displays the maximum amount of players that can be online (Slots)', ' - $map : Displays the current map which runs on the server', ' - $version : Displays the network version of the server', ' - $gamedir : Displays the name of the folder containing the game files', ' - $bots : Displays the number of bots currently playing on the server', ' - $dedicated : Displays l for listen, d for dedicated and p for SourceTV', ' - $os : Displays the host operating system. l for linux and w for windows', ' - $pw : Displays if a password is required to join the server', ' - $secure : Displays if the server is VAC secured', ' - $gamever : Displays the game version', '', 'Colours:', ' - #default : Displays a yellow text. Usage: #default<Text>. Example: #defaultHello!. Output: Hello!. Yellow string!', ' - #green : Displays a green text. Same usage as #default.', ' - #lightgreen : Displays a lightgreen text. Same usage as #default.' ]
ini.setFinalComments(Comments)
ini.write()

text = langlib.Strings(ini)

serverList = []
hostnameList = []
indexCount = None
threadKilled = False

class serverQuery(threading.Thread):    
    def run(self):
        global text
        global serverList
        global hostnameList
        global threadKilled
        while True and threadKilled == False: 
            tempVar = queue.get() 
            if tempVar is None:
                continue  
            ip, port = tempVar
            try: 
                server = serverlib.SourceServer(ip, int(port), 5) 
                details = server.getDetails()           
                server.disconnect() 
            except serverlib.SourceServerError: 
                logAction('Error: Unable to connect to server!', 'Retrieving: %s' %(tempVar))
                continue
          
	    if useHostname == 1 and use_altHostname == 0:
	        hostname = details['server name']
	    elif use_altHostname == 1 and useHostname == 0:
                id = serverList.index(tempVar)
                hostname = hostnameList[id]
	    else:
	        logAction('Error: Logical error! Using server hostname!', 'Cvars useHostname and use_altHostname can\'t have the same value')
                hostname = details['server name']
		
	    if details['game description'] == 'Counter Strike: Source':
	        tag = cssTag
	    elif details['game description'] == 'Team Fortress 2':
	        tag = tf2Tag
	    elif details['game description'] == 'Left 4 Dead':
                tag = l4dTag
	    else:
	        tag = otherTag
			
            tokens = {}	
            tokens['tag'] = tag
            tokens['hostname'] = hostname
            tokens['ip'] = ip + ':' + port
            tokens['player_online'] = details['number of players']
            tokens['max_player'] = details['maximum players']
            tokens['map'] = details['map']
            tokens['version'] = details['version']
            tokens['gamedir'] = details['game directory']
            tokens['bots'] = details['number of bots']
            tokens['dedicated'] = details['dedicated']
            tokens['os'] = details['os']
            tokens['pw'] = details['password']
            tokens['secure'] = details['password']
            tokens['gamever'] = details['game version']
            es.msg('#multi', text('ServerAd Announcement', tokens, lang))			
                
queue = Queue()
serverQuery().start()

def load():
    if info.author != base64.decodestring(base64.decodestring("YXpGc2JHWXhjbk4wTWc9PQ==")): 
       for x in range(1, 10):
		   es.msg("This server fakes addons and tells they made them!!!")
       logAction('Error: Addon faked! Unable to process!', 'ServerAd is about to unload.')
       es.unload("serverad")
    es.ServerVar("serverad_version", info.version).makepublic()
    filePath = es.getAddonPath("serverad")
    serverFile = filePath + '/server.txt'
    hostnameFile = filePath + '/hostname.txt'
    
    if path.path(serverFile).isfile():
       f = open(serverFile)
       for x in filter(lambda x: not x.startswith('//'), f.readlines()):
         serverList.append(x.strip())
       f.close()
    else:
       handleFile(serverFile, '// ###################################\n// ###  ServerAd Serverconfig File ###\n// ###################################\n//\n// Add Servers here!\n// Usage: <serverIP>:<serverPort>\n// Example: 84.38.74.222:27015\n// Note: One line per Server! Comments are only allowed at the beginning of a line. In case of a comment the whole line will be ignored. <ServerIP:Port> // Coment won\'t work!\n//\n')
	
    if path.path(hostnameFile).isfile():
       f = open(hostnameFile)
       for x in filter(lambda x: not x.startswith('//'), f.readlines()):
          hostnameList.append(x.strip())
       f.close()
    else:
       handleFile(hostnameFile, '// #####################################\n// ### ServerAd Hostnameconfig File  ###\n// #####################################\n//\n// Add alternative hostnames here!\n// Usage: <serverAlternativeHostname>\n// Example: Dust2 Only Gameserver\n// Note: One line per alternative hostname! Will be ignored if use_alt_hostname set to 0.\n//\n')
       		
    config.execute()	
    serverCount = len(serverList)
    global indexCount
    indexCount = serverCount - 1	
    
    if serverCount == 0: 
       logAction('Error: No servers defined', 'ServerAd is about to unload.')
       es.unload("serverad")
    else:
       gamethread.delayed(startDelay, queuePut, (0))

def unload():
    global threadKilled
    threadKilled = True
    queue.put(None)
	
def handleFile(filename, text):
    f = open(filename, 'a')
    f.write(text)
    f.close()
	
def queuePut(id):
    global indexCount
    if serverList:
        x = serverList[id]
        x = x.split(':', 1)
        queue.put((x[0], x[1]))
	
        upperID = id + 1
    	
	if id >= indexCount:
            gamethread.delayed(interval, queuePut, (0))
	elif id < indexCount:
	    gamethread.delayed(interval, queuePut, (upperID))
	
def logAction(line1, line2):
    es.log('--------------------------------------------------')
    es.log('[ServerAd] %s' %(line1))
    es.log('[ServerAd] %s' %(line2))
    es.log('--------------------------------------------------')