import es, math, vecmath, playerlib, os, langlib

import psyco
psyco.full()

# Set the addon info data
info = es.AddonInfo()
info.name = 'Distance Checker'
info.version = '1.0.0'
info.url = 'http://addons.eventscripts.com/addons/view/distance_checker'
info.basename = 'distance_checker'
info.author = 'Freddukes AKA Pro Noob'

# Make Public Variable
es.ServerVar('distance_checker',info.version,'Distance Checker Version - Made by Freddukes').makepublic()

NearList = {}
dict_options = {
'dc_allow_type':['all','Who is allowed to track their nearest enemy?'],
'dc_admin_list':['STEAM_ID_LAN;STEAM_0:1:10717798', 'The people who are allowed to see oher players positions and angles.']
}
admin_list = []
text = None

def load():
    global text
    global admin_list
    global admin_list
    
    for option in dict_options:
        es.ServerVar(option,dict_options[option][0],dict_options[option][1])
    
    admin_list = str(es.ServerVar('dc_admin_list')).replace(' ','').split(';')
    
    langpath = es.getAddonPath('distance_checker') + '/strings.ini'
    if os.path.isfile(langpath):
        text = langlib.Strings(langpath)
        es.dbgmsg(0,'Distance Checker: Successfully Loaded \'strings.ini\'')
    else:
        es.dbgmsg(0,'Distance Checker: - ERROR Unable to load strings.ini! Please ensure it is in the ./distance_checker/ directory.')
    if not text:
        text = 'Missing Language'
        
    if os.path.isfile(es.getAddonPath('distance_checker') + '/config.cfg'):
        es.server.cmd('es_xmexec ../addons/eventscripts/distance_checker/config.cfg')
        es.dbgmsg(0,'Distance Checker: Successfully Loaded \'config.cfg\'')
    else:
        es.dbgmsg(0,'Distance Checker: ERROR - Unable to load config.cfg! Please ensure it is in the ./distance_checker/ directory.')
    
    noisy = es.ServerVar('eventscripts_noisy')
    es.doblock('corelib/noisy_on')
    if not int(noisy):
        noisy_set = True
        noisy.set(1)
    
def unload():
    es.doblock('corelib/noisy_off')
    
def player_footstep(ev):
    if ev['es_steamid'] != 'BOT' and (str(es.ServerVar('dc_allow_type')).lower() == 'all' or ev['es_steamid'] in admin_list):
        GetNearList(ev['userid'])
        if len(NearList):
            nearest_player = sorted(NearList, SortDict)[0]
            distance = NearList[nearest_player]
            nearest_player_name = es.getplayername(nearest_player)
            UpdateHudHint(nearest_player_name, distance, ev['userid'], nearest_player)

def return_angle(watcher, target):
    wl = vecmath.vector(es.getplayerlocation(watcher))
    wp = playerlib.getPlayer(watcher)
    tl = vecmath.vector(es.getplayerlocation(target))
    line = tl - wl
    line['z'] = 0
    viewvec = vecmath.vector(wp.get('viewvector'))
    viewvec['z'] = 0
    return vecmath.angle(line, viewvec) 
        
def UpdateHudHint(name, distance, userid, victim):
    angle = math.degrees(return_angle(userid, victim))
    lang = playerlib.getPlayer(userid).get('lang')
    if 0 <= angle < 10:
        aMessage = text('very close',{}, lang)
    elif 10 <= angle < 50:
        aMessage = text('close',{}, lang)
    elif 50 <= angle < 100:
        aMessage = text('moderate',{}, lang)
    elif 100 <= angle < 170:
        aMessage = text('far',{}, lang)
    elif 170 <= angle:
        aMessage = text('distant',{}, lang)
        
    es.usermsg("create", "distance_checker", "HintText")
    es.usermsg("write","short","distance_checker",-1)
    es.usermsg("write","string","distance_checker", text('hudhint', {'name':name, 'distance':round(abs(distance), 1), 'angle': aMessage}, lang))
    es.usermsg("send","distance_checker",userid,0)
    es.usermsg("delete","distance_checker")
        
def GetNearList(userid):
    global NearList
    team = es.getplayerteam(userid)
    xx,yy,zz = es.getplayerlocation(userid)
    NearList = {}
    for player in es.getUseridList():
        if not int(es.getplayerprop(player, 'CBasePlayer.pl.deadflag')):
            if es.getplayerteam(player) != team and es.getplayerteam(player) > 1:        
                x,y,z = es.getplayerlocation(player)
                NearList[player] = (((xx - x) * 2 + (yy - y) * 2 + (zz - z) * 2) * 0.5) / 40.0
        
def SortDict(item1, item2):
    item1 = abs(item1)
    item2 = abs(item2)
    if NearList[item1] < NearList[item2]: return -1
    if NearList[item1] == NearList[item2]: return 0
    return 1
