import es, cfglib, keyvalues, usermsg

info = es.AddonInfo()
info['name'] = "Teamspeak"
info['basename'] = "teamspeak"
info['version'] = "1.1"
info['author'] = "derrick1123"
info['url'] = ""
info['description'] = "Teamspeak Connection Through Server"

es.ServerVar(info['basename'], info['version'], info['description']).makepublic()

addonpath = es.getAddonPath('teamspeak')
config = cfglib.AddonCFG(addonpath + '/config.cfg')
config.text('**********************\n// ** Teamspeak Options **\n// **********************')
host = config.cvar('ts_hostname','ts.website-service.org','Hostname/IP for your TS')
port = config.cvar('ts_port',"8767",'TS Port Number')
tsnick = config.cvar('ts_nick',"cssplayer",'TS User\'s nick name (If Any)') 
cname = config.cvar('ts_channelname',"BH Game Servers Chat",'Channel Name for your TS (If Any)')
cpass = config.cvar('ts_channelpassword',"",'Password for your Channel (If Any)')
scname = config.cvar('ts_subchannelname'," - Lobby -", 'SubChannel Name for your TS (If Any)')
admins_only = config.cvar('admins_only',0,'1 = Yes, 0 = No - Will allow only admins in admin_list to use the ts_cmd')
admin_list = config.cvar('admin_list',"STEAM_0:0:19182226,STEAM_LAN", 'Insert SteamID\'s For Admins qualified to execute the ts cmd')
mani_support = config.cvar('mani_support',"Off",'Use clients.txt from mani for the admin list. Options: On & Off')
ts_cmd = config.cvar('ts_cmd',"!ts",'Use clients.txt from mani for the admin list. Options: On & Off')
config.write()

ts_url = 'teamspeak://%s:%s?nickname= %s?channel=%s?channelpassword=%s?subchannel=%s'%(host,port,tsnick,cname,cpass,scname)
es.dbgmsg(0, 'Your Teamspeak Connection URL: %s'%ts_url)
es.dbgmsg(0, 'Your Teamspeak Connection Command: %s'%ts_cmd)

def load():
  global admin_list
  config.execute()
  if admins_only == 1:
    if mani_support == "On" or mani_support == "on":
      es.keygroupcreate("clients")
      clients = keyvalues.getKeyGroup("clients")
      clients.load("cfg/mani_admin_plugin/clients.txt")
      admin_list = [x['steam'] for x in clients['players']]
      es.dbgmsg(0, 'Mani Support On. Auto-Detected Admins from Mani Clients.txt')
    elif mani_support == "Off" or mani_support == "off":
      es.dbgmsg(0, 'Mani Support Off. Default admin_list Executed!')
    else:
      es.dbgmsg(0, 'Invalid mani_support value, please check the config.cfg')
      es.unload('teamspeak')
  if not es.exists('saycommand', str(ts_cmd)):
    es.regsaycmd(str(ts_cmd), 'teamspeak/ts_cmd_reg')
  es.msg('#multi', '#default[#greenTeamspeak#default] by #lightgreenderrick1123 #defaulthas been loaded!')

def ts_cmd_reg():
  user = es.getcmduserid()
  if admins_only == 1:
    if es.getplayersteamid(user) not in '%s'%admin_list:
      es.tell(user, '#multi', '#default[#greenTeamspeak#default] You must be an admin to use this command!')
    else:
      usermsg.showVGUIPanel(user, 'info', False, {'type':2, 'title':'Teamspeak Connect', 'msg':ts_url})
  else:
    usermsg.showVGUIPanel(user, 'info', False, {'type':2, 'title':'Teamspeak Connect', 'msg':ts_url})

def unload():
  if es.exists('saycommand', str(ts_cmd)):
    es.unregsaycmd(str(ts_cmd))
  es.msg('#multi', '#default[#greenTeamspeak#default] by #lightgreenderrick1123 #defaulthas been unloaded!')
  
def round_start(ev):
  if admins_only != 1:
	es.msg('#multi', '#default[#greenTeamspeak#default] by #lightgreenderrick1123 #defaultis running!')
	es.msg('#multi', '#default[#greenTeamspeak#default] type %s to join in our teamspeak.'%ts_cmd)